/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.container.entries.metadata;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.util.Util;
import org.infinispan.container.entries.ExpiryHelper;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.metadata.MetadataAware;
import org.infinispan.container.entries.metadata.MetadataMortalCacheValue;
import org.infinispan.container.entries.metadata.MetadataTransientMortalCacheEntry;
import org.infinispan.metadata.Metadata;

public class MetadataTransientMortalCacheValue
extends MetadataMortalCacheValue
implements MetadataAware {
    long lastUsed;

    public MetadataTransientMortalCacheValue(Object v, Metadata metadata, long created, long lastUsed) {
        super(v, metadata, created);
        this.lastUsed = lastUsed;
    }

    @Override
    public InternalCacheEntry toInternalCacheEntry(Object key) {
        return new MetadataTransientMortalCacheEntry(key, this.value, this.metadata, this.lastUsed, this.created);
    }

    @Override
    public long getMaxIdle() {
        return this.metadata.maxIdle();
    }

    @Override
    public long getLastUsed() {
        return this.lastUsed;
    }

    @Override
    public boolean isExpired(long now) {
        return ExpiryHelper.isExpiredTransientMortal(this.metadata.maxIdle(), this.lastUsed, this.metadata.lifespan(), this.created, now);
    }

    @Override
    public long getExpiryTime() {
        long muet;
        long lifespan = this.metadata.lifespan();
        long lset = lifespan > -1L ? this.created + lifespan : -1L;
        long maxIdle = this.metadata.maxIdle();
        long l = muet = maxIdle > -1L ? this.lastUsed + maxIdle : -1L;
        if (lset == -1L) {
            return muet;
        }
        if (muet == -1L) {
            return lset;
        }
        return Math.min(lset, muet);
    }

    public static class Externalizer
    extends AbstractExternalizer<MetadataTransientMortalCacheValue> {
        public void writeObject(ObjectOutput output, MetadataTransientMortalCacheValue value) throws IOException {
            output.writeObject(value.value);
            output.writeObject(value.metadata);
            UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)value.created);
            UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)value.lastUsed);
        }

        public MetadataTransientMortalCacheValue readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Object v = input.readObject();
            Metadata metadata = (Metadata)input.readObject();
            long created = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
            long lastUsed = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
            return new MetadataTransientMortalCacheValue(v, metadata, created, lastUsed);
        }

        public Integer getId() {
            return 45;
        }

        public Set<Class<? extends MetadataTransientMortalCacheValue>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{MetadataTransientMortalCacheValue.class});
        }
    }
}

