/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction.impl;

import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.LongAdder;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.eviction.ActivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.jmx.annotations.ManagedOperation;
import org.infinispan.jmx.annotations.MeasurementType;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="Activation", description="Component that handles activating entries that have been passivated to a CacheStore by loading them into memory.")
@Scope(value=Scopes.NAMED_CACHE)
public class ActivationManagerImpl
implements ActivationManager {
    private static final Log log = LogFactory.getLog(ActivationManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    private final LongAdder activations = new LongAdder();
    private final LongAdder pendingActivations = new LongAdder();
    @Inject
    PersistenceManager persistenceManager;
    @Inject
    Configuration cfg;
    @Inject
    DistributionManager distributionManager;
    @Inject
    KeyPartitioner keyPartitioner;
    private boolean passivation;
    @ManagedAttribute(description="Enables or disables the gathering of statistics by this component", displayName="Statistics enabled", writable=true)
    private boolean statisticsEnabled = false;

    @Start(priority=11)
    public void start() {
        this.statisticsEnabled = this.cfg.jmxStatistics().enabled();
        this.passivation = this.cfg.persistence().usingStores() && this.cfg.persistence().passivation();
    }

    @Override
    public void onUpdate(Object key, boolean newEntry) {
        if (!this.passivation || !newEntry) {
            return;
        }
        try {
            if (this.persistenceManager.deleteFromAllStoresSync(key, this.keyPartitioner.getSegment(key), PersistenceManager.AccessMode.PRIVATE) && this.statisticsEnabled) {
                this.activations.increment();
            }
        }
        catch (CacheException e) {
            Log.CONTAINER.unableToRemoveEntryAfterActivation(key, e);
        }
    }

    @Override
    public void onRemove(Object key, boolean newEntry) {
        if (!this.passivation) {
            return;
        }
        boolean primaryOwner = this.distributionManager != null && this.distributionManager.getCacheTopology().getDistribution(key).isPrimary();
        try {
            if (newEntry) {
                PersistenceManager.AccessMode mode;
                PersistenceManager.AccessMode accessMode = mode = primaryOwner ? PersistenceManager.AccessMode.BOTH : PersistenceManager.AccessMode.PRIVATE;
                if (this.persistenceManager.deleteFromAllStoresSync(key, this.keyPartitioner.getSegment(key), mode) && this.statisticsEnabled) {
                    this.activations.increment();
                }
            } else if (primaryOwner && this.persistenceManager.deleteFromAllStoresSync(key, this.keyPartitioner.getSegment(key), PersistenceManager.AccessMode.BOTH) && this.statisticsEnabled) {
                this.activations.increment();
            }
        }
        catch (CacheException e) {
            Log.CONTAINER.unableToRemoveEntryAfterActivation(key, e);
        }
    }

    @Override
    public CompletionStage<Void> activateAsync(Object key, int segment) {
        if (!this.passivation) {
            return CompletableFutures.completedNull();
        }
        if (trace) {
            log.tracef("Activating entry for key %s", key);
        }
        if (this.statisticsEnabled) {
            this.pendingActivations.increment();
        }
        CompletionStage<Boolean> stage = this.persistenceManager.deleteFromAllStores(key, segment, PersistenceManager.AccessMode.PRIVATE);
        return stage.handle((removed, throwable) -> {
            if (this.statisticsEnabled) {
                this.pendingActivations.decrement();
            }
            if (throwable != null) {
                Log.CONTAINER.unableToRemoveEntryAfterActivation(key, (Throwable)throwable);
            } else if (this.statisticsEnabled && removed == Boolean.TRUE) {
                this.activations.increment();
            }
            return null;
        });
    }

    @Override
    @ManagedAttribute(description="Number of activation events", displayName="Number of cache entries activated", measurementType=MeasurementType.TRENDSUP)
    public long getActivationCount() {
        return this.activations.sum();
    }

    @ManagedAttribute(description="Number of activation events", displayName="Number of cache entries activated", measurementType=MeasurementType.TRENDSUP)
    public String getActivations() {
        if (!this.statisticsEnabled) {
            return "N/A";
        }
        return String.valueOf(this.getActivationCount());
    }

    @ManagedOperation(description="Resets statistics gathered by this component", displayName="Reset statistics")
    public void resetStatistics() {
        this.activations.reset();
    }

    @Override
    public long getPendingActivationCount() {
        return this.pendingActivations.sum();
    }
}

