/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.commons.configuration.ClassWhiteList;
import org.infinispan.commons.dataconversion.BinaryEncoder;
import org.infinispan.commons.dataconversion.BinaryTranscoder;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.DefaultTranscoder;
import org.infinispan.commons.dataconversion.Encoder;
import org.infinispan.commons.dataconversion.GlobalMarshallerEncoder;
import org.infinispan.commons.dataconversion.IdentityEncoder;
import org.infinispan.commons.dataconversion.IdentityWrapper;
import org.infinispan.commons.dataconversion.JavaSerializationEncoder;
import org.infinispan.commons.dataconversion.Transcoder;
import org.infinispan.commons.dataconversion.UTF8Encoder;
import org.infinispan.commons.dataconversion.Wrapper;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.marshall.core.EncoderRegistryImpl;
import org.infinispan.marshall.persistence.PersistenceMarshaller;

@DefaultFactoryFor(classes={EncoderRegistry.class})
public class EncoderRegistryFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    @Inject
    @ComponentName(value="org.infinispan.marshaller.internal")
    ComponentRef<StreamingMarshaller> globalMarshaller;
    @Inject
    @ComponentName(value="org.infinispan.marshaller.persistence")
    PersistenceMarshaller persistenceMarshaller;
    @Inject
    EmbeddedCacheManager embeddedCacheManager;

    @Override
    public Object construct(String componentName) {
        EncoderRegistryImpl encoderRegistry = new EncoderRegistryImpl();
        ClassWhiteList classWhiteList = this.embeddedCacheManager.getClassWhiteList();
        encoderRegistry.registerEncoder((Encoder)IdentityEncoder.INSTANCE);
        encoderRegistry.registerEncoder((Encoder)UTF8Encoder.INSTANCE);
        encoderRegistry.registerEncoder((Encoder)new JavaSerializationEncoder(classWhiteList));
        encoderRegistry.registerEncoder((Encoder)new BinaryEncoder(this.globalMarshaller.wired()));
        encoderRegistry.registerEncoder((Encoder)new GlobalMarshallerEncoder((Marshaller)this.globalMarshaller.wired()));
        encoderRegistry.registerTranscoder((Transcoder)new DefaultTranscoder(this.persistenceMarshaller.getUserMarshaller()));
        encoderRegistry.registerTranscoder((Transcoder)new BinaryTranscoder(this.persistenceMarshaller.getUserMarshaller()));
        encoderRegistry.registerWrapper((Wrapper)ByteArrayWrapper.INSTANCE);
        encoderRegistry.registerWrapper((Wrapper)IdentityWrapper.INSTANCE);
        return encoderRegistry;
    }
}

