/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.executors.BlockingThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ScheduledThreadPoolExecutorFactory;
import org.infinispan.commons.executors.ThreadPoolExecutorFactory;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.ThreadPoolConfiguration;
import org.infinispan.executors.LazyInitializingBlockingTaskAwareExecutorService;
import org.infinispan.executors.LazyInitializingExecutorService;
import org.infinispan.executors.LazyInitializingScheduledExecutorService;
import org.infinispan.factories.AbstractComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.KnownComponentNames;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.threads.DefaultThreadFactory;

@DefaultFactoryFor(names={"org.infinispan.executors.transport", "org.infinispan.executors.notification", "org.infinispan.executors.persistence", "org.infinispan.executors.async", "org.infinispan.executors.expiration", "org.infinispan.executors.remote", "org.infinispan.executors.stateTransferExecutor", "org.infinispan.executors.timeout"})
public class NamedExecutorsFactory
extends AbstractComponentFactory
implements AutoInstantiableFactory {
    @Override
    public Object construct(String componentName) {
        try {
            if (componentName.equals("org.infinispan.executors.notification")) {
                return this.createExecutorService(this.globalConfiguration.listenerThreadPool(), "org.infinispan.executors.notification", ExecutorServiceType.DEFAULT);
            }
            if (componentName.equals("org.infinispan.executors.persistence")) {
                return this.createExecutorService(this.globalConfiguration.persistenceThreadPool(), "org.infinispan.executors.persistence", ExecutorServiceType.DEFAULT);
            }
            if (componentName.equals("org.infinispan.executors.transport")) {
                return this.createExecutorService(this.globalConfiguration.transport().transportThreadPool(), "org.infinispan.executors.transport", ExecutorServiceType.DEFAULT);
            }
            if (componentName.equals("org.infinispan.executors.expiration")) {
                return this.createExecutorService(this.globalConfiguration.expirationThreadPool(), "org.infinispan.executors.expiration", ExecutorServiceType.SCHEDULED);
            }
            if (componentName.equals("org.infinispan.executors.remote")) {
                return this.createExecutorService(this.globalConfiguration.transport().remoteCommandThreadPool(), "org.infinispan.executors.remote", ExecutorServiceType.BLOCKING);
            }
            if (componentName.equals("org.infinispan.executors.stateTransferExecutor")) {
                return this.createExecutorService(this.globalConfiguration.stateTransferThreadPool(), "org.infinispan.executors.stateTransferExecutor", ExecutorServiceType.DEFAULT);
            }
            if (componentName.equals("org.infinispan.executors.async")) {
                return this.createExecutorService(this.globalConfiguration.asyncThreadPool(), "org.infinispan.executors.async", ExecutorServiceType.DEFAULT);
            }
            if (componentName.endsWith("org.infinispan.executors.timeout")) {
                return this.createExecutorService(null, "org.infinispan.executors.timeout", ExecutorServiceType.SCHEDULED);
            }
            throw new CacheConfigurationException("Unknown named executor " + componentName);
        }
        catch (CacheConfigurationException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Unable to instantiate ExecutorFactory for named component " + componentName, (Throwable)e);
        }
    }

    private <T extends ExecutorService> T createExecutorService(ThreadPoolConfiguration threadPoolConfiguration, String componentName, ExecutorServiceType type) {
        Object executorFactory;
        ThreadFactory threadFactory;
        if (threadPoolConfiguration != null) {
            threadFactory = threadPoolConfiguration.threadFactory() != null ? threadPoolConfiguration.threadFactory() : this.createThreadFactoryWithDefaults(this.globalConfiguration, componentName);
            executorFactory = threadPoolConfiguration.threadPoolFactory() != null ? threadPoolConfiguration.threadPoolFactory() : this.createThreadPoolFactoryWithDefaults(componentName, type);
        } else {
            threadFactory = this.createThreadFactoryWithDefaults(this.globalConfiguration, componentName);
            executorFactory = this.createThreadPoolFactoryWithDefaults(componentName, type);
        }
        switch (type) {
            case SCHEDULED: {
                return (T)new LazyInitializingScheduledExecutorService((ThreadPoolExecutorFactory<ScheduledExecutorService>)executorFactory, threadFactory);
            }
            case BLOCKING: {
                String controllerName = "Controller-" + KnownComponentNames.shortened(componentName) + "-" + this.globalConfiguration.transport().nodeName();
                return (T)new LazyInitializingBlockingTaskAwareExecutorService((ThreadPoolExecutorFactory<ExecutorService>)executorFactory, threadFactory, this.globalComponentRegistry.getTimeService(), controllerName);
            }
        }
        return (T)new LazyInitializingExecutorService((ThreadPoolExecutorFactory<ExecutorService>)executorFactory, threadFactory);
    }

    private ThreadFactory createThreadFactoryWithDefaults(GlobalConfiguration globalCfg, String componentName) {
        return new DefaultThreadFactory(null, KnownComponentNames.getDefaultThreadPrio(componentName), "%c-%n-p%f-t%t", globalCfg.transport().nodeName(), KnownComponentNames.shortened(componentName));
    }

    private ThreadPoolExecutorFactory createThreadPoolFactoryWithDefaults(String componentName, ExecutorServiceType type) {
        switch (type) {
            case SCHEDULED: {
                return ScheduledThreadPoolExecutorFactory.create();
            }
        }
        int defaultQueueSize = KnownComponentNames.getDefaultQueueSize(componentName);
        int defaultMaxThreads = KnownComponentNames.getDefaultThreads(componentName);
        return BlockingThreadPoolExecutorFactory.create((int)defaultMaxThreads, (int)defaultQueueSize);
    }

    private static enum ExecutorServiceType {
        DEFAULT,
        SCHEDULED,
        BLOCKING;

    }
}

