/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.impl.ComponentAlias;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManagerImpl;
import org.infinispan.reactive.publisher.impl.LocalClusterPublisherManagerImpl;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.reactive.publisher.impl.LocalPublisherManagerImpl;
import org.infinispan.reactive.publisher.impl.NonSegmentedLocalPublisherManagerImpl;

@DefaultFactoryFor(classes={LocalPublisherManager.class, ClusterPublisherManager.class}, names={"NoClusterPublisherManager"})
public class PublisherManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    public static final String LOCAL_CLUSTER_PUBLISHER = "NoClusterPublisherManager";

    @Override
    public Object construct(String componentName) {
        if (componentName.equals(LOCAL_CLUSTER_PUBLISHER)) {
            return new LocalClusterPublisherManagerImpl();
        }
        if (componentName.equals(LocalPublisherManager.class.getName())) {
            if (this.configuration.persistence().usingStores() && !this.configuration.persistence().usingSegmentedStore()) {
                return new NonSegmentedLocalPublisherManagerImpl();
            }
            return new LocalPublisherManagerImpl();
        }
        CacheMode cacheMode = this.configuration.clustering().cacheMode();
        if (cacheMode.needsStateTransfer() && componentName.equals(ClusterPublisherManager.class.getName())) {
            return new ClusterPublisherManagerImpl();
        }
        return ComponentAlias.of(LOCAL_CLUSTER_PUBLISHER);
    }
}

