/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Function;

public final class MBeanMetadata {
    private final String jmxObjectName;
    private final String description;
    private final String superMBeanClassName;
    private final Collection<AttributeMetadata> attributes;
    private final Collection<OperationMetadata> operations;

    public static MBeanMetadata of(String objectName, String description, String superMBeanClassName, Object ... attributesAndOperations) {
        ArrayList<AttributeMetadata> attributes = new ArrayList<AttributeMetadata>();
        ArrayList<OperationMetadata> operations = new ArrayList<OperationMetadata>();
        for (Object attributeOrOperation : attributesAndOperations) {
            if (attributeOrOperation instanceof AttributeMetadata) {
                attributes.add((AttributeMetadata)attributeOrOperation);
                continue;
            }
            if (attributeOrOperation instanceof OperationMetadata) {
                operations.add((OperationMetadata)attributeOrOperation);
                continue;
            }
            throw new IllegalArgumentException();
        }
        return new MBeanMetadata(objectName, description, superMBeanClassName, attributes, operations);
    }

    public MBeanMetadata(String jmxObjectName, String description, String superMBeanClassName, Collection<AttributeMetadata> attributes, Collection<OperationMetadata> operations) {
        this.jmxObjectName = jmxObjectName != null ? (jmxObjectName.trim().length() == 0 ? null : jmxObjectName) : jmxObjectName;
        this.description = description;
        this.superMBeanClassName = superMBeanClassName;
        this.attributes = attributes;
        this.operations = operations;
    }

    public String getJmxObjectName() {
        return this.jmxObjectName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSuperMBeanClassName() {
        return this.superMBeanClassName;
    }

    public Collection<AttributeMetadata> getAttributes() {
        return this.attributes;
    }

    public Collection<OperationMetadata> getOperations() {
        return this.operations;
    }

    public String toString() {
        return "MBeanMetadata{jmxObjectName='" + this.jmxObjectName + '\'' + ", description='" + this.description + '\'' + ", super=" + this.superMBeanClassName + ", attributes=" + this.attributes + ", operations=" + this.operations + '}';
    }

    public static final class OperationParameterMetadata {
        private final String name;
        private final String type;
        private final String description;

        public OperationParameterMetadata(String name, String type, String description) {
            this.name = name;
            this.type = type;
            this.description = description;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public String getDescription() {
            return this.description;
        }

        public String toString() {
            return "OperationParameter{name='" + this.name + "', type=" + this.type + ", description='" + this.description + "'}";
        }
    }

    public static final class OperationMetadata {
        private final String methodName;
        private final String operationName;
        private final String description;
        private final String returnType;
        private final OperationParameterMetadata[] methodParameters;

        public OperationMetadata(String methodName, String operationName, String description, String returnType, OperationParameterMetadata ... methodParameters) {
            this.methodName = methodName;
            this.operationName = operationName.isEmpty() ? methodName : operationName;
            this.description = description;
            this.returnType = returnType;
            this.methodParameters = methodParameters;
        }

        public String getDescription() {
            return this.description;
        }

        public String getOperationName() {
            return this.operationName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public OperationParameterMetadata[] getMethodParameters() {
            return this.methodParameters;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public String getSignature() {
            StringBuilder signature = new StringBuilder();
            signature.append(this.methodName).append('(');
            if (this.methodParameters != null) {
                boolean first = true;
                for (OperationParameterMetadata param : this.methodParameters) {
                    if (first) {
                        first = false;
                    } else {
                        signature.append(',');
                    }
                    signature.append(param.getType());
                }
            }
            signature.append(')');
            return signature.toString();
        }

        public String toString() {
            return "OperationMetadata{methodName='" + this.methodName + '\'' + ", returnType=" + this.returnType + ", methodParameters=" + (this.methodParameters == null ? null : Arrays.toString(this.methodParameters)) + ", description='" + this.description + '\'' + '}';
        }
    }

    public static final class AttributeMetadata {
        private final String name;
        private final String description;
        private final boolean writable;
        private final boolean useSetter;
        private final String type;
        private final boolean is;
        private final Function<?, ?> accessorFunction;

        public AttributeMetadata(String name, String description, boolean writable, boolean useSetter, String type, boolean is, Function<?, ?> accessorFunction) {
            this.name = name;
            this.description = description;
            this.writable = writable;
            this.useSetter = useSetter;
            this.type = type;
            this.is = is;
            this.accessorFunction = accessorFunction;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isWritable() {
            return this.writable;
        }

        public boolean isUseSetter() {
            return this.useSetter;
        }

        public String getType() {
            return this.type;
        }

        public boolean isIs() {
            return this.is;
        }

        public Function<?, ?> accessorFunction() {
            return this.accessorFunction;
        }

        public String toString() {
            return "AttributeMetadata{name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", writable=" + this.writable + ", type='" + this.type + '\'' + ", is=" + this.is + ", accessorFunction=" + this.accessorFunction + '}';
        }
    }
}

