/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.locking;

import java.util.Collection;
import org.infinispan.InvalidCacheUsageException;
import org.infinispan.commands.DataCommand;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.write.DataWriteCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.interceptors.InvocationFinallyAction;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.InvocationSuccessFunction;
import org.infinispan.interceptors.locking.AbstractTxLockingInterceptor;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class OptimisticLockingInterceptor
extends AbstractTxLockingInterceptor {
    private static final Log log = LogFactory.getLog(OptimisticLockingInterceptor.class);
    private final InvocationFinallyAction<VisitableCommand> releaseLockOnCompletionAction = (rCtx, rCommand, rv, throwable) -> this.releaseLockOnTxCompletion((TxInvocationContext)rCtx);
    private final InvocationSuccessFunction<PrepareCommand> onePhaseCommitFunction = (rCtx, rCommand, rv) -> this.invokeNextAndFinally(rCtx, rCommand, this.releaseLockOnCompletionAction);

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Collection<?> keysToLock = command.getKeysToLock();
        InvocationStage lockStage = InvocationStage.completedNullStage();
        ctx.addAllAffectedKeys(command.getAffectedKeys());
        if (!keysToLock.isEmpty()) {
            if (command.isRetriedCommand()) {
                ((AbstractCacheTransaction)ctx.getCacheTransaction()).cleanupBackupLocks();
            }
            lockStage = this.lockAllOrRegisterBackupLock(ctx, command, keysToLock, this.cacheConfiguration.locking().lockAcquisitionTimeout());
        }
        if (command.isOnePhaseCommit()) {
            return lockStage.thenApply(ctx, command, this.onePhaseCommitFunction);
        }
        return this.asyncInvokeNext((InvocationContext)ctx, (VisitableCommand)command, lockStage);
    }

    @Override
    protected Object visitDataReadCommand(InvocationContext ctx, DataCommand command) throws Throwable {
        return this.invokeNext(ctx, command);
    }

    @Override
    protected Object visitDataWriteCommand(InvocationContext ctx, DataWriteCommand command) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    @Override
    protected Object handleReadManyCommand(InvocationContext ctx, FlagAffectedCommand command, Collection<?> keys) {
        return this.invokeNext(ctx, command);
    }

    @Override
    protected <K> Object handleWriteManyCommand(InvocationContext ctx, WriteCommand command, Collection<K> keys, boolean forwarded) throws Throwable {
        return this.invokeNextAndFinally(ctx, command, this.unlockAllReturnHandler);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        throw new InvalidCacheUsageException("Explicit locking is not allowed with optimistic caches!");
    }
}

