/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jmx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.jmx.JmxUtil;
import org.infinispan.commons.jmx.MBeanServerLookup;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalJmxStatisticsConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.impl.MBeanMetadata;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.ObjectNameKeys;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.metrics.impl.ApplicationMetricsRegistry;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Scope(value=Scopes.NONE)
abstract class AbstractJmxRegistration
implements ObjectNameKeys {
    private static final Log log = LogFactory.getLog(AbstractJmxRegistration.class);
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    BasicComponentRegistry basicComponentRegistry;
    @Inject
    ApplicationMetricsRegistry applicationMetricsRegistry;
    volatile MBeanServer mBeanServer;
    String jmxDomain;
    String groupName;
    private Collection<ResourceDMBean> resourceDMBeans;

    AbstractJmxRegistration() {
    }

    public void start() {
        if (this.mBeanServer == null) {
            this.groupName = this.initGroup();
            Object mBeanServer = null;
            try {
                GlobalJmxStatisticsConfiguration globalJmxConfig = this.globalConfig.globalJmxStatistics();
                MBeanServerLookup lookup = globalJmxConfig.mbeanServerLookup();
                if (lookup != null) {
                    mBeanServer = lookup.getMBeanServer((Properties)globalJmxConfig.properties());
                }
            }
            catch (Exception e) {
                log.warn("Ignoring exception in MBean server lookup", e);
            }
            if (mBeanServer != null) {
                this.jmxDomain = this.initDomain((MBeanServer)mBeanServer);
                this.mBeanServer = mBeanServer;
            }
        }
        if (this.mBeanServer != null) {
            this.resourceDMBeans = Collections.synchronizedCollection(this.getResourceDMBeansFromComponents());
            try {
                for (ResourceDMBean resourceDMBean : this.resourceDMBeans) {
                    ObjectName objectName = this.getObjectName(this.groupName, resourceDMBean.getMBeanName());
                    JmxUtil.registerMBean((Object)resourceDMBean, (ObjectName)objectName, (MBeanServer)this.mBeanServer);
                    resourceDMBean.setObjectName(objectName);
                    if (this.applicationMetricsRegistry == null) continue;
                    this.applicationMetricsRegistry.register(resourceDMBean);
                }
            }
            catch (Exception e) {
                throw new CacheException("Failure while registering MBeans", (Throwable)e);
            }
            log.trace("MBeans were successfully registered to the MBean server.");
        }
    }

    public void stop() {
        if (this.mBeanServer != null && this.resourceDMBeans != null) {
            try {
                for (ResourceDMBean resourceDMBean : this.resourceDMBeans) {
                    if (resourceDMBean.getObjectName() == null) continue;
                    JmxUtil.unregisterMBean((ObjectName)resourceDMBean.getObjectName(), (MBeanServer)this.mBeanServer);
                    if (this.applicationMetricsRegistry == null) continue;
                    this.applicationMetricsRegistry.unregister(resourceDMBean);
                }
                this.resourceDMBeans = null;
            }
            catch (Exception e) {
                throw new CacheException("Failure while unregistering MBeans", (Throwable)e);
            }
        }
    }

    protected abstract String initGroup();

    private String initDomain(MBeanServer mBeanServer) {
        GlobalJmxStatisticsConfiguration globalJmxConfig = this.globalConfig.globalJmxStatistics();
        String jmxDomain = JmxUtil.buildJmxDomain((String)globalJmxConfig.domain(), (MBeanServer)mBeanServer, (String)this.groupName);
        if (!globalJmxConfig.allowDuplicateDomains() && !jmxDomain.equals(globalJmxConfig.domain())) {
            throw Log.CONTAINER.jmxMBeanAlreadyRegistered(this.groupName, globalJmxConfig.domain());
        }
        return jmxDomain;
    }

    public final String getDomain() {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        return this.jmxDomain;
    }

    public final String getGroupName() {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        return this.groupName;
    }

    public final MBeanServer getMBeanServer() {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        return this.mBeanServer;
    }

    private ObjectName getObjectName(String groupName, String resourceName) throws MalformedObjectNameException {
        if (groupName == null) {
            throw new IllegalArgumentException("groupName cannot be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName cannot be null");
        }
        return new ObjectName(this.getDomain() + ":" + groupName + "," + "component" + "=" + resourceName);
    }

    private Collection<ResourceDMBean> getResourceDMBeansFromComponents() {
        Collection<ComponentRef<?>> components = this.basicComponentRegistry.getRegisteredComponents();
        ArrayList<ResourceDMBean> resourceDMBeans = new ArrayList<ResourceDMBean>(components.size());
        for (ComponentRef<?> component : components) {
            ResourceDMBean resourceDMBean;
            Object instance;
            if (component.isAlias() || (instance = component.wired()) == null || (resourceDMBean = this.getResourceDMBean(instance, component.getName())) == null) continue;
            resourceDMBeans.add(resourceDMBean);
        }
        return resourceDMBeans;
    }

    private ResourceDMBean getResourceDMBean(Object instance, String componentName) {
        MBeanMetadata md = this.basicComponentRegistry.getMBeanMetadata(instance.getClass().getName());
        return md == null ? null : new ResourceDMBean(instance, md, componentName);
    }

    public ObjectName registerExternalMBean(Object managedComponent, String groupName) throws Exception {
        if (this.mBeanServer == null) {
            throw new IllegalStateException("MBean server not initialized");
        }
        ResourceDMBean resourceDMBean = this.getResourceDMBean(managedComponent, null);
        if (resourceDMBean == null) {
            throw new IllegalArgumentException("No MBean metadata found for " + managedComponent.getClass().getName());
        }
        ObjectName objectName = this.getObjectName(groupName, resourceDMBean.getMBeanName());
        JmxUtil.registerMBean((Object)resourceDMBean, (ObjectName)objectName, (MBeanServer)this.mBeanServer);
        resourceDMBean.setObjectName(objectName);
        if (this.applicationMetricsRegistry != null) {
            this.applicationMetricsRegistry.register(resourceDMBean);
        }
        return objectName;
    }

    public void registerMBean(Object managedComponent) {
        this.registerMBean(managedComponent, this.groupName);
    }

    public void registerMBean(Object managedComponent, String groupName) {
        try {
            ResourceDMBean resourceDMBean = this.getResourceDMBean(managedComponent, null);
            if (resourceDMBean == null) {
                throw new IllegalArgumentException("No MBean metadata found for " + managedComponent.getClass().getName());
            }
            ObjectName objectName = this.getObjectName(groupName, resourceDMBean.getMBeanName());
            JmxUtil.registerMBean((Object)resourceDMBean, (ObjectName)objectName, (MBeanServer)this.mBeanServer);
            resourceDMBean.setObjectName(objectName);
            this.resourceDMBeans.add(resourceDMBean);
            if (this.applicationMetricsRegistry != null) {
                this.applicationMetricsRegistry.register(resourceDMBean);
            }
        }
        catch (Exception e) {
            throw new CacheException("Failure while registering MBeans", (Throwable)e);
        }
    }
}

