/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.manager;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.infinispan.commons.util.Immutables;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.registry.InternalCacheRegistry;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.Transport;

public class CacheManagerInfo {
    public static final List<String> LOCAL_NODE = Collections.singletonList("local");
    private final DefaultCacheManager cacheManager;
    private final ConfigurationManager configurationManager;
    private final InternalCacheRegistry internalCacheRegistry;

    public CacheManagerInfo(DefaultCacheManager cacheManager, ConfigurationManager configurationManager, InternalCacheRegistry internalCacheRegistry) {
        this.cacheManager = cacheManager;
        this.configurationManager = configurationManager;
        this.internalCacheRegistry = internalCacheRegistry;
    }

    public String getCoordinatorAddress() {
        Transport t = this.cacheManager.getTransport();
        return t == null ? "N/A" : t.getCoordinator().toString();
    }

    public boolean isCoordinator() {
        return this.cacheManager.getTransport() != null && this.cacheManager.getTransport().isCoordinator();
    }

    public String getCacheManagerStatus() {
        return this.cacheManager.getStatus().toString();
    }

    public Set<BasicCacheInfo> getDefinedCaches() {
        return this.cacheManager.getCacheNames().stream().map(c -> {
            boolean started = this.cacheManager.getCaches().containsKey(c);
            return new BasicCacheInfo((String)c, started);
        }).collect(Collectors.toSet());
    }

    public Set<String> getCacheConfigurationNames() {
        HashSet<String> names = new HashSet<String>(this.configurationManager.getDefinedConfigurations());
        this.internalCacheRegistry.filterPrivateCaches(names);
        if (names.isEmpty()) {
            return Collections.emptySet();
        }
        return Immutables.immutableSetWrap(names);
    }

    public long getCreatedCacheCount() {
        return this.cacheManager.getCaches().keySet().stream().filter(c -> !this.internalCacheRegistry.isInternalCache((String)c)).count();
    }

    public long getRunningCacheCount() {
        return this.cacheManager.getCaches().keySet().stream().filter(c -> this.cacheManager.isRunning((String)c) && !this.internalCacheRegistry.isInternalCache((String)c)).count();
    }

    public String getVersion() {
        return Version.getVersion();
    }

    public String getName() {
        return this.configurationManager.getGlobalConfiguration().cacheManagerName();
    }

    public String getNodeAddress() {
        return this.cacheManager.getLogicalAddressString();
    }

    public String getPhysicalAddresses() {
        if (this.cacheManager.getTransport() == null) {
            return "local";
        }
        List<Address> address = this.cacheManager.getTransport().getPhysicalAddresses();
        return address == null ? "local" : address.toString();
    }

    public List<String> getClusterMembers() {
        if (this.cacheManager.getTransport() == null) {
            return LOCAL_NODE;
        }
        return this.cacheManager.getTransport().getMembers().stream().map(Objects::toString).collect(Collectors.toList());
    }

    public List<String> getClusterMembersPhysicalAddresses() {
        if (this.cacheManager.getTransport() == null) {
            return LOCAL_NODE;
        }
        List<Address> addressList = this.cacheManager.getTransport().getMembersPhysicalAddresses();
        return addressList.stream().map(Objects::toString).collect(Collectors.toList());
    }

    public int getClusterSize() {
        if (this.cacheManager.getTransport() == null) {
            return 1;
        }
        return this.cacheManager.getTransport().getMembers().size();
    }

    public String getClusterName() {
        return this.configurationManager.getGlobalConfiguration().transport().clusterName();
    }

    private String getLogicalAddressString() {
        return this.cacheManager.getAddress() == null ? "local" : this.cacheManager.getAddress().toString();
    }

    static class BasicCacheInfo {
        String name;
        boolean started;

        BasicCacheInfo(String name, boolean started) {
            this.name = name;
            this.started = started;
        }

        public String getName() {
            return this.name;
        }

        public boolean isStarted() {
            return this.started;
        }
    }
}

