/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.metrics.impl;

import io.smallrye.metrics.MetricRegistries;
import java.util.Map;
import java.util.function.Supplier;
import javax.management.AttributeNotFoundException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetadataBuilder;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;
import org.infinispan.factories.annotations.SurvivesRestarts;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.jmx.ResourceDMBean;
import org.infinispan.metrics.impl.ObjectNameMapper;

@Scope(value=Scopes.GLOBAL)
@SurvivesRestarts
public final class ApplicationMetricsRegistry {
    private final MetricRegistry applicationMetricRegistry = MetricRegistries.get((MetricRegistry.Type)MetricRegistry.Type.APPLICATION);

    public MetricRegistry getRegistry() {
        return this.applicationMetricRegistry;
    }

    public void register(ResourceDMBean resourceDMBean) {
        ObjectName objectName = resourceDMBean.getObjectName();
        MBeanInfo mBeanInfo = resourceDMBean.getMBeanInfo();
        MBeanAttributeInfo[] mBeanAttributes = mBeanInfo.getAttributes();
        Tag[] tags = ObjectNameMapper.makeTags(objectName);
        for (MBeanAttributeInfo attr : mBeanAttributes) {
            Supplier<?> valueSupplier;
            if (!attr.isReadable()) continue;
            String attrName = attr.getName();
            try {
                valueSupplier = resourceDMBean.getAttributeValueSupplier(attrName);
                if (valueSupplier == null) {
                    continue;
                }
            }
            catch (AttributeNotFoundException e) {
                throw new IllegalStateException(e);
            }
            Gauge gaugeMetric = () -> (Number)valueSupplier.get();
            String metricName = ObjectNameMapper.makeMetricName(objectName, attrName);
            Metadata metadata = new MetadataBuilder().withType(MetricType.GAUGE).withName(metricName).withDisplayName(attr.getName()).withDescription(attr.getDescription()).build();
            this.getRegistry().register(metadata, (Metric)gaugeMetric, tags);
        }
    }

    public void unregister(ResourceDMBean resourceDMBean) {
        this.unregister(resourceDMBean.getObjectName());
    }

    public void unregister(ObjectName objectName) {
        String prefix = ObjectNameMapper.makeMetricNamePrefix(objectName);
        Map<String, String> tags = ObjectNameMapper.makeTagMap(objectName);
        this.getRegistry().removeMatching((metricID, metric) -> metricID.getName().startsWith(prefix) && tags.equals(metricID.getTags()));
    }
}

