/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import io.reactivex.Flowable;
import io.reactivex.schedulers.Schedulers;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.IntSet;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.impl.InternalEntryFactory;
import org.infinispan.context.InvocationContext;
import org.infinispan.filter.KeyFilter;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.AdvancedCacheLoader;
import org.infinispan.persistence.spi.MarshallableEntry;
import org.infinispan.persistence.spi.SegmentedAdvancedLoadWriteStore;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

public class PersistenceUtil {
    private static Log log = LogFactory.getLog(PersistenceUtil.class);
    private static final int SEGMENT_NOT_PROVIDED = -1;

    public static KeyFilter notNull(KeyFilter filter) {
        return filter == null ? KeyFilter.ACCEPT_ALL_FILTER : filter;
    }

    @Deprecated
    public static <K, V> int count(AdvancedCacheLoader<K, V> acl, KeyFilter<? super K> filter) {
        return PersistenceUtil.count(acl, filter);
    }

    public static <K, V> int count(AdvancedCacheLoader<K, V> acl, Predicate<? super K> filter) {
        Long result = (Long)Flowable.fromPublisher(acl.publishKeys(filter)).count().blockingGet();
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return result.intValue();
    }

    public static int count(SegmentedAdvancedLoadWriteStore<?, ?> salws, IntSet segments) {
        Long result = (Long)Flowable.fromPublisher(salws.publishKeys(segments, null)).count().blockingGet();
        if (result > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return result.intValue();
    }

    @Deprecated
    public static <K, V> Set<K> toKeySet(AdvancedCacheLoader<K, V> acl, KeyFilter<? super K> filter) {
        return PersistenceUtil.toKeySet(acl, filter);
    }

    public static <K, V> Set<K> toKeySet(AdvancedCacheLoader<K, V> acl, Predicate<? super K> filter) {
        if (acl == null) {
            return Collections.emptySet();
        }
        return (Set)Flowable.fromPublisher(acl.publishKeys(filter)).collectInto(new HashSet(), Set::add).blockingGet();
    }

    @Deprecated
    public static <K, V> Set<InternalCacheEntry> toEntrySet(AdvancedCacheLoader<K, V> acl, KeyFilter<? super K> filter, InternalEntryFactory ief) {
        Set<InternalCacheEntry> entrySet = PersistenceUtil.toEntrySet(acl, filter, ief);
        return entrySet;
    }

    public static <K, V> Set<InternalCacheEntry<K, V>> toEntrySet(AdvancedCacheLoader<K, V> acl, Predicate<? super K> filter, InternalEntryFactory ief) {
        if (acl == null) {
            return Collections.emptySet();
        }
        return (Set)Flowable.fromPublisher(acl.entryPublisher(filter, true, true)).map(me -> ief.create(me.getKey(), me.getValue(), me.getMetadata())).collectInto(new HashSet(), Set::add).blockingGet();
    }

    @Deprecated
    public static <K, V> InternalCacheEntry<K, V> loadAndStoreInDataContainer(DataContainer<K, V> dataContainer, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, AtomicReference<Boolean> isLoaded) {
        return org.infinispan.persistence.internal.PersistenceUtil.loadAndStoreInDataContainer(dataContainer, persistenceManager, key, ctx, timeService, isLoaded);
    }

    @Deprecated
    public static <K, V> InternalCacheEntry<K, V> loadAndStoreInDataContainer(DataContainer<K, V> dataContainer, int segment, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, AtomicReference<Boolean> isLoaded) {
        return org.infinispan.persistence.internal.PersistenceUtil.loadAndStoreInDataContainer(dataContainer, segment, persistenceManager, key, ctx, timeService, isLoaded);
    }

    @Deprecated
    public static <K, V> InternalCacheEntry<K, V> loadAndComputeInDataContainer(DataContainer<K, V> dataContainer, int segment, PersistenceManager persistenceManager, K key, InvocationContext ctx, TimeService timeService, DataContainer.ComputeAction<K, V> action) {
        return org.infinispan.persistence.internal.PersistenceUtil.loadAndComputeInDataContainer(dataContainer, segment, persistenceManager, key, ctx, timeService, action);
    }

    @Deprecated
    public static <K, V> MarshallableEntry<K, V> loadAndCheckExpiration(PersistenceManager persistenceManager, Object key, InvocationContext context, TimeService timeService) {
        return org.infinispan.persistence.internal.PersistenceUtil.loadAndCheckExpiration(persistenceManager, key, -1, context);
    }

    public static <K, V> InternalCacheEntry<K, V> convert(MarshallableEntry<K, V> loaded, InternalEntryFactory factory) {
        return org.infinispan.persistence.internal.PersistenceUtil.convert(loaded, factory);
    }

    public static <R> Publisher<R> parallelizePublisher(IntSet segments, Executor executor, IntFunction<Publisher<R>> publisherFunction) {
        return org.infinispan.persistence.internal.PersistenceUtil.parallelizePublisher(segments, Schedulers.from((Executor)executor), publisherFunction);
    }

    public static String sanitizedCacheName(String cacheName) {
        return cacheName.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
    }

    public static Path getQualifiedLocation(GlobalConfiguration globalConfiguration, String location, String cacheName, String qualifier) {
        Path persistentLocation = Paths.get(globalConfiguration.globalState().persistentLocation(), new String[0]);
        if (location == null) {
            return persistentLocation.resolve(Paths.get(PersistenceUtil.sanitizedCacheName(cacheName), qualifier));
        }
        Path path = Paths.get(location, new String[0]);
        if (path.isAbsolute()) {
            if (path.startsWith(persistentLocation)) {
                return Paths.get(location, PersistenceUtil.sanitizedCacheName(cacheName), qualifier);
            }
            throw Log.PERSISTENCE.forbiddenStoreLocation(path, persistentLocation);
        }
        return persistentLocation.resolve(path.resolve(Paths.get(PersistenceUtil.sanitizedCacheName(cacheName), qualifier)));
    }
}

