/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.marshall.BufferSizePredictor;
import org.infinispan.commons.marshall.MarshallingException;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.marshall.persistence.PersistenceMarshaller;

class StreamingMarshallerBridge
implements StreamingMarshaller {
    final PersistenceMarshaller marshaller;

    StreamingMarshallerBridge(PersistenceMarshaller marshaller) {
        this.marshaller = marshaller;
    }

    public ObjectOutput startObjectOutput(OutputStream os, boolean isReentrant, int estimatedSize) throws IOException {
        return new Output(os);
    }

    public void finishObjectOutput(ObjectOutput oo) {
        try {
            oo.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void objectToObjectStream(Object obj, ObjectOutput out) throws IOException {
        out.writeObject(obj);
    }

    public ObjectInput startObjectInput(InputStream is, boolean isReentrant) throws IOException {
        return new Input(is);
    }

    public void finishObjectInput(ObjectInput oi) {
        try {
            oi.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object objectFromObjectStream(ObjectInput in) throws IOException, ClassNotFoundException, InterruptedException {
        return in.readObject();
    }

    public Object objectFromInputStream(InputStream is) throws IOException, ClassNotFoundException {
        return this.marshaller.readObject(is);
    }

    public void stop() {
        this.marshaller.stop();
    }

    public void start() {
        this.marshaller.start();
    }

    public byte[] objectToByteBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        return this.marshaller.objectToByteBuffer(obj, estimatedSize);
    }

    public byte[] objectToByteBuffer(Object obj) throws IOException, InterruptedException {
        return this.marshaller.objectToByteBuffer(obj);
    }

    public Object objectFromByteBuffer(byte[] buf) throws IOException, ClassNotFoundException {
        return this.marshaller.objectFromByteBuffer(buf);
    }

    public Object objectFromByteBuffer(byte[] buf, int offset, int length) throws IOException, ClassNotFoundException {
        return this.marshaller.objectFromByteBuffer(buf, offset, length);
    }

    public ByteBuffer objectToBuffer(Object o) throws IOException, InterruptedException {
        return this.marshaller.objectToBuffer(o);
    }

    public boolean isMarshallable(Object o) throws Exception {
        return this.marshaller.isMarshallable(o);
    }

    public BufferSizePredictor getBufferSizePredictor(Object o) {
        return this.marshaller.getBufferSizePredictor(o);
    }

    public MediaType mediaType() {
        return this.marshaller.mediaType();
    }

    private class Input
    implements ObjectInput {
        final InputStream in;

        public Input(InputStream in) {
            this.in = in;
        }

        @Override
        public Object readObject() throws ClassNotFoundException, IOException {
            return StreamingMarshallerBridge.this.marshaller.readObject(this.in);
        }

        @Override
        public int read() throws IOException {
            return (Integer)this.get();
        }

        @Override
        public int read(byte[] bytes) throws IOException {
            return (Integer)this.get();
        }

        @Override
        public int read(byte[] bytes, int i, int i1) throws IOException {
            return (Integer)this.get();
        }

        @Override
        public long skip(long l) throws IOException {
            return (Long)this.get();
        }

        @Override
        public int available() throws IOException {
            return (Integer)this.get();
        }

        @Override
        public void close() throws IOException {
            this.in.close();
        }

        @Override
        public void readFully(byte[] bytes) throws IOException {
            this.in.read(bytes);
        }

        @Override
        public void readFully(byte[] bytes, int i, int i1) throws IOException {
            this.in.read(bytes, i, i1);
        }

        @Override
        public int skipBytes(int i) throws IOException {
            return (int)this.in.skip(i);
        }

        @Override
        public boolean readBoolean() throws IOException {
            return (Boolean)this.get();
        }

        @Override
        public byte readByte() throws IOException {
            return (Byte)this.get();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return (Integer)this.get();
        }

        @Override
        public short readShort() throws IOException {
            return (Short)this.get();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return (Integer)this.get();
        }

        @Override
        public char readChar() throws IOException {
            return ((Character)this.get()).charValue();
        }

        @Override
        public int readInt() throws IOException {
            return (Integer)this.get();
        }

        @Override
        public long readLong() throws IOException {
            return (Long)this.get();
        }

        @Override
        public float readFloat() throws IOException {
            return ((Float)this.get()).floatValue();
        }

        @Override
        public double readDouble() throws IOException {
            return (Double)this.get();
        }

        @Override
        public String readLine() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public String readUTF() throws IOException {
            return (String)this.get();
        }

        private <T> T get() throws IOException {
            try {
                return (T)StreamingMarshallerBridge.this.marshaller.readObject(this.in);
            }
            catch (ClassNotFoundException e) {
                throw new MarshallingException((Throwable)e);
            }
        }
    }

    private class Output
    implements ObjectOutput {
        final OutputStream out;

        Output(OutputStream out) {
            this.out = out;
        }

        @Override
        public void writeObject(Object o) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(o, this.out);
        }

        @Override
        public void write(int i) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(i, this.out);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(bytes, this.out);
        }

        @Override
        public void write(byte[] bytes, int i, int i1) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(bytes, this.out);
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.out.close();
        }

        @Override
        public void writeBoolean(boolean b) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(b, this.out);
        }

        @Override
        public void writeByte(int i) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(i, this.out);
        }

        @Override
        public void writeShort(int i) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(i, this.out);
        }

        @Override
        public void writeChar(int i) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(i, this.out);
        }

        @Override
        public void writeInt(int i) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(i, this.out);
        }

        @Override
        public void writeLong(long l) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(l, this.out);
        }

        @Override
        public void writeFloat(float v) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(Float.valueOf(v), this.out);
        }

        @Override
        public void writeDouble(double v) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(v, this.out);
        }

        @Override
        public void writeBytes(String s) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(s, this.out);
        }

        @Override
        public void writeChars(String s) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(s, this.out);
        }

        @Override
        public void writeUTF(String s) throws IOException {
            StreamingMarshallerBridge.this.marshaller.writeObject(s, this.out);
        }
    }
}

