/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive;

import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.internal.functions.Functions;
import io.reactivex.processors.AsyncProcessor;
import io.reactivex.subjects.CompletableSubject;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Stream;

public class RxJavaInterop {
    private static final io.reactivex.functions.Function<Single<Object>, CompletionStage<Object>> singleToCompletionStage = single -> {
        CompletableFuture cf = new CompletableFuture();
        single.subscribe(cf::complete, cf::completeExceptionally);
        return cf;
    };
    private static final io.reactivex.functions.Function<Flowable<Object>, CompletionStage<Void>> flowableToCompletionStage = flowable -> {
        CompletableFuture cf = new CompletableFuture();
        flowable.subscribe(Functions.emptyConsumer(), cf::completeExceptionally, () -> cf.complete(null));
        return cf;
    };
    private static final io.reactivex.functions.Function<Maybe<Object>, CompletionStage<Object>> maybeToCompletionStage = maybe -> {
        CompletableFuture cf = new CompletableFuture();
        maybe.subscribe(cf::complete, cf::completeExceptionally, () -> cf.complete(null));
        return cf;
    };
    private static final Function<CompletionStage<Object>, Flowable<Object>> completionStageToPublisher = stage -> {
        AsyncProcessor asyncProcessor = AsyncProcessor.create();
        stage.whenComplete((value, t) -> {
            if (t != null) {
                asyncProcessor.onError(t);
            } else {
                if (value != null) {
                    asyncProcessor.onNext(value);
                }
                asyncProcessor.onComplete();
            }
        });
        return asyncProcessor;
    };
    private static final io.reactivex.functions.Function<Map.Entry<Object, Object>, Object> entryToKeyFunction = Map.Entry::getKey;
    private static final Function<CompletionStage<?>, Completable> completionStageCompletableFunction = completionStage -> {
        CompletableSubject cs = CompletableSubject.create();
        completionStage.whenComplete((o, throwable) -> {
            if (throwable != null) {
                cs.onError(throwable);
            } else {
                cs.onComplete();
            }
        });
        return cs;
    };

    private RxJavaInterop() {
    }

    public static <E> io.reactivex.functions.Function<Single<E>, CompletionStage<E>> singleToCompletionStage() {
        return singleToCompletionStage;
    }

    public static <E> io.reactivex.functions.Function<Maybe<E>, CompletionStage<E>> maybeToCompletionStage() {
        return maybeToCompletionStage;
    }

    public static <E> io.reactivex.functions.Function<Flowable<E>, CompletionStage<Void>> flowableToCompletionStage() {
        return flowableToCompletionStage;
    }

    public static <E> Function<CompletionStage<E>, Flowable<E>> completionStageToPublisher() {
        return completionStageToPublisher;
    }

    public static Function<CompletionStage<?>, Completable> completionStageToCompletable() {
        return completionStageCompletableFunction;
    }

    public static <E> Flowable<E> fromStream(Stream<E> stream) {
        return Flowable.fromIterable(stream::iterator).doOnTerminate(stream::close);
    }

    public static <K, V> io.reactivex.functions.Function<Map.Entry<K, V>, K> entryToKeyFunction() {
        return entryToKeyFunction;
    }
}

