/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl;

import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.PublishProcessor;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.distribution.DistributionInfo;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.KeyPublisherResult;
import org.infinispan.reactive.publisher.impl.LocalClusterPublisherManagerImpl;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.reactive.publisher.impl.LocalPublisherManagerImpl;
import org.infinispan.reactive.publisher.impl.PublisherRequestCommand;
import org.infinispan.reactive.publisher.impl.PublisherResult;
import org.infinispan.reactive.publisher.impl.SegmentPublisherResult;
import org.infinispan.remoting.responses.ValidResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.ValidResponseCollector;
import org.infinispan.statetransfer.StateTransferLock;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class ClusterPublisherManagerImpl<K, V>
implements ClusterPublisherManager<K, V> {
    protected static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    protected static final boolean trace = log.isTraceEnabled();
    @Inject
    LocalPublisherManager<K, V> localPublisherManager;
    @Inject
    DistributionManager distributionManager;
    @Inject
    StateTransferLock stateTransferLock;
    @Inject
    RpcManager rpcManager;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    Configuration cacheConfiguration;
    private final KeyComposedType KEY_COMPOSED = new KeyComposedType();
    private final EntryComposedType ENTRY_COMPOSED = new EntryComposedType();
    private int maxSegment;
    private boolean writeBehindShared;

    private <R> KeyComposedType<R> keyComposedType() {
        return this.KEY_COMPOSED;
    }

    private <R> EntryComposedType<R> entryComposedType() {
        return this.ENTRY_COMPOSED;
    }

    @Start
    public void start() {
        this.maxSegment = this.cacheConfiguration.clustering().hash().numSegments();
        this.writeBehindShared = this.hasWriteBehindSharedStore(this.cacheConfiguration.persistence());
    }

    @Override
    public <R> CompletionStage<R> keyReduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext ctx, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        Function<Publisher<CompletionStage<R>>, CompletionStage<CompletionStage<R>>> finalizerToUse;
        FlowableProcessor flowableProcessor = PublishProcessor.create().toSerialized();
        CompletionStage<R> stage = finalizer.apply((Publisher<CompletionStage<R>>)flowableProcessor);
        Function<Object, CompletionStage<CompletionStage<R>>> function = finalizerToUse = this.requiresFinalizer(parallelPublisher, keysToInclude, deliveryGuarantee) ? finalizer : null;
        if (keysToInclude != null) {
            this.startKeyPublisher(parallelPublisher, segments, keysToInclude, ctx, includeLoader, deliveryGuarantee, this.keyComposedType(), transformer, finalizerToUse, flowableProcessor);
        } else {
            this.startSegmentPublisher(parallelPublisher, segments, ctx, includeLoader, deliveryGuarantee, this.keyComposedType(), transformer, finalizerToUse, flowableProcessor);
        }
        return stage;
    }

    @Override
    public <R> CompletionStage<R> entryReduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext ctx, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        Function<Publisher<CompletionStage<R>>, CompletionStage<CompletionStage<R>>> finalizerToUse;
        FlowableProcessor flowableProcessor = PublishProcessor.create().toSerialized();
        CompletionStage<R> stage = finalizer.apply((Publisher<CompletionStage<R>>)flowableProcessor);
        Function<Object, CompletionStage<CompletionStage<R>>> function = finalizerToUse = this.requiresFinalizer(parallelPublisher, keysToInclude, deliveryGuarantee) ? finalizer : null;
        if (keysToInclude != null) {
            this.startKeyPublisher(parallelPublisher, segments, keysToInclude, ctx, includeLoader, deliveryGuarantee, this.entryComposedType(), transformer, finalizerToUse, flowableProcessor);
        } else {
            this.startSegmentPublisher(parallelPublisher, segments, ctx, includeLoader, deliveryGuarantee, this.entryComposedType(), transformer, finalizerToUse, flowableProcessor);
        }
        return stage;
    }

    private <R> boolean requiresFinalizer(boolean parallelPublisher, Set<K> keysToInclude, DeliveryGuarantee deliveryGuarantee) {
        return parallelPublisher || keysToInclude == null && deliveryGuarantee == DeliveryGuarantee.EXACTLY_ONCE;
    }

    private <I, R> void handleContextInvocation(IntSet segments, Set<K> keysToInclude, InvocationContext ctx, ComposedType<K, I, R> composedType, Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer, BiConsumer<PublisherResult<R>, Throwable> biConsumer) {
        CompletionStage<PublisherResult<R>> localStage = composedType.contextInvocation(segments, keysToInclude, ctx, transformer);
        if (trace) {
            localStage = localStage.whenComplete((results, t) -> log.tracef("Result result was: %s for context %s", results.getResult(), ctx));
        }
        localStage.whenComplete(biConsumer);
    }

    private <I, R> void startKeyPublisher(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext ctx, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, ComposedType<K, I, R> composedType, Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer, FlowableProcessor<R> flowableProcessor) {
        LocalizedCacheTopology topology = this.distributionManager.getCacheTopology();
        Address localAddress = topology.getLocalAddress();
        Map<Address, Set<K>> keyTargets = this.determineKeyTargets(topology, keysToInclude, localAddress, segments, ctx);
        boolean useContext = ctx != null && ctx.lookedUpEntriesCount() > 0;
        AtomicInteger parallelCount = useContext ? new AtomicInteger(keyTargets.size() + 1) : new AtomicInteger(keyTargets.size());
        KeyBiConsumer<I, R> biConsumer = new KeyBiConsumer<I, R>(flowableProcessor, parallelCount, topology.getTopologyId(), parallelPublisher, includeLoader, deliveryGuarantee, composedType, transformer, finalizer);
        Set localKeys = keyTargets.remove(localAddress);
        if (!keyTargets.isEmpty()) {
            for (Map.Entry<Address, Set<K>> remoteTarget : keyTargets.entrySet()) {
                Address remoteAddress = remoteTarget.getKey();
                Set<K> remoteKeys = remoteTarget.getValue();
                PublisherRequestCommand<K> command = composedType.remoteInvocation(parallelPublisher, null, remoteKeys, null, includeLoader, deliveryGuarantee, transformer, finalizer);
                command.setTopologyId(topology.getTopologyId());
                CompletionStage stage = this.rpcManager.invokeCommand(remoteAddress, command, new KeyPublisherResultCollector(remoteKeys), this.rpcManager.getSyncRpcOptions());
                stage.whenComplete(biConsumer);
            }
        }
        if (localKeys != null) {
            CompletionStage<PublisherResult<R>> localStage = composedType.localInvocation(parallelPublisher, null, localKeys, null, includeLoader, deliveryGuarantee, transformer, finalizer);
            if (trace) {
                localStage = localStage.whenComplete((results, t) -> log.tracef("Result result was: %s for keys %s from %s with %s suspected segments", new Object[]{results.getResult(), localKeys, localAddress, results.getSuspectedSegments()}));
            }
            localStage.whenComplete(biConsumer);
        }
        if (useContext) {
            this.handleContextInvocation(segments, keysToInclude, ctx, composedType, transformer, biConsumer);
        }
    }

    private <I, R> void startSegmentPublisher(boolean parallelPublisher, IntSet segments, InvocationContext ctx, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, ComposedType<K, I, R> composedType, Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer, FlowableProcessor<R> flowableProcessor) {
        Map<Object, Object> keysToExcludeByAddress;
        AtomicInteger parallelCount;
        boolean useContext;
        LocalizedCacheTopology topology = this.distributionManager.getCacheTopology();
        Address localAddress = topology.getLocalAddress();
        Map<Address, IntSet> targets = this.determineSegmentTargets(topology, segments, localAddress);
        boolean bl = useContext = ctx != null && ctx.lookedUpEntriesCount() > 0;
        if (useContext) {
            parallelCount = new AtomicInteger(targets.size() + 1);
            keysToExcludeByAddress = this.determineKeyTargets(topology, ctx.getLookedUpEntries().keySet(), localAddress, segments, null);
        } else {
            parallelCount = new AtomicInteger(targets.size());
            keysToExcludeByAddress = Collections.emptyMap();
        }
        IntSet localSegments = targets.remove(localAddress);
        SegmentSpecificConsumer<I, R> biConsumer = new SegmentSpecificConsumer<I, R>(flowableProcessor, parallelCount, topology.getTopologyId(), parallelPublisher, ctx, includeLoader, deliveryGuarantee, composedType, transformer, finalizer);
        if (!targets.isEmpty()) {
            for (Map.Entry<Address, IntSet> remoteTarget : targets.entrySet()) {
                Address remoteAddress = remoteTarget.getKey();
                IntSet remoteSegments = remoteTarget.getValue();
                PublisherRequestCommand<K> command = composedType.remoteInvocation(parallelPublisher, remoteSegments, null, (Set)keysToExcludeByAddress.get(remoteAddress), includeLoader, deliveryGuarantee, transformer, finalizer);
                command.setTopologyId(topology.getTopologyId());
                CompletionStage stage = this.rpcManager.invokeCommand(remoteAddress, command, new SegmentPublisherResultCollector(remoteSegments), this.rpcManager.getSyncRpcOptions());
                stage.whenComplete(biConsumer);
            }
        }
        if (localSegments != null) {
            CompletionStage<PublisherResult<R>> localStage = composedType.localInvocation(parallelPublisher, localSegments, null, (Set)keysToExcludeByAddress.get(localAddress), includeLoader, deliveryGuarantee, transformer, finalizer);
            if (trace) {
                localStage = localStage.whenComplete((results, t) -> log.tracef("Result result was: %s for segments %s from %s with %s suspected segments", new Object[]{results.getResult(), localSegments, localAddress, results.getSuspectedSegments()}));
            }
            localStage.whenComplete(biConsumer);
        }
        if (useContext) {
            this.handleContextInvocation(segments, null, ctx, composedType, transformer, biConsumer);
        }
    }

    private Map<Address, IntSet> determineSegmentTargets(LocalizedCacheTopology topology, IntSet segments, Address localAddress) {
        HashMap<Address, IntSet> targets = new HashMap<Address, IntSet>();
        if (segments == null) {
            for (int segment = 0; segment < this.maxSegment; ++segment) {
                this.handleSegment(segment, topology, localAddress, targets);
            }
        } else {
            PrimitiveIterator.OfInt iter = segments.iterator();
            while (iter.hasNext()) {
                int segment = iter.nextInt();
                this.handleSegment(segment, topology, localAddress, targets);
            }
        }
        return targets;
    }

    private void handleSegment(int segment, LocalizedCacheTopology topology, Address localAddress, Map<Address, IntSet> targets) {
        DistributionInfo distributionInfo = topology.getSegmentDistribution(segment);
        this.addToMap((Map<Address, Set<K>>)targets, this.determineOwnerToReadFrom(distributionInfo, localAddress), (K)segment);
    }

    private void addToMap(Map<Address, IntSet> map, Address owner, int segment) {
        IntSet set = map.get(owner);
        if (set == null) {
            set = IntSets.mutableEmptySet();
            map.put(owner, set);
        }
        set.set(segment);
    }

    private Address determineOwnerToReadFrom(DistributionInfo distributionInfo, Address localAddress) {
        if (!this.writeBehindShared && distributionInfo.isReadOwner()) {
            return localAddress;
        }
        return distributionInfo.primary();
    }

    private Map<Address, Set<K>> determineKeyTargets(LocalizedCacheTopology topology, Set<K> keys, Address localAddress, IntSet segments, InvocationContext ctx) {
        HashMap<Address, Set<K>> filteredKeys = new HashMap<Address, Set<K>>();
        for (K key : keys) {
            if (ctx != null && ctx.lookupEntry(key) != null) continue;
            DistributionInfo distributionInfo = topology.getDistribution(key);
            if (segments != null && !segments.contains(distributionInfo.segmentId())) continue;
            this.addToMap(filteredKeys, this.determineOwnerToReadFrom(distributionInfo, localAddress), key);
        }
        return filteredKeys;
    }

    private void addToMap(Map<Address, Set<K>> map, Address owner, K key) {
        Set<K> set = map.get(owner);
        if (set == null) {
            set = new HashSet<K>();
            map.put(owner, set);
        }
        set.add(key);
    }

    private boolean hasWriteBehindSharedStore(PersistenceConfiguration persistenceConfiguration) {
        for (StoreConfiguration storeConfiguration : persistenceConfiguration.stores()) {
            if (!storeConfiguration.shared() || !storeConfiguration.async().enabled()) continue;
            return true;
        }
        return false;
    }

    class EntryComposedType<R>
    implements ComposedType<K, CacheEntry<K, V>, R> {
        EntryComposedType() {
        }

        @Override
        public CompletionStage<PublisherResult<R>> localInvocation(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
            return ClusterPublisherManagerImpl.this.localPublisherManager.entryReduction(parallelPublisher, segments, keysToInclude, keysToExclude, includeLoader, deliveryGuarantee, transformer, finalizer);
        }

        @Override
        public PublisherRequestCommand<K> remoteInvocation(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
            return ClusterPublisherManagerImpl.this.commandsFactory.buildEntryPublisherCommand(parallelPublisher, deliveryGuarantee, segments, keysToInclude, keysToExclude, includeLoader, transformer, finalizer);
        }

        @Override
        public CompletionStage<PublisherResult<R>> contextInvocation(IntSet segments, Set<K> keysToInclude, InvocationContext ctx, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer) {
            return transformer.apply((Publisher)LocalClusterPublisherManagerImpl.entryPublisherFromContext(ctx, keysToInclude)).thenApply(LocalPublisherManagerImpl.ignoreSegmentsFunction());
        }
    }

    class KeyComposedType<R>
    implements ComposedType<K, K, R> {
        KeyComposedType() {
        }

        @Override
        public CompletionStage<PublisherResult<R>> localInvocation(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
            return ClusterPublisherManagerImpl.this.localPublisherManager.keyReduction(parallelPublisher, segments, keysToInclude, keysToExclude, includeLoader, deliveryGuarantee, transformer, finalizer);
        }

        @Override
        public PublisherRequestCommand<K> remoteInvocation(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
            return ClusterPublisherManagerImpl.this.commandsFactory.buildKeyPublisherCommand(parallelPublisher, deliveryGuarantee, segments, keysToInclude, keysToExclude, includeLoader, transformer, finalizer);
        }

        @Override
        public CompletionStage<PublisherResult<R>> contextInvocation(IntSet segments, Set<K> keysToInclude, InvocationContext ctx, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer) {
            return transformer.apply((Publisher)LocalClusterPublisherManagerImpl.keyPublisherFromContext(ctx, keysToInclude)).thenApply(LocalPublisherManagerImpl.ignoreSegmentsFunction());
        }
    }

    static interface ComposedType<K, I, R> {
        public CompletionStage<PublisherResult<R>> localInvocation(boolean var1, IntSet var2, Set<K> var3, Set<K> var4, boolean var5, DeliveryGuarantee var6, Function<? super Publisher<I>, ? extends CompletionStage<R>> var7, Function<? super Publisher<R>, ? extends CompletionStage<R>> var8);

        public PublisherRequestCommand<K> remoteInvocation(boolean var1, IntSet var2, Set<K> var3, Set<K> var4, boolean var5, DeliveryGuarantee var6, Function<? super Publisher<I>, ? extends CompletionStage<R>> var7, Function<? super Publisher<R>, ? extends CompletionStage<R>> var8);

        public CompletionStage<PublisherResult<R>> contextInvocation(IntSet var1, Set<K> var2, InvocationContext var3, Function<? super Publisher<I>, ? extends CompletionStage<R>> var4);
    }

    private class SegmentPublisherResultCollector<R>
    extends ValidResponseCollector<PublisherResult<R>> {
        private final IntSet targetSegments;

        SegmentPublisherResultCollector(IntSet targetSegments) {
            this.targetSegments = targetSegments;
        }

        @Override
        public PublisherResult<R> finish() {
            throw new IllegalStateException("Should never be invoked!");
        }

        @Override
        protected PublisherResult<R> addValidResponse(Address sender, ValidResponse response) {
            PublisherResult results = (PublisherResult)response.getResponseValue();
            if (trace) {
                log.tracef("Result result was: %s for segments %s from %s with %s suspected segments", new Object[]{results.getResult(), this.targetSegments, sender, results.getSuspectedSegments()});
            }
            return results;
        }

        @Override
        protected PublisherResult<R> addTargetNotFound(Address sender) {
            if (trace) {
                log.tracef("Cache is no longer running for segments %s from %s - must retry", this.targetSegments, sender);
            }
            return new SegmentPublisherResult<Object>(this.targetSegments, null);
        }

        @Override
        protected PublisherResult<R> addException(Address sender, Exception exception) {
            if (trace) {
                log.tracef(exception, "Exception encountered while requesting segments %s from %s", this.targetSegments, sender);
            }
            if (exception instanceof CacheException) {
                throw (CacheException)((Object)exception);
            }
            throw new CacheException((Throwable)exception);
        }
    }

    private class KeyPublisherResultCollector<R>
    extends ValidResponseCollector<PublisherResult<R>> {
        private final Set<K> keys;

        KeyPublisherResultCollector(Set<K> keys) {
            this.keys = keys;
        }

        @Override
        public PublisherResult<R> finish() {
            throw new IllegalStateException("Should never be invoked!");
        }

        @Override
        protected PublisherResult<R> addValidResponse(Address sender, ValidResponse response) {
            PublisherResult results = (PublisherResult)response.getResponseValue();
            if (trace) {
                log.tracef("Result result was: %s for keys %s from %s", results.getResult(), this.keys, sender);
            }
            return results;
        }

        @Override
        protected PublisherResult<R> addTargetNotFound(Address sender) {
            if (trace) {
                log.tracef("Cache is no longer running for keys %s from %s - must retry", Util.toStr(this.keys), sender);
            }
            return new KeyPublisherResult(this.keys);
        }

        @Override
        protected PublisherResult<R> addException(Address sender, Exception exception) {
            if (trace) {
                log.tracef(exception, "Exception encountered while requesting keys %s from %s", Util.toStr(this.keys), sender);
            }
            if (exception instanceof CacheException) {
                throw (CacheException)((Object)exception);
            }
            throw new CacheException((Throwable)exception);
        }
    }

    private class KeyBiConsumer<I, R>
    implements BiConsumer<PublisherResult<R>, Throwable> {
        private final FlowableProcessor<R> flowableProcessor;
        private final AtomicInteger parallelCount;
        private final Set<K> keysToRetry = ConcurrentHashMap.newKeySet();
        private final int currentTopologyId;
        private final boolean parallelPublisher;
        private final boolean includeLoader;
        private final DeliveryGuarantee deliveryGuarantee;
        private final ComposedType<K, I, R> composedType;
        private final Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer;
        private final Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer;

        KeyBiConsumer(FlowableProcessor<R> flowableProcessor, AtomicInteger parallelCount, int currentTopologyId, boolean parallelPublisher, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, ComposedType<K, I, R> composedType, Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
            this.flowableProcessor = flowableProcessor;
            this.parallelCount = parallelCount;
            this.currentTopologyId = currentTopologyId;
            this.parallelPublisher = parallelPublisher;
            this.includeLoader = includeLoader;
            this.deliveryGuarantee = deliveryGuarantee;
            this.composedType = composedType;
            this.transformer = transformer;
            this.finalizer = finalizer;
        }

        @Override
        public void accept(PublisherResult<R> resultCollector, Throwable t) {
            if (t != null) {
                if (trace) {
                    log.tracef(t, "General error encountered when executing publisher request command", new Object[0]);
                }
                this.flowableProcessor.onError(t);
            } else {
                this.handleResult(resultCollector);
                if (this.parallelCount.decrementAndGet() == 0) {
                    this.onCompletion();
                }
            }
        }

        private void handleResult(PublisherResult<R> result) {
            R actualValue = result.getResult();
            if (actualValue != null) {
                this.flowableProcessor.onNext(actualValue);
            } else {
                this.keysToRetry.addAll(result.getSuspectedKeys());
            }
        }

        private void onCompletion() {
            if (this.keysToRetry.isEmpty()) {
                this.flowableProcessor.onComplete();
            } else {
                int nextTopology = this.currentTopologyId + 1;
                if (trace) {
                    log.tracef("Retrying keys %s after %d is installed", this.keysToRetry, nextTopology);
                }
                ClusterPublisherManagerImpl.this.stateTransferLock.topologyFuture(nextTopology).whenComplete((ign, innerT) -> {
                    if (innerT != null) {
                        if (trace) {
                            log.tracef((Throwable)innerT, "General error encountered when waiting on topology future for publisher request command", new Object[0]);
                        }
                        this.flowableProcessor.onError(innerT);
                    } else {
                        ClusterPublisherManagerImpl.this.startKeyPublisher(this.parallelPublisher, null, this.keysToRetry, null, this.includeLoader, this.deliveryGuarantee, this.composedType, this.transformer, this.finalizer, this.flowableProcessor);
                    }
                });
            }
        }
    }

    private class SegmentSpecificConsumer<I, R>
    implements BiConsumer<PublisherResult<R>, Throwable> {
        private final FlowableProcessor<R> flowableProcessor;
        private final AtomicInteger parallelCount;
        private final IntSet segmentsToRetry;
        private final int currentTopologyId;
        private final boolean parallelPublisher;
        private final InvocationContext ctx;
        private final boolean includeLoader;
        private final DeliveryGuarantee deliveryGuarantee;
        private final ComposedType<K, I, R> composedType;
        private final Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer;
        private final Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer;

        SegmentSpecificConsumer(FlowableProcessor<R> flowableProcessor, AtomicInteger parallelCount, int currentTopologyId, boolean parallelPublisher, InvocationContext ctx, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, ComposedType<K, I, R> composedType, Function<? super Publisher<I>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
            this.segmentsToRetry = IntSets.concurrentSet((int)ClusterPublisherManagerImpl.this.maxSegment);
            this.flowableProcessor = flowableProcessor;
            this.parallelCount = parallelCount;
            this.currentTopologyId = currentTopologyId;
            this.parallelPublisher = parallelPublisher;
            this.ctx = ctx;
            this.includeLoader = includeLoader;
            this.deliveryGuarantee = deliveryGuarantee;
            this.composedType = composedType;
            this.transformer = transformer;
            this.finalizer = finalizer;
        }

        @Override
        public void accept(PublisherResult<R> resultCollector, Throwable t) {
            if (t != null) {
                if (trace) {
                    log.tracef(t, "General error encountered when executing publisher request command", new Object[0]);
                }
                this.flowableProcessor.onError(t);
            } else {
                this.handleResult(resultCollector);
                if (this.parallelCount.decrementAndGet() == 0) {
                    this.onCompletion();
                }
            }
        }

        private void handleResult(PublisherResult<R> result) {
            R actualValue;
            IntSet suspectedSegments = result.getSuspectedSegments();
            if (suspectedSegments != null && !suspectedSegments.isEmpty()) {
                this.segmentsToRetry.addAll(suspectedSegments);
            }
            if ((actualValue = result.getResult()) != null) {
                this.flowableProcessor.onNext(actualValue);
            }
        }

        private void onCompletion() {
            if (this.segmentsToRetry.isEmpty()) {
                this.flowableProcessor.onComplete();
            } else {
                int nextTopology = this.currentTopologyId + 1;
                if (trace) {
                    log.tracef("Retrying segments %s after %d is installed", this.segmentsToRetry, nextTopology);
                }
                ClusterPublisherManagerImpl.this.stateTransferLock.topologyFuture(nextTopology).whenComplete((ign, innerT) -> {
                    if (innerT != null) {
                        if (trace) {
                            log.tracef((Throwable)innerT, "General error encountered when waiting on topology future for publisher request command", new Object[0]);
                        }
                        this.flowableProcessor.onError(innerT);
                    } else {
                        ClusterPublisherManagerImpl.this.startSegmentPublisher(this.parallelPublisher, this.segmentsToRetry, this.ctx, this.includeLoader, this.deliveryGuarantee, this.composedType, this.transformer, this.finalizer, this.flowableProcessor);
                    }
                });
            }
        }
    }
}

