/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl;

import io.reactivex.Flowable;
import io.reactivex.processors.UnicastProcessor;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.reactive.publisher.impl.ClusterPublisherManager;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.reactive.publisher.impl.PublisherResult;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class LocalClusterPublisherManagerImpl<K, V>
implements ClusterPublisherManager<K, V> {
    @Inject
    LocalPublisherManager<K, V> localPublisherManager;
    @Inject
    Configuration cacheConfiguration;
    private int maxSegment;

    @Start
    public void start() {
        this.maxSegment = this.cacheConfiguration.clustering().cacheMode().needsStateTransfer() || this.cacheConfiguration.persistence().stores().stream().filter(StoreConfiguration::segmented).findFirst().isPresent() ? this.cacheConfiguration.clustering().hash().numSegments() : 1;
    }

    static <K> Flowable<K> keyPublisherFromContext(InvocationContext ctx, Set<K> keysToInclude) {
        UnicastProcessor unicastProcessor = UnicastProcessor.create((int)ctx.lookedUpEntriesCount());
        ctx.forEachValue((o, cacheEntry) -> {
            Object key = o;
            if (keysToInclude == null || keysToInclude.contains(key)) {
                unicastProcessor.onNext(key);
            }
        });
        unicastProcessor.onComplete();
        return unicastProcessor;
    }

    static <K, V> Flowable<CacheEntry<K, V>> entryPublisherFromContext(InvocationContext ctx, Set<K> keysToInclude) {
        UnicastProcessor unicastProcessor = UnicastProcessor.create((int)ctx.lookedUpEntriesCount());
        ctx.forEachValue((o, cacheEntry) -> {
            Object key = o;
            if (keysToInclude == null || keysToInclude.contains(key)) {
                unicastProcessor.onNext(cacheEntry);
            }
        });
        unicastProcessor.onComplete();
        return unicastProcessor;
    }

    IntSet handleNullSegments(IntSet segments) {
        return segments != null ? segments : IntSets.immutableRangeSet((int)this.maxSegment);
    }

    @Override
    public <R> CompletionStage<R> keyReduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext invocationContext, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<K>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        if (invocationContext == null || invocationContext.lookedUpEntriesCount() == 0) {
            return this.localPublisherManager.keyReduction(parallelPublisher, this.handleNullSegments(segments), keysToInclude, null, includeLoader, DeliveryGuarantee.AT_MOST_ONCE, transformer, finalizer).thenApply(PublisherResult::getResult);
        }
        HashSet keysToExclude = new HashSet(invocationContext.lookedUpEntriesCount());
        invocationContext.forEachEntry((key, ce) -> keysToExclude.add(key));
        CompletionStage<Object> stage = this.localPublisherManager.keyReduction(parallelPublisher, segments, keysToInclude, keysToExclude, includeLoader, DeliveryGuarantee.AT_MOST_ONCE, transformer, finalizer).thenApply(PublisherResult::getResult);
        Flowable<K> entryFlowable = LocalClusterPublisherManagerImpl.keyPublisherFromContext(invocationContext, keysToInclude);
        return transformer.apply((Publisher<K>)entryFlowable).thenCombine(stage, Flowable::just).thenCompose(finalizer);
    }

    @Override
    public <R> CompletionStage<R> entryReduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, InvocationContext invocationContext, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> transformer, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        if (invocationContext == null || invocationContext.lookedUpEntriesCount() == 0) {
            return this.localPublisherManager.entryReduction(parallelPublisher, this.handleNullSegments(segments), keysToInclude, null, includeLoader, DeliveryGuarantee.AT_MOST_ONCE, transformer, finalizer).thenApply(PublisherResult::getResult);
        }
        HashSet keysToExclude = new HashSet(invocationContext.lookedUpEntriesCount());
        invocationContext.forEachEntry((key, ce) -> keysToExclude.add(key));
        CompletionStage<Object> stage = this.localPublisherManager.entryReduction(parallelPublisher, segments, keysToInclude, keysToExclude, includeLoader, DeliveryGuarantee.AT_MOST_ONCE, transformer, finalizer).thenApply(PublisherResult::getResult);
        Flowable<CacheEntry<K, V>> entryFlowable = LocalClusterPublisherManagerImpl.entryPublisherFromContext(invocationContext, keysToInclude);
        return transformer.apply((Publisher<CacheEntry<K, V>>)entryFlowable).thenCombine(stage, Flowable::just).thenCompose(finalizer);
    }
}

