/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl;

import io.reactivex.Flowable;
import io.reactivex.Scheduler;
import io.reactivex.parallel.ParallelFlowable;
import io.reactivex.processors.FlowableProcessor;
import io.reactivex.processors.UnicastProcessor;
import io.reactivex.schedulers.Schedulers;
import java.lang.invoke.MethodHandles;
import java.util.PrimitiveIterator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.IntConsumer;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.cache.impl.AbstractDelegatingCache;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.IntSets;
import org.infinispan.commons.util.ProcessorInfo;
import org.infinispan.configuration.cache.ClusteringConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.NullCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.reactive.RxJavaInterop;
import org.infinispan.reactive.publisher.impl.DeliveryGuarantee;
import org.infinispan.reactive.publisher.impl.LocalPublisherManager;
import org.infinispan.reactive.publisher.impl.PublisherResult;
import org.infinispan.reactive.publisher.impl.SegmentPublisherResult;
import org.infinispan.stream.StreamMarshalling;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.rxjava.FlowableFromIntSetFunction;
import org.reactivestreams.Publisher;

@Scope(value=Scopes.NAMED_CACHE)
public class LocalPublisherManagerImpl<K, V>
implements LocalPublisherManager<K, V> {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    ComponentRef<Cache<K, V>> cacheComponentRef;
    @Inject
    DistributionManager distributionManager;
    protected AdvancedCache<K, V> remoteCache;
    protected AdvancedCache<K, V> cache;
    protected Scheduler asyncScheduler;
    protected int maxSegment;
    protected boolean hasLoader;
    protected final int cpuCount = ProcessorInfo.availableProcessors();
    protected final Set<SegmentListener> changeListener = ConcurrentHashMap.newKeySet();
    private static Function<Object, PublisherResult<Object>> ignoreSegmentsFunction = value -> new SegmentPublisherResult<Object>(IntSets.immutableEmptySet(), value);

    @Inject
    public void inject(@ComponentName(value="org.infinispan.executors.async") ExecutorService asyncOperationsExecutor) {
        this.asyncScheduler = Schedulers.from((Executor)asyncOperationsExecutor);
    }

    @Start
    public void start() {
        this.remoteCache = AbstractDelegatingCache.unwrapCache(this.cacheComponentRef.running()).getAdvancedCache();
        this.cache = this.remoteCache.withFlags(Flag.CACHE_MODE_LOCAL, Flag.REMOTE_ITERATION);
        this.hasLoader = this.cache.getCacheConfiguration().persistence().usingStores();
        ClusteringConfiguration clusteringConfiguration = this.cache.getCacheConfiguration().clustering();
        this.maxSegment = clusteringConfiguration.hash().numSegments();
    }

    @Override
    public <R> CompletionStage<PublisherResult<R>> keyReduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<K>, ? extends CompletionStage<R>> collator, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        if (keysToInclude != null) {
            return this.handleSpecificKeys(parallelPublisher, keysToInclude, keysToExclude, deliveryGuarantee, collator, finalizer);
        }
        AdvancedCache<K, V> cache = this.getCacheWithFlags(includeLoader);
        Function toKeyFunction = Function.identity();
        switch (deliveryGuarantee) {
            case AT_MOST_ONCE: {
                CompletionStage<R> stage = this.atMostOnce(parallelPublisher, cache.keySet(), keysToExclude, toKeyFunction, segments, collator, finalizer);
                return stage.thenApply(LocalPublisherManagerImpl.ignoreSegmentsFunction());
            }
            case AT_LEAST_ONCE: {
                return this.atLeastOnce(parallelPublisher, cache.keySet(), keysToExclude, toKeyFunction, segments, collator, finalizer);
            }
            case EXACTLY_ONCE: {
                return this.exactlyOnce(parallelPublisher, cache.keySet(), keysToExclude, toKeyFunction, segments, collator, finalizer);
            }
        }
        throw new UnsupportedOperationException("Unsupported delivery guarantee: " + (Object)((Object)deliveryGuarantee));
    }

    @Override
    public <R> CompletionStage<PublisherResult<R>> entryReduction(boolean parallelPublisher, IntSet segments, Set<K> keysToInclude, Set<K> keysToExclude, boolean includeLoader, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> collator, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        if (keysToInclude != null) {
            return this.handleSpecificEntries(parallelPublisher, keysToInclude, keysToExclude, deliveryGuarantee, collator, finalizer);
        }
        AdvancedCache<K, V> cache = this.getCacheWithFlags(includeLoader);
        Function toKeyFunction = StreamMarshalling.entryToKeyFunction();
        switch (deliveryGuarantee) {
            case AT_MOST_ONCE: {
                CompletionStage<R> stage = this.atMostOnce(parallelPublisher, cache.cacheEntrySet(), keysToExclude, toKeyFunction, segments, collator, finalizer);
                return stage.thenApply(LocalPublisherManagerImpl.ignoreSegmentsFunction());
            }
            case AT_LEAST_ONCE: {
                return this.atLeastOnce(parallelPublisher, cache.cacheEntrySet(), keysToExclude, toKeyFunction, segments, collator, finalizer);
            }
            case EXACTLY_ONCE: {
                return this.exactlyOnce(parallelPublisher, cache.cacheEntrySet(), keysToExclude, toKeyFunction, segments, collator, finalizer);
            }
        }
        throw new UnsupportedOperationException("Unsupported delivery guarantee: " + (Object)((Object)deliveryGuarantee));
    }

    @Override
    public void segmentsLost(IntSet lostSegments) {
        if (trace) {
            log.tracef("Notifying listeners of lost segments %s", lostSegments);
        }
        this.changeListener.forEach(arg_0 -> ((IntSet)lostSegments).forEach(arg_0));
    }

    static <R> Function<R, PublisherResult<R>> ignoreSegmentsFunction() {
        return ignoreSegmentsFunction;
    }

    private <I, R> void handleParallelSegment(PrimitiveIterator.OfInt segmentIter, int initialSegment, CacheSet<I> set, Set<K> keysToExclude, Function<I, K> toKeyFunction, Function<? super Publisher<I>, ? extends CompletionStage<R>> collator, FlowableProcessor<R> processor, IntSet concurrentSegments, SegmentListener listener) {
        AtomicInteger pendingCompletions = new AtomicInteger(1);
        boolean serializedProcessor = false;
        try {
            while (true) {
                CompletionStage<R> stage;
                int nextSegment;
                if (initialSegment != -1) {
                    nextSegment = initialSegment;
                    initialSegment = -1;
                } else {
                    nextSegment = this.getNextSegment(segmentIter);
                    if (nextSegment == -1) break;
                }
                pendingCompletions.getAndIncrement();
                Flowable innerFlowable = Flowable.fromPublisher(set.localPublisher(nextSegment));
                if (keysToExclude != null) {
                    innerFlowable = innerFlowable.filter(i -> !keysToExclude.contains(toKeyFunction.apply(i)));
                }
                if (CompletionStages.isCompletedSuccessfully(stage = collator.apply((Publisher<I>)innerFlowable))) {
                    concurrentSegments.remove(nextSegment);
                    V notifiedValue = listener.segmentsLost.contains(nextSegment) ? null : (V)CompletionStages.join(stage);
                    LocalPublisherManagerImpl.completeTask(pendingCompletions, notifiedValue, processor);
                    continue;
                }
                if (!serializedProcessor) {
                    serializedProcessor = true;
                    processor = processor.toSerialized();
                }
                FlowableProcessor processorToUse = processor;
                stage.whenComplete((value, t) -> {
                    if (t != null) {
                        processorToUse.onError(t);
                    } else {
                        concurrentSegments.remove(nextSegment);
                        Object notifiedValue = listener.segmentsLost.contains(nextSegment) ? null : value;
                        LocalPublisherManagerImpl.completeTask(pendingCompletions, notifiedValue, processorToUse);
                    }
                });
            }
            LocalPublisherManagerImpl.completeTask(pendingCompletions, null, processor);
        }
        catch (Throwable t2) {
            processor.onError(t2);
        }
    }

    private static <V> void completeTask(AtomicInteger count, V value, FlowableProcessor<V> processor) {
        if (value != null) {
            processor.onNext(value);
        }
        if (count.decrementAndGet() == 0) {
            processor.onComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextSegment(PrimitiveIterator.OfInt segmentIter) {
        PrimitiveIterator.OfInt ofInt = segmentIter;
        synchronized (ofInt) {
            if (segmentIter.hasNext()) {
                return segmentIter.nextInt();
            }
            return -1;
        }
    }

    private <I, R> CompletionStage<PublisherResult<R>> exactlyOnce(boolean parallelPublisher, CacheSet<I> set, Set<K> keysToExclude, Function<I, K> toKeyFunction, IntSet segments, Function<? super Publisher<I>, ? extends CompletionStage<R>> collator, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        IntSet concurrentSegments = IntSets.concurrentCopyFrom((IntSet)segments, (int)this.maxSegment);
        SegmentListener listener = new SegmentListener(concurrentSegments);
        this.changeListener.add(listener);
        listener.verifyTopology(this.distributionManager.getCacheTopology());
        Flowable<R> resultFlowable = parallelPublisher ? this.exactlyOnceParallel(set, keysToExclude, toKeyFunction, segments, collator, listener, concurrentSegments) : this.exactlyOnceSequential(set, keysToExclude, toKeyFunction, segments, collator, listener, concurrentSegments);
        return this.exactlyOnceHandleLostSegments(finalizer.apply((Publisher<R>)resultFlowable), listener);
    }

    protected <R> CompletionStage<PublisherResult<R>> exactlyOnceHandleLostSegments(CompletionStage<R> finalValue, SegmentListener listener) {
        return this.handleLostSegments(finalValue, listener);
    }

    protected <I, R> Flowable<R> exactlyOnceParallel(CacheSet<I> set, Set<K> keysToExclude, Function<I, K> toKeyFunction, IntSet segments, Function<? super Publisher<I>, ? extends CompletionStage<R>> collator, SegmentListener listener, IntSet concurrentSegments) {
        int extraThreadCount = this.cpuCount - 1;
        Flowable[] processors = new Flowable[extraThreadCount + 1];
        PrimitiveIterator.OfInt segmentIter = segments.iterator();
        for (int i = 0; i < extraThreadCount; ++i) {
            int initialSegment = this.getNextSegment(segmentIter);
            if (initialSegment == -1) {
                processors[i] = Flowable.empty();
                continue;
            }
            UnicastProcessor processor = UnicastProcessor.create();
            processors[i] = processor;
            this.asyncScheduler.scheduleDirect(() -> this.lambda$exactlyOnceParallel$3(segmentIter, initialSegment, set, keysToExclude, toKeyFunction, collator, (FlowableProcessor)processor, concurrentSegments, listener));
        }
        int initialSegment = this.getNextSegment(segmentIter);
        if (initialSegment != -1) {
            UnicastProcessor processor = UnicastProcessor.create();
            processors[extraThreadCount] = processor;
            this.handleParallelSegment(segmentIter, initialSegment, set, keysToExclude, toKeyFunction, collator, (FlowableProcessor<R>)processor, concurrentSegments, listener);
        } else {
            processors[extraThreadCount] = Flowable.empty();
        }
        return ParallelFlowable.fromArray((Publisher[])processors).sequential();
    }

    protected <I, R> Flowable<R> exactlyOnceSequential(CacheSet<I> set, Set<K> keysToExclude, Function<I, K> toKeyFunction, IntSet segments, Function<? super Publisher<I>, ? extends CompletionStage<R>> collator, SegmentListener listener, IntSet concurrentSegments) {
        return this.combineStages(new FlowableFromIntSetFunction<CompletionStage>(segments, segment -> {
            CompletionStage stage;
            Flowable innerFlowable = Flowable.fromPublisher(set.localPublisher(segment)).doOnComplete(() -> concurrentSegments.remove(segment));
            if (keysToExclude != null) {
                innerFlowable = innerFlowable.filter(i -> !keysToExclude.contains(toKeyFunction.apply(i)));
            }
            if (CompletionStages.isCompletedSuccessfully(stage = (CompletionStage)collator.apply((Object)innerFlowable))) {
                if (listener.segmentsLost.contains(segment)) {
                    return CompletableFutures.completedNull();
                }
                return stage;
            }
            return stage.thenCompose(value -> {
                if (listener.segmentsLost.contains(segment)) {
                    return CompletableFutures.completedNull();
                }
                return CompletableFuture.completedFuture(value);
            });
        }));
    }

    private <R> CompletionStage<PublisherResult<R>> handleSpecificKeys(boolean parallelPublisher, Set<K> keysToInclude, Set<K> keysToExclude, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<K>, ? extends CompletionStage<R>> collator, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        AdvancedCache cache = deliveryGuarantee == DeliveryGuarantee.AT_MOST_ONCE ? this.cache : this.remoteCache;
        return this.handleSpecificObjects(parallelPublisher, keysToInclude, keysToExclude, keyFlowable -> keyFlowable.filter(arg_0 -> cache.containsKey(arg_0)), collator, finalizer);
    }

    private <R> CompletionStage<PublisherResult<R>> handleSpecificEntries(boolean parallelPublisher, Set<K> keysToInclude, Set<K> keysToExclude, DeliveryGuarantee deliveryGuarantee, Function<? super Publisher<CacheEntry<K, V>>, ? extends CompletionStage<R>> collator, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        AdvancedCache cache = deliveryGuarantee == DeliveryGuarantee.AT_MOST_ONCE ? this.cache : this.remoteCache;
        return this.handleSpecificObjects(parallelPublisher, keysToInclude, keysToExclude, keyFlowable -> keyFlowable.map(k -> {
            CacheEntry entry = cache.getCacheEntry(k);
            if (entry == null) {
                return NullCacheEntry.getInstance();
            }
            return entry;
        }).filter(e -> e != NullCacheEntry.getInstance()), collator, finalizer);
    }

    private <I, R> CompletionStage<PublisherResult<R>> handleSpecificObjects(boolean parallelPublisher, Set<K> keysToInclude, Set<K> keysToExclude, Function<? super Flowable<K>, ? extends Flowable<I>> keyTransformer, Function<? super Publisher<I>, ? extends CompletionStage<R>> collator, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        Flowable keyFlowable = Flowable.fromIterable(keysToInclude);
        if (keysToExclude != null) {
            keyFlowable = keyFlowable.filter(k -> !keysToExclude.contains(k));
        }
        if (parallelPublisher) {
            Flowable stageFlowable = keyFlowable.window(16L).flatMap(keys -> {
                CompletionStage stage = (CompletionStage)((Flowable)keyTransformer.apply((Flowable<K>)keys)).subscribeOn(this.asyncScheduler).to(collator::apply);
                return (Publisher)RxJavaInterop.completionStageToPublisher().apply(stage);
            });
            return finalizer.apply((Publisher<R>)stageFlowable).thenApply(LocalPublisherManagerImpl.ignoreSegmentsFunction());
        }
        return ((CompletionStage)keyTransformer.apply(keyFlowable).to(collator::apply)).thenApply(LocalPublisherManagerImpl.ignoreSegmentsFunction());
    }

    private <I, R> CompletionStage<R> parallelAtMostOnce(CacheSet<I> cacheSet, Set<K> keysToExclude, Function<I, K> toKeyFunction, IntSet segments, Function<? super Publisher<I>, ? extends CompletionStage<R>> collator, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        Flowable stageFlowable = Flowable.fromIterable((Iterable)segments).parallel().runOn(this.asyncScheduler).map(segment -> {
            Flowable innerFlowable = Flowable.fromPublisher(cacheSet.localPublisher((int)segment));
            if (keysToExclude != null) {
                innerFlowable = innerFlowable.filter(i -> !keysToExclude.contains(toKeyFunction.apply(i)));
            }
            return (CompletionStage)collator.apply((Object)innerFlowable);
        }).sequential();
        return this.combineStages(stageFlowable, finalizer);
    }

    private <I, R> CompletionStage<R> atMostOnce(boolean parallel, CacheSet<I> set, Set<K> keysToExclude, Function<I, K> toKeyFunction, IntSet segments, Function<? super Publisher<I>, ? extends CompletionStage<R>> collator, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        if (parallel) {
            return this.parallelAtMostOnce(set, keysToExclude, toKeyFunction, segments, collator, finalizer);
        }
        Flowable flowable = Flowable.fromPublisher(set.localPublisher(segments));
        if (keysToExclude != null) {
            flowable = flowable.filter(i -> !keysToExclude.contains(toKeyFunction.apply(i)));
        }
        return collator.apply((Publisher<I>)flowable);
    }

    private <I, R> CompletionStage<PublisherResult<R>> atLeastOnce(boolean parallel, CacheSet<I> cacheSet, Set<K> keysToExclude, Function<I, K> toKeyFunction, IntSet segments, Function<? super Publisher<I>, ? extends CompletionStage<R>> collator, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        SegmentListener listener = new SegmentListener(segments);
        this.changeListener.add(listener);
        listener.verifyTopology(this.distributionManager.getCacheTopology());
        CompletionStage<R> stage = this.atMostOnce(parallel, cacheSet, keysToExclude, toKeyFunction, segments, collator, finalizer);
        return this.handleLostSegments(stage, listener);
    }

    protected <R> CompletionStage<PublisherResult<R>> handleLostSegments(CompletionStage<R> stage, SegmentListener segmentListener) {
        return stage.thenApply(value -> {
            IntSet lostSegments = segmentListener.segmentsLost;
            if (lostSegments.isEmpty()) {
                return LocalPublisherManagerImpl.ignoreSegmentsFunction().apply(value);
            }
            return new SegmentPublisherResult<Object>(lostSegments, value);
        }).whenComplete((u, t) -> this.changeListener.remove(segmentListener));
    }

    protected <R> CompletionStage<R> combineStages(Flowable<? extends CompletionStage<R>> stagePublisher, Function<? super Publisher<R>, ? extends CompletionStage<R>> finalizer) {
        return finalizer.apply((Publisher<R>)this.combineStages(stagePublisher));
    }

    protected <R> Flowable<R> combineStages(Flowable<? extends CompletionStage<R>> stagePublisher) {
        return stagePublisher.flatMap(stage -> {
            if (stage == CompletableFutures.completedNull()) {
                return Flowable.empty();
            }
            if (CompletionStages.isCompletedSuccessfully(stage)) {
                Object value = CompletionStages.join(stage);
                if (value == null) {
                    return Flowable.empty();
                }
                return Flowable.just(value);
            }
            return (Publisher)RxJavaInterop.completionStageToPublisher().apply(stage);
        });
    }

    private AdvancedCache<K, V> getCacheWithFlags(boolean includeLoader) {
        if (this.hasLoader && !includeLoader) {
            return this.cache.withFlags(Flag.SKIP_CACHE_LOAD);
        }
        return this.cache;
    }

    private /* synthetic */ void lambda$exactlyOnceParallel$3(PrimitiveIterator.OfInt segmentIter, int initialSegment, CacheSet set, Set keysToExclude, Function toKeyFunction, Function collator, FlowableProcessor processor, IntSet concurrentSegments, SegmentListener listener) {
        this.handleParallelSegment(segmentIter, initialSegment, set, keysToExclude, toKeyFunction, collator, processor, concurrentSegments, listener);
    }

    protected class SegmentListener
    implements IntConsumer {
        protected final IntSet segments;
        protected final IntSet segmentsLost;

        SegmentListener(IntSet segments) {
            this.segments = segments;
            this.segmentsLost = IntSets.concurrentSet((int)LocalPublisherManagerImpl.this.maxSegment);
        }

        @Override
        public void accept(int segment) {
            if (this.segments.contains(segment)) {
                if (trace) {
                    log.tracef("Listener %s lost segment %d", this, segment);
                }
                this.segmentsLost.set(segment);
            }
        }

        public void verifyTopology(LocalizedCacheTopology localizedCacheTopology) {
            PrimitiveIterator.OfInt segmentIterator = this.segments.iterator();
            while (segmentIterator.hasNext()) {
                int segment = segmentIterator.nextInt();
                if (localizedCacheTopology.isSegmentReadOwner(segment)) continue;
                this.segmentsLost.set(segment);
            }
        }
    }
}

