/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.ResponseFilter;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.BackupResponse;
import org.infinispan.remoting.transport.ResponseCollector;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.util.logging.Log;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;

@Scope(value=Scopes.GLOBAL)
public abstract class AbstractDelegatingTransport
implements Transport {
    protected final Transport actual;

    protected AbstractDelegatingTransport(Transport actual) {
        this.actual = actual;
    }

    @Override
    public Map<Address, Response> invokeRemotely(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        this.beforeInvokeRemotely(rpcCommand);
        Map<Address, Response> result = this.actual.invokeRemotely(recipients, rpcCommand, mode, timeout, responseFilter, deliverOrder, anycast);
        return this.afterInvokeRemotely(rpcCommand, result);
    }

    @Override
    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcCommands, ResponseMode mode, long timeout, boolean usePriorityQueue, ResponseFilter responseFilter, boolean totalOrder, boolean anycast) throws Exception {
        return this.actual.invokeRemotely(rpcCommands, mode, timeout, usePriorityQueue, responseFilter, totalOrder, anycast);
    }

    @Override
    public Map<Address, Response> invokeRemotely(Map<Address, ReplicableCommand> rpcCommands, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        return this.actual.invokeRemotely(rpcCommands, mode, timeout, responseFilter, deliverOrder, anycast);
    }

    @Override
    public CompletableFuture<Map<Address, Response>> invokeRemotelyAsync(Collection<Address> recipients, ReplicableCommand rpcCommand, ResponseMode mode, long timeout, ResponseFilter responseFilter, DeliverOrder deliverOrder, boolean anycast) throws Exception {
        return this.actual.invokeRemotelyAsync(recipients, rpcCommand, mode, timeout, responseFilter, deliverOrder, anycast);
    }

    @Override
    public void sendTo(Address destination, ReplicableCommand rpcCommand, DeliverOrder deliverOrder) throws Exception {
        this.actual.sendTo(destination, rpcCommand, deliverOrder);
    }

    @Override
    public void sendToMany(Collection<Address> destinations, ReplicableCommand rpcCommand, DeliverOrder deliverOrder) throws Exception {
        this.actual.sendToMany(destinations, rpcCommand, deliverOrder);
    }

    @Override
    public void sendToAll(ReplicableCommand rpcCommand, DeliverOrder deliverOrder) throws Exception {
        this.actual.sendToAll(rpcCommand, deliverOrder);
    }

    @Override
    public BackupResponse backupRemotely(Collection<XSiteBackup> backups, XSiteReplicateCommand rpcCommand) throws Exception {
        this.beforeBackupRemotely(rpcCommand);
        BackupResponse response = this.actual.backupRemotely(backups, rpcCommand);
        return this.afterBackupRemotely((ReplicableCommand)rpcCommand, response);
    }

    @Override
    public XSiteResponse backupRemotely(XSiteBackup backup, XSiteReplicateCommand rpcCommand) {
        this.beforeBackupRemotely(rpcCommand);
        XSiteResponse cs = this.actual.backupRemotely(backup, rpcCommand);
        cs.whenComplete((aVoid, throwable) -> this.afterBackupRemotely((ReplicableCommand)rpcCommand, (Throwable)throwable));
        return cs;
    }

    @Override
    public boolean isCoordinator() {
        return this.actual.isCoordinator();
    }

    @Override
    public Address getCoordinator() {
        return this.actual.getCoordinator();
    }

    @Override
    public Address getAddress() {
        return this.actual.getAddress();
    }

    @Override
    public List<Address> getPhysicalAddresses() {
        return this.actual.getPhysicalAddresses();
    }

    @Override
    public List<Address> getMembers() {
        return this.actual.getMembers();
    }

    @Override
    public List<Address> getMembersPhysicalAddresses() {
        return this.actual.getMembersPhysicalAddresses();
    }

    @Override
    public boolean isMulticastCapable() {
        return this.actual.isMulticastCapable();
    }

    @Override
    @Start
    public void start() {
        this.actual.start();
    }

    @Override
    @Stop
    public void stop() {
        this.actual.stop();
    }

    @Override
    public int getViewId() {
        return this.actual.getViewId();
    }

    @Override
    public CompletableFuture<Void> withView(int expectedViewId) {
        return this.actual.withView(expectedViewId);
    }

    @Override
    public void waitForView(int viewId) throws InterruptedException {
        this.actual.waitForView(viewId);
    }

    @Override
    public void checkTotalOrderSupported() {
        this.actual.checkTotalOrderSupported();
    }

    @Override
    public Log getLog() {
        return this.actual.getLog();
    }

    public Transport getDelegate() {
        return this.actual;
    }

    protected void beforeInvokeRemotely(ReplicableCommand command) {
    }

    protected Map<Address, Response> afterInvokeRemotely(ReplicableCommand command, Map<Address, Response> responseMap) {
        return responseMap;
    }

    protected void beforeBackupRemotely(XSiteReplicateCommand command) {
    }

    @Deprecated
    protected BackupResponse afterBackupRemotely(ReplicableCommand command, BackupResponse response) {
        return response;
    }

    protected void afterBackupRemotely(ReplicableCommand command, Throwable throwable) {
    }

    @Override
    public Set<String> getSitesView() {
        return this.actual.getSitesView();
    }

    @Override
    public <T> CompletionStage<T> invokeCommand(Address target, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.actual.invokeCommand(target, command, collector, deliverOrder, timeout, unit);
    }

    @Override
    public <T> CompletionStage<T> invokeCommand(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.actual.invokeCommand(targets, command, collector, deliverOrder, timeout, unit);
    }

    @Override
    public <T> CompletionStage<T> invokeCommandOnAll(ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.actual.invokeCommandOnAll(command, collector, deliverOrder, timeout, unit);
    }

    @Override
    public <T> CompletionStage<T> invokeCommandStaggered(Collection<Address> targets, ReplicableCommand command, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit unit) {
        return this.actual.invokeCommandStaggered(targets, command, collector, deliverOrder, timeout, unit);
    }

    @Override
    public <T> CompletionStage<T> invokeCommands(Collection<Address> targets, Function<Address, ReplicableCommand> commandGenerator, ResponseCollector<T> collector, DeliverOrder deliverOrder, long timeout, TimeUnit timeUnit) {
        return this.actual.invokeCommands(targets, commandGenerator, collector, deliverOrder, timeout, timeUnit);
    }
}

