/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.remoting.transport;

import java.util.concurrent.TimeUnit;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;

public class RetryOnFailureXSiteCommand {
    public static final RetryPolicy NO_RETRY = new MaxRetriesPolicy(0);
    private static final Log log = LogFactory.getLog(RetryOnFailureXSiteCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    private final XSiteBackup xSiteBackup;
    private final XSiteReplicateCommand command;
    private final RetryPolicy retryPolicy;

    private RetryOnFailureXSiteCommand(XSiteBackup backup, XSiteReplicateCommand command, RetryPolicy retryPolicy) {
        this.xSiteBackup = backup;
        this.command = command;
        this.retryPolicy = retryPolicy;
    }

    public void execute(RpcManager rpcManager, long waitTimeBetweenRetries, TimeUnit unit) throws Throwable {
        RetryOnFailureXSiteCommand.assertNotNull(rpcManager, "RpcManager");
        RetryOnFailureXSiteCommand.assertNotNull((Object)unit, "TimeUnit");
        RetryOnFailureXSiteCommand.assertGreaterThanZero(waitTimeBetweenRetries, "WaitTimeBetweenRetries");
        while (true) {
            try {
                XSiteResponse response = rpcManager.invokeXSite(this.xSiteBackup, this.command);
                response.toCompletableFuture().join();
                if (trace) {
                    log.trace("Successful Response received.");
                }
                return;
            }
            catch (Throwable throwable) {
                throwable = CompletableFutures.extractException(throwable);
                if (!this.retryPolicy.retry(throwable, rpcManager)) {
                    if (trace) {
                        log.tracef("Exception Response received. Exception is %s", throwable);
                    }
                    throw throwable;
                }
                unit.sleep(waitTimeBetweenRetries);
                continue;
            }
            break;
        }
    }

    public static RetryOnFailureXSiteCommand newInstance(XSiteBackup backup, XSiteReplicateCommand command, RetryPolicy retryPolicy) {
        RetryOnFailureXSiteCommand.assertNotNull(backup, "XSiteBackup");
        RetryOnFailureXSiteCommand.assertNotNull(command, "XSiteReplicateCommand");
        RetryOnFailureXSiteCommand.assertNotNull(retryPolicy, "RetryPolicy");
        return new RetryOnFailureXSiteCommand(backup, command, retryPolicy);
    }

    public String toString() {
        return "RetryOnLinkFailureXSiteCommand{backup=" + this.xSiteBackup + ", command=" + this.command + '}';
    }

    private static void assertNotNull(Object value, String field) {
        if (value == null) {
            throw new NullPointerException(field + " must be not null.");
        }
    }

    private static void assertGreaterThanZero(long value, String field) {
        if (value <= 0L) {
            throw new IllegalArgumentException(field + " must be greater that zero but instead it is " + value);
        }
    }

    public static class MaxRetriesPolicy
    implements RetryPolicy {
        private int maxRetries;

        public MaxRetriesPolicy(int maxRetries) {
            this.maxRetries = maxRetries;
        }

        @Override
        public boolean retry(Throwable throwable, RpcManager transport) {
            return this.maxRetries-- > 0;
        }
    }

    public static interface RetryPolicy {
        public boolean retry(Throwable var1, RpcManager var2);
    }
}

