/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.statetransfer;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.commands.TopologyAffectedCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.distribution.LocalizedCacheTopology;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.distribution.ch.impl.ReplicatedConsistentHash;
import org.infinispan.distribution.ch.impl.ScatteredConsistentHashFactory;
import org.infinispan.distribution.ch.impl.SyncConsistentHashFactory;
import org.infinispan.distribution.ch.impl.SyncReplicatedConsistentHashFactory;
import org.infinispan.distribution.ch.impl.TopologyAwareSyncConsistentHashFactory;
import org.infinispan.distribution.group.impl.PartitionerConsistentHash;
import org.infinispan.factories.annotations.ComponentName;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.globalstate.GlobalStateManager;
import org.infinispan.globalstate.ScopedPersistentState;
import org.infinispan.jmx.annotations.DataType;
import org.infinispan.jmx.annotations.MBean;
import org.infinispan.jmx.annotations.ManagedAttribute;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.partitionhandling.impl.PartitionHandlingManager;
import org.infinispan.persistence.manager.PreloadManager;
import org.infinispan.remoting.inboundhandler.DeliverOrder;
import org.infinispan.remoting.inboundhandler.PerCacheInboundInvocationHandler;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.statetransfer.StateConsumer;
import org.infinispan.statetransfer.StateProvider;
import org.infinispan.statetransfer.StateTransferManager;
import org.infinispan.topology.CacheJoinInfo;
import org.infinispan.topology.CacheTopology;
import org.infinispan.topology.CacheTopologyHandler;
import org.infinispan.topology.LocalTopologyManager;
import org.infinispan.util.concurrent.CompletionStages;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@MBean(objectName="StateTransferManager", description="Component that handles state transfer")
@Scope(value=Scopes.NAMED_CACHE)
public class StateTransferManagerImpl
implements StateTransferManager {
    private static final Log log = LogFactory.getLog(StateTransferManagerImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @ComponentName(value="cacheName")
    @Inject
    protected String cacheName;
    @Inject
    StateConsumer stateConsumer;
    @Inject
    StateProvider stateProvider;
    @Inject
    PartitionHandlingManager partitionHandlingManager;
    @Inject
    DistributionManager distributionManager;
    @Inject
    CacheNotifier cacheNotifier;
    @Inject
    Configuration configuration;
    @Inject
    GlobalConfiguration globalConfiguration;
    @Inject
    RpcManager rpcManager;
    @Inject
    LocalTopologyManager localTopologyManager;
    @Inject
    KeyPartitioner keyPartitioner;
    @Inject
    GlobalStateManager globalStateManager;
    @Inject
    PreloadManager preloadManager;
    @Inject
    PerCacheInboundInvocationHandler inboundInvocationHandler;
    private Optional<Integer> persistentStateChecksum;
    private final CountDownLatch initialStateTransferComplete = new CountDownLatch(1);

    @Override
    @Start(priority=60)
    public void start() throws Exception {
        if (trace) {
            log.tracef("Starting StateTransferManager of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
        this.persistentStateChecksum = this.globalStateManager != null ? this.globalStateManager.readScopedState(this.cacheName).map(ScopedPersistentState::getChecksum) : Optional.empty();
        float capacityFactor = this.globalConfiguration.isZeroCapacityNode() ? 0.0f : this.configuration.clustering().hash().capacityFactor();
        CacheJoinInfo joinInfo = new CacheJoinInfo(StateTransferManagerImpl.pickConsistentHashFactory(this.globalConfiguration, this.configuration), (Hash)MurmurHash3.getInstance(), this.configuration.clustering().hash().numSegments(), this.configuration.clustering().hash().numOwners(), this.configuration.clustering().stateTransfer().timeout(), this.configuration.transaction().transactionProtocol().isTotalOrder(), this.configuration.clustering().cacheMode(), capacityFactor, this.localTopologyManager.getPersistentUUID(), this.persistentStateChecksum);
        CacheTopology initialTopology = this.localTopologyManager.join(this.cacheName, joinInfo, new CacheTopologyHandler(){

            @Override
            public void updateConsistentHash(CacheTopology cacheTopology) {
                StateTransferManagerImpl.this.doTopologyUpdate(cacheTopology, false);
            }

            @Override
            public void rebalance(CacheTopology cacheTopology) {
                StateTransferManagerImpl.this.doTopologyUpdate(cacheTopology, true);
            }
        }, this.partitionHandlingManager);
        if (trace) {
            log.tracef("StateTransferManager of cache %s on node %s received initial topology %s", this.cacheName, this.rpcManager.getAddress(), initialTopology);
        }
    }

    public static ConsistentHashFactory pickConsistentHashFactory(GlobalConfiguration globalConfiguration, Configuration configuration) {
        CacheMode cacheMode;
        ConsistentHashFactory<ReplicatedConsistentHash> factory = configuration.clustering().hash().consistentHashFactory();
        if (factory == null && (cacheMode = configuration.clustering().cacheMode()).isClustered()) {
            if (cacheMode.isDistributed()) {
                factory = globalConfiguration.transport().hasTopologyInfo() ? new TopologyAwareSyncConsistentHashFactory() : new SyncConsistentHashFactory();
            } else if (cacheMode.isReplicated() || cacheMode.isInvalidation()) {
                factory = new SyncReplicatedConsistentHashFactory();
            } else if (cacheMode.isScattered()) {
                factory = new ScatteredConsistentHashFactory();
            } else {
                throw new CacheException("Unexpected cache mode: " + (Object)((Object)cacheMode));
            }
        }
        return factory;
    }

    private CacheTopology addPartitioner(CacheTopology cacheTopology) {
        ConsistentHash unionCH;
        ConsistentHash currentCH = cacheTopology.getCurrentCH();
        currentCH = new PartitionerConsistentHash(currentCH, this.keyPartitioner);
        ConsistentHash pendingCH = cacheTopology.getPendingCH();
        if (pendingCH != null) {
            pendingCH = new PartitionerConsistentHash(pendingCH, this.keyPartitioner);
        }
        if ((unionCH = cacheTopology.getUnionCH()) != null) {
            unionCH = new PartitionerConsistentHash(unionCH, this.keyPartitioner);
        }
        return new CacheTopology(cacheTopology.getTopologyId(), cacheTopology.getRebalanceId(), currentCH, pendingCH, unionCH, cacheTopology.getPhase(), cacheTopology.getActualMembers(), cacheTopology.getMembersPersistentUUIDs());
    }

    private void doTopologyUpdate(CacheTopology newCacheTopology, boolean isRebalance) {
        LocalizedCacheTopology oldCacheTopology = this.distributionManager.getCacheTopology();
        int newTopologyId = newCacheTopology.getTopologyId();
        if (oldCacheTopology != null && oldCacheTopology.getTopologyId() > newTopologyId) {
            throw new IllegalStateException("Old topology is higher: old=" + oldCacheTopology + ", new=" + newCacheTopology);
        }
        if (trace) {
            log.tracef("Installing new cache topology %s on cache %s", newCacheTopology, this.cacheName);
        }
        if (!(!newCacheTopology.getMembers().contains(this.rpcManager.getAddress()) || this.distributionManager.getCacheTopology().isConnected() && this.distributionManager.getCacheTopology().getMembersSet().contains(this.rpcManager.getAddress()))) {
            if (trace) {
                log.tracef("This is the first topology %d in which the local node is a member", newTopologyId);
            }
            this.inboundInvocationHandler.setFirstTopologyAsMember(newTopologyId);
        }
        newCacheTopology = this.addPartitioner(newCacheTopology);
        int newRebalanceId = newCacheTopology.getRebalanceId();
        CacheTopology.Phase phase = newCacheTopology.getPhase();
        CompletionStages.join(this.cacheNotifier.notifyTopologyChanged(oldCacheTopology, newCacheTopology, newTopologyId, true));
        CompletableFuture<Void> consumerFuture = this.stateConsumer.onTopologyUpdate(newCacheTopology, isRebalance);
        CompletableFuture<Void> providerFuture = this.stateProvider.onTopologyUpdate(newCacheTopology, isRebalance);
        CompletableFuture.allOf(consumerFuture, providerFuture).thenRun(() -> {
            switch (phase) {
                case TRANSITORY: 
                case READ_OLD_WRITE_ALL: 
                case READ_ALL_WRITE_ALL: 
                case READ_NEW_WRITE_ALL: {
                    this.localTopologyManager.confirmRebalancePhase(this.cacheName, newTopologyId, newRebalanceId, null);
                }
            }
        });
        CompletionStages.join(this.cacheNotifier.notifyTopologyChanged(oldCacheTopology, newCacheTopology, newTopologyId, false));
        if (this.initialStateTransferComplete.getCount() > 0L) {
            boolean isJoined;
            assert (this.distributionManager.getCacheTopology().getTopologyId() == newCacheTopology.getTopologyId());
            boolean bl = isJoined = phase == CacheTopology.Phase.NO_REBALANCE && newCacheTopology.getReadConsistentHash().getMembers().contains(this.rpcManager.getAddress());
            if (isJoined) {
                this.initialStateTransferComplete.countDown();
                log.tracef("Initial state transfer complete for cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
            }
        }
        this.partitionHandlingManager.onTopologyUpdate(newCacheTopology);
    }

    @Override
    public void waitForInitialStateTransferToComplete() {
        if (this.configuration.clustering().stateTransfer().awaitInitialTransfer()) {
            try {
                boolean success;
                if (!this.localTopologyManager.isCacheRebalancingEnabled(this.cacheName)) {
                    this.initialStateTransferComplete.countDown();
                }
                if (trace) {
                    log.tracef("Waiting for initial state transfer to finish for cache %s on %s", this.cacheName, this.rpcManager.getAddress());
                }
                if (!(success = this.initialStateTransferComplete.await(this.configuration.clustering().stateTransfer().timeout(), TimeUnit.MILLISECONDS))) {
                    throw new CacheException(String.format("Initial state transfer timed out for cache %s on %s", this.cacheName, this.rpcManager.getAddress()));
                }
            }
            catch (CacheException e) {
                throw e;
            }
            catch (Exception e) {
                throw new CacheException((Throwable)e);
            }
        }
    }

    @Override
    @Stop(priority=0)
    public void stop() {
        if (trace) {
            log.tracef("Shutting down StateTransferManager of cache %s on node %s", this.cacheName, this.rpcManager.getAddress());
        }
        this.initialStateTransferComplete.countDown();
        this.localTopologyManager.leave(this.cacheName, this.configuration.clustering().remoteTimeout());
    }

    @Override
    @ManagedAttribute(description="If true, the node has successfully joined the grid and is considered to hold state.  If false, the join process is still in progress.", displayName="Is join completed?", dataType=DataType.TRAIT)
    public boolean isJoinComplete() {
        return this.distributionManager.getCacheTopology() != null;
    }

    @Override
    @ManagedAttribute(description="Retrieves the rebalancing status for this cache. Possible values are PENDING, SUSPENDED, IN_PROGRESS, BALANCED", displayName="Rebalancing progress", dataType=DataType.TRAIT)
    public String getRebalancingStatus() throws Exception {
        return this.localTopologyManager.getRebalancingStatus(this.cacheName).toString();
    }

    @Override
    @ManagedAttribute(description="Checks whether there is a pending inbound state transfer on this cluster member.", displayName="Is state transfer in progress?", dataType=DataType.TRAIT)
    public boolean isStateTransferInProgress() {
        return this.stateConsumer.isStateTransferInProgress();
    }

    @Override
    public Map<Address, Response> forwardCommandIfNeeded(TopologyAffectedCommand command, Set<Object> affectedKeys, Address origin) {
        LocalizedCacheTopology cacheTopology = this.distributionManager.getCacheTopology();
        if (cacheTopology == null) {
            if (trace) {
                log.tracef("Not fowarding command %s because topology is null.", command);
            }
            return Collections.emptyMap();
        }
        int cmdTopologyId = command.getTopologyId();
        int localTopologyId = cacheTopology.getTopologyId();
        if (trace) {
            log.tracef("CommandTopologyId=%s, localTopologyId=%s", cmdTopologyId, localTopologyId);
        }
        if (cmdTopologyId < localTopologyId) {
            HashSet<Address> newTargets = new HashSet<Address>(cacheTopology.getWriteOwners(affectedKeys));
            newTargets.remove(this.rpcManager.getAddress());
            newTargets.remove(origin);
            if (!newTargets.isEmpty()) {
                command.setTopologyId(localTopologyId);
                if (trace) {
                    log.tracef("Forwarding command %s to new targets %s", command, newTargets);
                }
                RpcOptions rpcOptions = this.rpcManager.getDefaultRpcOptions(false, DeliverOrder.NONE);
                return this.rpcManager.invokeRemotely(newTargets, command, rpcOptions);
            }
        }
        return Collections.emptyMap();
    }

    @Override
    public StateConsumer getStateConsumer() {
        return this.stateConsumer;
    }

    @Override
    public StateProvider getStateProvider() {
        return this.stateProvider;
    }

    public String toString() {
        return "StateTransferManagerImpl [" + this.cacheName + "@" + this.rpcManager.getAddress() + "]";
    }
}

