/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl;

import io.reactivex.Flowable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.infinispan.commands.functional.functions.InjectableComponent;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.util.function.SerializableFunction;
import org.reactivestreams.Publisher;

public final class CacheStreamIntermediateReducer<R>
implements SerializableFunction<Publisher<Object>, CompletionStage<R>>,
InjectableComponent {
    private final Queue<IntermediateOperation> intOps;
    private final Function<? super Publisher<Object>, ? extends CompletionStage<R>> transformer;

    CacheStreamIntermediateReducer(Queue<IntermediateOperation> intOps, Function<? super Publisher<Object>, ? extends CompletionStage<R>> transformer) {
        this.intOps = intOps;
        this.transformer = transformer;
    }

    @Override
    public CompletionStage<R> apply(Publisher<Object> objectPublisher) {
        Flowable innerPublisher = Flowable.fromPublisher(objectPublisher);
        for (IntermediateOperation intOp : this.intOps) {
            innerPublisher = intOp.mapFlowable(innerPublisher);
        }
        return this.transformer.apply((Publisher<Object>)innerPublisher);
    }

    @Override
    public void inject(ComponentRegistry registry) {
        for (IntermediateOperation intOp : this.intOps) {
            intOp.handleInjection(registry);
        }
    }

    public static final class ReducerExternalizer
    implements AdvancedExternalizer<CacheStreamIntermediateReducer> {
        public void writeObject(ObjectOutput output, CacheStreamIntermediateReducer object) throws IOException {
            output.writeObject(object.intOps);
            output.writeObject(object.transformer);
        }

        public CacheStreamIntermediateReducer readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new CacheStreamIntermediateReducer((Queue)input.readObject(), (Function)input.readObject());
        }

        public Set<Class<? extends CacheStreamIntermediateReducer>> getTypeClasses() {
            return Collections.singleton(CacheStreamIntermediateReducer.class);
        }

        public Integer getId() {
            return 143;
        }
    }
}

