/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.util.concurrent;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.infinispan.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.concurrent.CompletableFutures;
import org.infinispan.util.concurrent.CompletionStages;

public class ActionSequencer {
    private final Map<Object, SequenceEntry<?>> sequencer = new ConcurrentHashMap();
    private final LongAdder pendingActions = new LongAdder();
    private final ExecutorService executor;

    public ActionSequencer(ExecutorService executor) {
        this.executor = executor;
    }

    private static <T> CompletionStage<T> safeNonBlockingCall(Callable<? extends CompletionStage<T>> action) {
        try {
            return action.call();
        }
        catch (Exception e) {
            return CompletableFutures.completedExceptionFuture(e);
        }
    }

    public <T> CompletionStage<T> orderOnKeys(Collection<?> keys, Callable<? extends CompletionStage<T>> action) {
        this.checkAction(action);
        Object[] dKeys = this.checkKeys(keys);
        if (dKeys.length == 0) {
            return ActionSequencer.safeNonBlockingCall(action);
        }
        SequenceEntry entry = dKeys.length == 1 ? new SingleKeyNonBlockingSequenceEntry(action, this.executor, dKeys[0]) : new MultiKeyNonBlockingSequenceEntry(action, this.executor, dKeys);
        this.registerAction(entry);
        return entry;
    }

    public <T> CompletionStage<T> orderOnKey(Object key, Callable<? extends CompletionStage<T>> action) {
        this.checkAction(action);
        SingleKeyNonBlockingSequenceEntry entry = new SingleKeyNonBlockingSequenceEntry(action, this.executor, this.checkKey(key));
        this.registerAction(entry);
        return entry;
    }

    public long getPendingActions() {
        return this.pendingActions.longValue();
    }

    public int getMapSize() {
        return this.sequencer.size();
    }

    private <T> void registerAction(SequenceEntry<T> entry) {
        this.pendingActions.increment();
        entry.register();
    }

    private void checkAction(Callable<?> action) {
        Objects.requireNonNull(action, "Action cannot be null.");
    }

    private Object[] checkKeys(Collection<?> keys) {
        return Objects.requireNonNull(keys, "Keys cannot be null.").stream().filter(Objects::nonNull).distinct().toArray();
    }

    private Object checkKey(Object key) {
        return Objects.requireNonNull(key, "Key cannot be null.");
    }

    private void remove(Object key, SequenceEntry<?> entry) {
        this.sequencer.remove(key, entry);
        this.pendingActions.decrement();
    }

    private void remove(Object[] keys, SequenceEntry<?> entry) {
        for (Object key : keys) {
            this.sequencer.remove(key, entry);
        }
        this.pendingActions.decrement();
    }

    private class MultiKeyNonBlockingSequenceEntry<T>
    extends SequenceEntry<T> {
        private final Object[] keys;

        MultiKeyNonBlockingSequenceEntry(Callable<? extends CompletionStage<T>> action, ExecutorService executor, Object[] keys) {
            super(action, executor);
            this.keys = keys;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CompletionStage<?> putInMap() {
            AggregateCompletionStage<Void> previousCF = CompletionStages.aggregateCompletionStage();
            ActionSequencer actionSequencer = ActionSequencer.this;
            synchronized (actionSequencer) {
                BiFunction<Object, SequenceEntry, SequenceEntry> mapping = (key, previousEntry) -> this.waitFromPrevious((SequenceEntry<?>)previousEntry, previousCF);
                for (Object key2 : this.keys) {
                    ActionSequencer.this.sequencer.compute(key2, mapping);
                }
            }
            return previousCF.freeze();
        }

        @Override
        void removeFromMap() {
            ActionSequencer.this.remove(this.keys, this);
        }

        SequenceEntry<?> waitFromPrevious(SequenceEntry<?> previousEntry, AggregateCompletionStage<?> previousCF) {
            if (previousEntry != null) {
                previousCF.dependsOn(previousEntry);
            }
            return this;
        }
    }

    private class SingleKeyNonBlockingSequenceEntry<T>
    extends SequenceEntry<T> {
        private final Object key;

        SingleKeyNonBlockingSequenceEntry(Callable<? extends CompletionStage<T>> action, ExecutorService executor, Object key) {
            super(action, executor);
            this.key = key;
        }

        @Override
        public CompletionStage<?> putInMap() {
            return ActionSequencer.this.sequencer.put(this.key, this);
        }

        @Override
        public void removeFromMap() {
            ActionSequencer.this.remove(this.key, this);
        }
    }

    private static abstract class SequenceEntry<T>
    extends CompletableFuture<T>
    implements BiFunction<Object, Throwable, Void>,
    BiConsumer<T, Throwable> {
        final Callable<? extends CompletionStage<T>> action;
        final ExecutorService executor;

        SequenceEntry(Callable<? extends CompletionStage<T>> action, ExecutorService executor) {
            this.action = action;
            this.executor = executor;
        }

        public void register() {
            CompletionStage<?> previousStage = this.putInMap();
            if (previousStage != null) {
                previousStage.handleAsync(this, this.executor);
            } else {
                this.apply(null, null);
            }
        }

        @Override
        public void accept(T o, Throwable throwable) {
            this.removeFromMap();
            if (throwable == null) {
                this.complete(o);
            } else {
                this.completeExceptionally(throwable);
            }
        }

        @Override
        public final Void apply(Object o, Throwable t) {
            CompletionStage cf = ActionSequencer.safeNonBlockingCall(this.action);
            cf.whenComplete(this);
            return null;
        }

        abstract CompletionStage<?> putInMap();

        abstract void removeFromMap();
    }
}

