/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.xsite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.Transaction;
import net.jcip.annotations.GuardedBy;
import org.infinispan.Cache;
import org.infinispan.commands.AbstractVisitor;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.functional.ReadWriteKeyCommand;
import org.infinispan.commands.functional.ReadWriteKeyValueCommand;
import org.infinispan.commands.functional.ReadWriteManyCommand;
import org.infinispan.commands.functional.ReadWriteManyEntriesCommand;
import org.infinispan.commands.functional.WriteOnlyKeyCommand;
import org.infinispan.commands.functional.WriteOnlyKeyValueCommand;
import org.infinispan.commands.functional.WriteOnlyManyCommand;
import org.infinispan.commands.functional.WriteOnlyManyEntriesCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.AbstractDataWriteCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.ComputeCommand;
import org.infinispan.commands.write.ComputeIfAbsentCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.FlagBitSets;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.ch.KeyPartitioner;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.factories.scopes.Scope;
import org.infinispan.factories.scopes.Scopes;
import org.infinispan.interceptors.InvocationStage;
import org.infinispan.interceptors.SyncInvocationStage;
import org.infinispan.interceptors.impl.SimpleAsyncInvocationStage;
import org.infinispan.remoting.CacheUnreachableException;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.remoting.transport.XSiteResponse;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.transaction.impl.AbstractCacheTransaction;
import org.infinispan.transaction.impl.LocalTransaction;
import org.infinispan.transaction.impl.TransactionTable;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.infinispan.util.logging.events.EventLogCategory;
import org.infinispan.util.logging.events.EventLogManager;
import org.infinispan.util.logging.events.EventLogger;
import org.infinispan.util.logging.events.Messages;
import org.infinispan.xsite.BackupFailureException;
import org.infinispan.xsite.BackupSender;
import org.infinispan.xsite.CustomFailurePolicy;
import org.infinispan.xsite.OfflineStatus;
import org.infinispan.xsite.SingleXSiteRpcCommand;
import org.infinispan.xsite.XSiteBackup;
import org.infinispan.xsite.XSiteReplicateCommand;
import org.infinispan.xsite.notification.SiteStatusListener;
import org.jgroups.UnreachableException;

@Scope(value=Scopes.NAMED_CACHE)
public class BackupSenderImpl
implements BackupSender {
    private static Log log = LogFactory.getLog(BackupSenderImpl.class);
    private static final boolean trace = log.isTraceEnabled();
    @Inject
    ComponentRef<Cache> cache;
    @Inject
    RpcManager rpcManager;
    @Inject
    Transport transport;
    @Inject
    Configuration config;
    @Inject
    TransactionTable txTable;
    @Inject
    TimeService timeService;
    @Inject
    CommandsFactory commandsFactory;
    @Inject
    EventLogManager eventLogManager;
    @Inject
    GlobalConfiguration globalConfig;
    @Inject
    KeyPartitioner keyPartitioner;
    private final Map<String, CustomFailurePolicy> siteFailurePolicy = new HashMap<String, CustomFailurePolicy>();
    private final ConcurrentMap<String, OfflineStatus> offlineStatus = new ConcurrentHashMap<String, OfflineStatus>();
    private final String localSiteName;
    private String cacheName;

    private static boolean isCommunicationError(Throwable throwable) {
        Throwable error = throwable;
        if (throwable instanceof ExecutionException) {
            error = throwable.getCause();
        }
        return error instanceof TimeoutException || error instanceof org.infinispan.util.concurrent.TimeoutException || error instanceof UnreachableException || error instanceof CacheUnreachableException || error instanceof SuspectException;
    }

    public BackupSenderImpl(String localSiteName) {
        this.localSiteName = localSiteName;
    }

    @Start
    public void start() {
        this.cacheName = this.cache.wired().getName();
        for (BackupConfiguration bc : this.config.sites().enabledBackups()) {
            final String siteName = bc.site();
            if (bc.backupFailurePolicy() == BackupFailurePolicy.CUSTOM) {
                String backupPolicy = bc.failurePolicyClass();
                if (backupPolicy == null) {
                    throw new IllegalStateException("Backup policy class missing for custom failure policy!");
                }
                CustomFailurePolicy instance = (CustomFailurePolicy)Util.getInstance((String)backupPolicy, (ClassLoader)this.globalConfig.classLoader());
                instance.init(this.cache.wired());
                this.siteFailurePolicy.put(bc.site(), instance);
            }
            OfflineStatus offline = new OfflineStatus(bc.takeOffline(), this.timeService, new SiteStatusListener(){

                @Override
                public void siteOnline() {
                    BackupSenderImpl.this.siteOnline(siteName);
                }

                @Override
                public void siteOffline() {
                    BackupSenderImpl.this.siteOffline(siteName);
                }
            });
            this.offlineStatus.put(siteName, offline);
        }
    }

    @Override
    public InvocationStage backupPrepare(PrepareCommand command, AbstractCacheTransaction cacheTransaction, Transaction transaction) {
        List<WriteCommand> modifications = this.filterModifications(command.getModifications(), cacheTransaction.getLookedUpEntries());
        if (modifications.isEmpty()) {
            return SyncInvocationStage.completedNullStage();
        }
        PrepareCommand prepare = this.commandsFactory.buildPrepareCommand(command.getGlobalTransaction(), modifications, command.isOnePhaseCommit());
        BackupFilter filter = !prepare.isOnePhaseCommit() ? BackupFilter.KEEP_2PC_ONLY : BackupFilter.KEEP_ALL;
        List<XSiteBackup> backups = this.calculateBackupInfo(filter);
        return this.backupCommand(prepare, command, backups, transaction);
    }

    @Override
    public InvocationStage backupWrite(WriteCommand command, VisitableCommand originalCommand) {
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_ALL);
        return this.backupCommand(command, originalCommand, xSiteBackups, null);
    }

    @Override
    public InvocationStage backupCommit(CommitCommand command, Transaction transaction) {
        ResponseAggregator aggregator = new ResponseAggregator(command, transaction);
        this.sendTo1PCBackups(command, aggregator);
        this.sendTo2PCBackups(command, aggregator);
        return aggregator.freeze();
    }

    @Override
    public InvocationStage backupRollback(RollbackCommand command, Transaction transaction) {
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_2PC_ONLY);
        return this.backupCommand(command, command, xSiteBackups, transaction);
    }

    @Override
    public BackupSender.BringSiteOnlineResponse bringSiteOnline(String siteName) {
        if (!this.config.sites().hasInUseBackup(siteName)) {
            log.tryingToBringOnlineNonexistentSite(siteName);
            return BackupSender.BringSiteOnlineResponse.NO_SUCH_SITE;
        }
        OfflineStatus offline = (OfflineStatus)this.offlineStatus.get(siteName);
        boolean broughtOnline = offline.bringOnline();
        return broughtOnline ? BackupSender.BringSiteOnlineResponse.BROUGHT_ONLINE : BackupSender.BringSiteOnlineResponse.ALREADY_ONLINE;
    }

    @Override
    public BackupSender.TakeSiteOfflineResponse takeSiteOffline(String siteName) {
        if (!this.config.sites().hasInUseBackup(siteName)) {
            return BackupSender.TakeSiteOfflineResponse.NO_SUCH_SITE;
        }
        OfflineStatus offline = (OfflineStatus)this.offlineStatus.get(siteName);
        return offline.forceOffline() ? BackupSender.TakeSiteOfflineResponse.TAKEN_OFFLINE : BackupSender.TakeSiteOfflineResponse.ALREADY_OFFLINE;
    }

    private void updateOfflineSites(String siteName, long sendTimeMillis, Throwable throwable) {
        OfflineStatus status = (OfflineStatus)this.offlineStatus.get(siteName);
        if (status != null && status.isEnabled()) {
            if (BackupSenderImpl.isCommunicationError(throwable)) {
                status.updateOnCommunicationFailure(sendTimeMillis);
            } else if (!status.isOffline()) {
                status.reset();
            }
        }
    }

    private InvocationStage backupCommand(VisitableCommand command, VisitableCommand originalCommand, List<XSiteBackup> xSiteBackups, Transaction transaction) {
        SingleXSiteRpcCommand xsiteCommand = this.commandsFactory.buildSingleXSiteRpcCommand(command);
        ResponseAggregator aggregator = new ResponseAggregator(originalCommand, transaction);
        this.sendTo(xsiteCommand, xSiteBackups, aggregator);
        return aggregator.freeze();
    }

    private void sendTo(XSiteReplicateCommand command, Collection<XSiteBackup> xSiteBackups, ResponseAggregator aggregator) {
        if (this.rpcManager == null) {
            for (XSiteBackup backup : xSiteBackups) {
                XSiteResponse cs = this.transport.backupRemotely(backup, command);
                aggregator.addResponse(backup, cs);
            }
        } else {
            for (XSiteBackup backup : xSiteBackups) {
                XSiteResponse cs = this.rpcManager.invokeXSite(backup, command);
                aggregator.addResponse(backup, cs);
            }
        }
    }

    private long sendTimeMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.timeService.time());
    }

    private void sendTo1PCBackups(CommitCommand command, ResponseAggregator aggregator) {
        LocalTransaction localTx = this.txTable.getLocalTransaction(command.getGlobalTransaction());
        List<WriteCommand> modifications = this.filterModifications(localTx.getModifications(), localTx.getLookedUpEntries());
        if (modifications.isEmpty()) {
            return;
        }
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_1PC_ONLY);
        if (xSiteBackups.isEmpty()) {
            return;
        }
        PrepareCommand prepare = this.commandsFactory.buildPrepareCommand(command.getGlobalTransaction(), modifications, true);
        SingleXSiteRpcCommand xsiteCommand = this.commandsFactory.buildSingleXSiteRpcCommand(prepare);
        this.sendTo(xsiteCommand, xSiteBackups, aggregator);
    }

    private void sendTo2PCBackups(CommitCommand command, ResponseAggregator aggregator) {
        List<XSiteBackup> xSiteBackups = this.calculateBackupInfo(BackupFilter.KEEP_2PC_ONLY);
        if (xSiteBackups.isEmpty()) {
            return;
        }
        SingleXSiteRpcCommand xsiteCommand = this.commandsFactory.buildSingleXSiteRpcCommand(command);
        this.sendTo(xsiteCommand, xSiteBackups, aggregator);
    }

    private List<XSiteBackup> calculateBackupInfo(BackupFilter backupFilter) {
        ArrayList<XSiteBackup> backupInfo = new ArrayList<XSiteBackup>(2);
        SitesConfiguration sites = this.config.sites();
        for (BackupConfiguration bc : sites.enabledBackups()) {
            boolean isSync;
            if (bc.site().equals(this.localSiteName)) {
                log.cacheBackupsDataToSameSite(this.localSiteName);
                continue;
            }
            boolean bl = isSync = bc.strategy() == BackupConfiguration.BackupStrategy.SYNC;
            if (backupFilter == BackupFilter.KEEP_1PC_ONLY && isSync && bc.isTwoPhaseCommit() || backupFilter == BackupFilter.KEEP_2PC_ONLY && (!isSync || !bc.isTwoPhaseCommit())) continue;
            if (this.isOffline(bc.site())) {
                log.tracef("The site '%s' is offline, not backing up information to it", bc.site());
                continue;
            }
            XSiteBackup bi = new XSiteBackup(bc.site(), isSync, bc.replicationTimeout());
            backupInfo.add(bi);
        }
        return backupInfo;
    }

    private boolean isOffline(String site) {
        OfflineStatus offline = (OfflineStatus)this.offlineStatus.get(site);
        return offline != null && offline.isOffline();
    }

    private List<WriteCommand> filterModifications(WriteCommand[] modifications, Map<Object, CacheEntry> lookedUpEntries) {
        if (modifications == null || modifications.length == 0) {
            return Collections.emptyList();
        }
        return this.filterModifications(Arrays.asList(modifications), lookedUpEntries);
    }

    private List<WriteCommand> filterModifications(List<WriteCommand> modifications, Map<Object, CacheEntry> lookedUpEntries) {
        if (modifications == null || modifications.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<WriteCommand> filtered = new ArrayList<WriteCommand>(modifications.size());
        HashSet filteredKeys = new HashSet(modifications.size());
        ListIterator<WriteCommand> it = modifications.listIterator(modifications.size());
        while (it.hasPrevious()) {
            WriteCommand writeCommand = it.previous();
            if (!writeCommand.isSuccessful() || writeCommand.hasAnyFlag(FlagBitSets.SKIP_XSITE_BACKUP)) continue;
            for (Object key : writeCommand.getAffectedKeys()) {
                AbstractDataWriteCommand replicatedCommand;
                if (filteredKeys.contains(key)) continue;
                CacheEntry entry = lookedUpEntries.get(key);
                if (entry == null) {
                    throw new IllegalStateException();
                }
                if (entry.isRemoved()) {
                    replicatedCommand = this.commandsFactory.buildRemoveCommand(key, null, this.keyPartitioner.getSegment(key), writeCommand.getFlagsBitSet());
                } else {
                    if (!entry.isChanged()) continue;
                    replicatedCommand = this.commandsFactory.buildPutKeyValueCommand(key, entry.getValue(), this.keyPartitioner.getSegment(key), entry.getMetadata(), writeCommand.getFlagsBitSet());
                }
                filtered.add(replicatedCommand);
                filteredKeys.add(key);
            }
        }
        return filtered;
    }

    private void siteOnline(String siteName) {
        this.getEventLogger().info(EventLogCategory.CLUSTER, Messages.MESSAGES.siteOnline(siteName));
    }

    private void siteOffline(String siteName) {
        this.getEventLogger().info(EventLogCategory.CLUSTER, Messages.MESSAGES.siteOffline(siteName));
    }

    private EventLogger getEventLogger() {
        return this.eventLogManager.getEventLogger().context(this.cacheName).scope(this.rpcManager.getAddress());
    }

    @Override
    public OfflineStatus getOfflineStatus(String site) {
        return (OfflineStatus)this.offlineStatus.get(site);
    }

    @Override
    public Map<String, Boolean> status() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(this.offlineStatus.size());
        for (Map.Entry os : this.offlineStatus.entrySet()) {
            result.put((String)os.getKey(), !((OfflineStatus)os.getValue()).isOffline());
        }
        return result;
    }

    private static final class CustomBackupPolicyInvoker
    extends AbstractVisitor {
        private final String site;
        private final CustomFailurePolicy<Object, Object> failurePolicy;
        private final Transaction tx;

        public CustomBackupPolicyInvoker(String site, CustomFailurePolicy failurePolicy, Transaction tx) {
            this.site = site;
            this.failurePolicy = failurePolicy;
            this.tx = tx;
        }

        @Override
        public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
            this.failurePolicy.handlePutFailure(this.site, command.getKey(), command.getValue(), command.isPutIfAbsent());
            return null;
        }

        @Override
        public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
            this.failurePolicy.handleRemoveFailure(this.site, command.getKey(), command.getValue());
            return null;
        }

        @Override
        public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
            this.failurePolicy.handleReplaceFailure(this.site, command.getKey(), command.getOldValue(), command.getNewValue());
            return null;
        }

        @Override
        public Object visitComputeCommand(InvocationContext ctx, ComputeCommand command) throws Throwable {
            this.failurePolicy.handleComputeFailure(this.site, command.getKey(), command.getRemappingBiFunction(), command.isComputeIfPresent());
            return null;
        }

        @Override
        public Object visitComputeIfAbsentCommand(InvocationContext ctx, ComputeIfAbsentCommand command) throws Throwable {
            this.failurePolicy.handleComputeIfAbsentFailure(this.site, command.getKey(), command.getMappingFunction());
            return null;
        }

        @Override
        public Object visitWriteOnlyKeyCommand(InvocationContext ctx, WriteOnlyKeyCommand command) throws Throwable {
            this.failurePolicy.handleWriteOnlyKeyFailure(this.site, command.getKey());
            return null;
        }

        @Override
        public Object visitReadWriteKeyValueCommand(InvocationContext ctx, ReadWriteKeyValueCommand command) throws Throwable {
            this.failurePolicy.handleReadWriteKeyValueFailure(this.site, command.getKey());
            return null;
        }

        @Override
        public Object visitReadWriteKeyCommand(InvocationContext ctx, ReadWriteKeyCommand command) throws Throwable {
            this.failurePolicy.handleReadWriteKeyFailure(this.site, command.getKey());
            return null;
        }

        @Override
        public Object visitWriteOnlyManyEntriesCommand(InvocationContext ctx, WriteOnlyManyEntriesCommand command) throws Throwable {
            this.failurePolicy.handleWriteOnlyManyEntriesFailure(this.site, command.getArguments());
            return null;
        }

        @Override
        public Object visitWriteOnlyKeyValueCommand(InvocationContext ctx, WriteOnlyKeyValueCommand command) throws Throwable {
            this.failurePolicy.handleWriteOnlyKeyValueFailure(this.site, command.getKey());
            return null;
        }

        @Override
        public Object visitWriteOnlyManyCommand(InvocationContext ctx, WriteOnlyManyCommand command) throws Throwable {
            this.failurePolicy.handleWriteOnlyManyFailure(this.site, command.getAffectedKeys());
            return null;
        }

        @Override
        public Object visitReadWriteManyCommand(InvocationContext ctx, ReadWriteManyCommand command) throws Throwable {
            this.failurePolicy.handleReadWriteManyFailure(this.site, command.getAffectedKeys());
            return null;
        }

        @Override
        public Object visitReadWriteManyEntriesCommand(InvocationContext ctx, ReadWriteManyEntriesCommand command) throws Throwable {
            this.failurePolicy.handleReadWriteManyEntriesFailure(this.site, command.getArguments());
            return null;
        }

        @Override
        public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
            this.failurePolicy.handleClearFailure(this.site);
            return null;
        }

        @Override
        public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
            this.failurePolicy.handlePutAllFailure(this.site, command.getMap());
            return null;
        }

        @Override
        public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
            this.failurePolicy.handlePrepareFailure(this.site, this.tx);
            return null;
        }

        @Override
        public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
            this.failurePolicy.handleRollbackFailure(this.site, this.tx);
            return null;
        }

        @Override
        public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
            this.failurePolicy.handleCommitFailure(this.site, this.tx);
            return null;
        }

        @Override
        protected Object handleDefault(InvocationContext ctx, VisitableCommand command) throws Throwable {
            super.handleDefault(ctx, command);
            throw new IllegalStateException("Unknown command: " + command);
        }
    }

    private class ResponseAggregator
    extends CompletableFuture<Void>
    implements XSiteResponse.XSiteResponseCompleted {
        private final VisitableCommand command;
        private final Transaction transaction;
        private final AtomicInteger counter;
        @GuardedBy(value="this")
        private BackupFailureException exception;
        private volatile boolean frozen;

        private ResponseAggregator(VisitableCommand command, Transaction transaction) {
            this.command = command;
            this.transaction = transaction;
            this.counter = new AtomicInteger();
        }

        @Override
        public void onCompleted(XSiteBackup backup, long sendTimeNanos, long durationNanos, Throwable throwable) {
            if (trace) {
                log.tracef("Backup response from site %s completed for command %s. throwable=%s", this.command, backup, throwable);
            }
            BackupSenderImpl.this.updateOfflineSites(backup.getSiteName(), TimeUnit.NANOSECONDS.toMillis(sendTimeNanos), throwable);
            if (backup.isSync()) {
                if (throwable != null) {
                    this.handleException(backup.getSiteName(), throwable);
                }
                if (this.counter.decrementAndGet() == 0 && this.frozen) {
                    this.onRequestCompleted();
                }
            }
        }

        void addResponse(XSiteBackup backup, XSiteResponse response) {
            assert (!this.frozen);
            response.whenCompleted(this);
            if (backup.isSync()) {
                this.counter.incrementAndGet();
            }
        }

        InvocationStage freeze() {
            this.frozen = true;
            if (this.counter.get() == 0) {
                this.onRequestCompleted();
            }
            return new SimpleAsyncInvocationStage(this);
        }

        void handleException(String siteName, Throwable throwable) {
            switch (BackupSenderImpl.this.config.sites().getFailurePolicy(siteName)) {
                case FAIL: {
                    this.addException(siteName, throwable);
                    break;
                }
                case CUSTOM: {
                    CustomFailurePolicy failurePolicy = (CustomFailurePolicy)BackupSenderImpl.this.siteFailurePolicy.get(siteName);
                    try {
                        this.command.acceptVisitor(null, new CustomBackupPolicyInvoker(siteName, failurePolicy, this.transaction));
                    }
                    catch (Throwable t) {
                        this.addException(siteName, t);
                    }
                    break;
                }
                case WARN: {
                    log.warnXsiteBackupFailed(BackupSenderImpl.this.cacheName, siteName, throwable);
                }
            }
        }

        synchronized void addException(String siteName, Throwable throwable) {
            if (this.exception == null) {
                this.exception = new BackupFailureException();
            }
            this.exception.addFailure(siteName, throwable);
        }

        private synchronized void onRequestCompleted() {
            if (this.exception != null) {
                this.completeExceptionally((Throwable)((Object)this.exception));
            } else {
                this.complete(null);
            }
        }
    }

    private static enum BackupFilter {
        KEEP_1PC_ONLY,
        KEEP_2PC_ONLY,
        KEEP_ALL;

    }
}

