/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.kafka;

import io.apicurio.registry.utils.kafka.ProducerActions;
import java.time.Duration;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.errors.AuthorizationException;
import org.apache.kafka.common.errors.OutOfOrderSequenceException;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.serialization.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncProducer<K, V>
implements ProducerActions<K, V> {
    private static final Logger log = LoggerFactory.getLogger(AsyncProducer.class);
    private final Properties producerProps;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valSerializer;
    private KafkaProducer<K, V> producer;
    private boolean closed;

    public AsyncProducer(Properties producerProps, Serializer<K> keySerializer, Serializer<V> valSerializer) {
        this.producerProps = Objects.requireNonNull(producerProps, "producerProps");
        this.keySerializer = Objects.requireNonNull(keySerializer, "keySerializer");
        this.valSerializer = Objects.requireNonNull(valSerializer, "valSerializer");
    }

    @Override
    public CompletableFuture<RecordMetadata> apply(ProducerRecord<K, V> record) {
        CFC result = null;
        try {
            KafkaProducer<K, V> producer = this.getProducer();
            result = new CFC(producer);
            producer.send(record, (Callback)result);
        }
        catch (Exception e) {
            if (result != null) {
                ((CFC)result).onCompletion(null, e);
            }
            result = new CompletableFuture();
            result.completeExceptionally(e);
        }
        return result;
    }

    @Override
    public void close() {
        this.closeProducer(null, false);
    }

    private synchronized KafkaProducer<K, V> getProducer() {
        if (this.producer == null) {
            if (this.closed) {
                throw new IllegalStateException("This producer is already closed.");
            }
            log.info("Creating new resilient producer.");
            this.producer = new KafkaProducer(this.producerProps, this.keySerializer, this.valSerializer);
        }
        return this.producer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void closeProducer(KafkaProducer<?, ?> producer, boolean fromCallback) {
        block12: {
            try {
                if (producer == null) {
                    producer = this.producer;
                }
                if (producer == null || producer != this.producer) break block12;
                try {
                    log.info("Closing resilient producer.");
                    if (fromCallback) {
                        producer.close(Duration.ZERO);
                    } else {
                        producer.close();
                    }
                }
                catch (Exception e) {
                    log.warn("Exception caught while closing producer.", (Throwable)e);
                }
                finally {
                    this.producer = null;
                }
            }
            finally {
                if (!fromCallback) {
                    this.closed = true;
                }
            }
        }
    }

    private class CFC
    extends CompletableFuture<RecordMetadata>
    implements Callback {
        private final KafkaProducer<?, ?> producer;

        CFC(KafkaProducer<?, ?> producer) {
            this.producer = producer;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onCompletion(RecordMetadata metadata, Exception exception) {
            if (exception != null) {
                try {
                    if (!this.isFatalException(exception)) return;
                    AsyncProducer.this.closeProducer(this.producer, true);
                    return;
                }
                finally {
                    this.completeExceptionally(exception);
                }
            } else {
                this.complete(metadata);
            }
        }

        private boolean isFatalException(Exception e) {
            return e instanceof UnsupportedVersionException || e instanceof AuthorizationException || e instanceof ProducerFencedException || e instanceof OutOfOrderSequenceException;
        }
    }
}

