/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.utils.tests.ParallelizableTest;
import io.apicurio.registry.utils.tests.TestUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Assertions;

@ParallelizableTest
public abstract class AbstractRegistryTestBase {
    public static final String CURRENT_ENV = "CURRENT_ENV";
    public static final String CURRENT_ENV_MAS_REGEX = ".*mas.*";
    @ConfigProperty(name="quarkus.http.test-port")
    public int testPort;

    protected String generateArtifactId() {
        return TestUtils.generateArtifactId();
    }

    protected final String resourceToString(String resourceName) {
        String string;
        block8: {
            InputStream stream = this.getClass().getResourceAsStream(resourceName);
            try {
                Assertions.assertNotNull((Object)stream, (String)("Resource not found: " + resourceName));
                string = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            stream.close();
        }
        return string;
    }

    protected final InputStream resourceToInputStream(String resourceName) {
        InputStream stream = this.getClass().getResourceAsStream(resourceName);
        Assertions.assertNotNull((Object)stream, (String)("Resource not found: " + resourceName));
        return stream;
    }

    protected final ContentHandle resourceToContentHandle(String resourceName) {
        return ContentHandle.create((String)this.resourceToString(resourceName));
    }

    public static void assertMultilineTextEquals(String expected, String actual) throws Exception {
        Assertions.assertEquals((Object)TestUtils.normalizeMultiLineString((String)expected), (Object)TestUtils.normalizeMultiLineString((String)actual));
    }
}

