/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.AdminClientFactory;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.v2.V2ApiUtil;
import io.apicurio.registry.rest.v2.beans.ArtifactContent;
import io.apicurio.registry.rest.v2.beans.ArtifactReference;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.storage.dto.ArtifactReferenceDto;
import io.apicurio.registry.types.ArtifactMediaTypes;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.TestUtils;
import io.apicurio.rest.client.auth.Auth;
import io.restassured.RestAssured;
import io.restassured.http.ContentType;
import io.restassured.parsing.Parser;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInstance;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
public abstract class AbstractResourceTestBase
extends AbstractRegistryTestBase {
    public static final String CT_JSON = "application/json";
    protected static final String CT_PROTO = "application/x-protobuf";
    protected static final String CT_YAML = "application/x-yaml";
    protected static final String CT_XML = "application/xml";
    public static final String CT_JSON_EXTENDED = "application/create.extended+json";
    public String registryApiBaseUrl;
    protected String registryV1ApiUrl;
    protected String registryV2ApiUrl;
    protected RegistryClient clientV2;
    protected AdminClient adminClientV2;

    @BeforeAll
    protected void beforeAll() throws Exception {
        String serverUrl = "http://localhost:%s/apis";
        this.registryApiBaseUrl = String.format(serverUrl, this.testPort);
        this.registryV1ApiUrl = this.registryApiBaseUrl + "/registry/v1";
        this.registryV2ApiUrl = this.registryApiBaseUrl + "/registry/v2";
        this.clientV2 = this.createRestClientV2();
        this.adminClientV2 = this.createAdminClientV2();
    }

    @AfterAll
    protected void afterAll() {
    }

    protected RegistryClient createRestClientV2() {
        return RegistryClientFactory.create((String)this.registryV2ApiUrl);
    }

    protected AdminClient createAdminClientV2() {
        return AdminClientFactory.create((String)this.registryV2ApiUrl);
    }

    protected RegistryClient createClient(Auth auth) {
        return RegistryClientFactory.create((String)this.registryV2ApiUrl, Collections.emptyMap(), (Auth)auth);
    }

    protected AdminClient createAdminClient(Auth auth) {
        return AdminClientFactory.create((String)this.registryV2ApiUrl, Collections.emptyMap(), (Auth)auth);
    }

    @BeforeEach
    protected void beforeEach() throws Exception {
        this.setupRestAssured();
        this.deleteGlobalRules(0);
    }

    protected void setupRestAssured() {
        RestAssured.baseURI = this.registryApiBaseUrl;
        RestAssured.registerParser((String)ArtifactMediaTypes.BINARY.toString(), (Parser)Parser.JSON);
    }

    protected void deleteGlobalRules(int expectedDefaultRulesCount) throws Exception {
        TestUtils.retry(() -> {
            this.adminClientV2.deleteAllGlobalRules();
            Assertions.assertEquals((int)expectedDefaultRulesCount, (int)this.adminClientV2.listGlobalRules().size());
        });
    }

    protected Integer createArtifact(String artifactId, String artifactType, String artifactContent) throws Exception {
        ValidatableResponse response = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)artifactType, new Object[0]).body(artifactContent).post("/registry/v1/artifacts", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("type", Matchers.equalTo((Object)artifactType), new Object[0]);
        this.waitForArtifact(artifactId);
        return (Integer)response.extract().body().path("globalId", new String[0]);
    }

    protected Integer createArtifact(String groupId, String artifactId, String artifactType, String artifactContent) throws Exception {
        ValidatableResponse response = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("groupId", (Object)groupId).header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]).header("X-Registry-ArtifactType", (Object)artifactType, new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("type", Matchers.equalTo((Object)artifactType), new Object[0]);
        this.waitForArtifact(groupId, artifactId);
        return (Integer)response.extract().body().path("globalId", new String[0]);
    }

    protected Integer createArtifactWithReferences(String groupId, String artifactId, String artifactType, String artifactContent, List<ArtifactReference> artifactReferences) throws Exception {
        ValidatableResponse response = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)this.createArtifactExtendedRaw(groupId, artifactId, artifactType, artifactContent, artifactReferences).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("type", Matchers.equalTo((Object)artifactType), new Object[0]);
        this.waitForArtifact(groupId, artifactId);
        return (Integer)response.extract().body().path("globalId", new String[0]);
    }

    protected Integer updateArtifactWithReferences(String groupId, String artifactId, String artifactType, String artifactContent, List<ArtifactReference> artifactReferences) throws Exception {
        ValidatableResponse response = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)this.updateArtifactExtendedRaw(groupId, artifactId, artifactType, artifactContent, artifactReferences).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("type", Matchers.equalTo((Object)artifactType), new Object[0]);
        this.waitForArtifact(groupId, artifactId);
        return (Integer)response.extract().body().path("globalId", new String[0]);
    }

    protected ValidatableResponse createArtifactExtendedRaw(String groupId, String artifactId, String artifactType, String artifactContent, List<ArtifactReference> artifactReferences) throws Exception {
        ArtifactContent ArtifactContent2 = new ArtifactContent();
        ArtifactContent2.setContent(artifactContent);
        ArtifactContent2.setReferences(artifactReferences);
        RequestSpecification request = RestAssured.given().when().contentType(CT_JSON_EXTENDED).pathParam("groupId", (Object)groupId);
        if (artifactId != null) {
            request.header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]);
        }
        if (artifactType != null) {
            request.header("X-Registry-ArtifactType", (Object)artifactType, new Object[0]);
        }
        return (ValidatableResponse)((Response)request.body((Object)ArtifactContent2).post("/registry/v2/groups/{groupId}/artifacts", new Object[0])).then();
    }

    protected ValidatableResponse updateArtifactExtendedRaw(String groupId, String artifactId, String artifactType, String artifactContent, List<ArtifactReference> artifactReferences) throws Exception {
        ArtifactContent contentCreateRequest = new ArtifactContent();
        contentCreateRequest.setContent(artifactContent);
        contentCreateRequest.setReferences(artifactReferences);
        RequestSpecification request = RestAssured.given().when().contentType(CT_JSON_EXTENDED).pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId);
        if (artifactId != null) {
            request.header("X-Registry-ArtifactId", (Object)artifactId, new Object[0]);
        }
        if (artifactType != null) {
            request.header("X-Registry-ArtifactType", (Object)artifactType, new Object[0]);
        }
        return (ValidatableResponse)((Response)request.body((Object)contentCreateRequest).put("/registry/v2/groups/{groupId}/artifacts/{artifactId}", new Object[0])).then();
    }

    protected Integer createArtifactVersion(String artifactId, String artifactType, String artifactContent) throws Exception {
        ValidatableResponse response = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("artifactId", (Object)artifactId).header("X-Registry-ArtifactType", (Object)artifactType, new Object[0]).body(artifactContent).post("/registry/v1/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("type", Matchers.equalTo((Object)artifactType), new Object[0]);
        return (Integer)response.extract().body().path("globalId", new String[0]);
    }

    protected Integer createArtifactVersion(String groupId, String artifactId, String artifactType, String artifactContent) throws Exception {
        ValidatableResponse response = (ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).header("X-Registry-ArtifactType", (Object)artifactType, new Object[0]).body(artifactContent).post("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions", new Object[0])).then()).statusCode(200)).body("id", Matchers.equalTo((Object)artifactId), new Object[0])).body("type", Matchers.equalTo((Object)artifactType), new Object[0]);
        return (Integer)response.extract().body().path("globalId", new String[0]);
    }

    protected void createArtifactRule(String groupId, String artifactId, RuleType ruleType, String ruleConfig) {
        Rule rule = new Rule();
        rule.setConfig(ruleConfig);
        rule.setType(ruleType);
        this.clientV2.createArtifactRule(groupId, artifactId, rule);
    }

    protected Rule createGlobalRule(RuleType ruleType, String ruleConfig) {
        Rule rule = new Rule();
        rule.setConfig(ruleConfig);
        rule.setType(ruleType);
        this.clientV2.createGlobalRule(rule);
        return rule;
    }

    protected void waitForArtifact(String artifactId) throws Exception {
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200));
    }

    protected void waitForArtifact(String groupId, String artifactId) throws Exception {
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("groupId", (Object)(groupId == null ? "default" : groupId)).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(200));
    }

    protected void waitForArtifactRule(String artifactId, RuleType ruleType) throws Exception {
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("rule", (Object)ruleType.value()).pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/rules/{rule}", new Object[0])).then()).statusCode(200));
    }

    protected void waitForVersion(String artifactId, int version) throws Exception {
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("artifactId", (Object)artifactId).pathParam("version", (Object)version).get("/registry/v1/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(200));
    }

    protected void waitForVersion(String groupId, String artifactId, int version) throws Exception {
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).pathParam("version", (Object)version).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then()).statusCode(200));
    }

    protected void waitForGlobalId(long globalId) throws Exception {
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("globalId", (Object)globalId).get("/registry/v1/ids/{globalId}/meta", new Object[0])).then()).statusCode(200));
    }

    protected void waitForContentId(long contentId) throws Exception {
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("contentId", (Object)contentId).get("/registry/v2/ids/contentIds/{contentId}", new Object[0])).then()).statusCode(200));
    }

    protected void waitForArtifactState(String artifactId, ArtifactState state) throws Exception {
        TestUtils.retry(() -> this.validateMetaDataResponseState((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("artifactId", (Object)artifactId).get("/registry/v1/artifacts/{artifactId}/meta", new Object[0])).then(), state, false));
    }

    protected void waitForArtifactState(String groupId, String artifactId, ArtifactState state) throws Exception {
        TestUtils.retry(() -> this.validateMetaDataResponseState((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then(), state, false));
    }

    protected void waitForVersionState(String artifactId, int version, ArtifactState state) throws Exception {
        TestUtils.retry(() -> this.validateMetaDataResponseState((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("artifactId", (Object)artifactId).pathParam("version", (Object)version).get("/registry/v1/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then(), state, true));
    }

    protected void waitForVersionState(String groupId, String artifactId, String version, ArtifactState state) throws Exception {
        TestUtils.retry(() -> this.validateMetaDataResponseState((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).pathParam("version", (Object)version).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/versions/{version}/meta", new Object[0])).then(), state, true));
    }

    protected void waitForVersionState(long globalId, ArtifactState state) throws Exception {
        TestUtils.retry(() -> this.validateMetaDataResponseState((ValidatableResponse)((Response)RestAssured.given().when().contentType(CT_JSON).pathParam("globalId", (Object)globalId).get("/registry/v1/ids/{globalId}/meta", new Object[0])).then(), state, true));
    }

    public void waitForGlobalRule(RuleType ruleType, String ruleConfig) throws Exception {
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/registry/v1/rules/VALIDITY", new Object[0])).then()).statusCode(200)).contentType(ContentType.JSON)).body("type", Matchers.equalTo((Object)ruleType.value()), new Object[0])).body("config", Matchers.equalTo((Object)ruleConfig), new Object[0]));
    }

    protected void validateMetaDataResponseState(ValidatableResponse response, ArtifactState state, boolean version) {
        response.statusCode(200);
        response.body("state", Matchers.equalTo((Object)state.name()), new Object[0]);
    }

    protected String getRandomValidJsonSchemaContent() {
        return "{\n  \"$id\": \"https://example.com/person.schema.json\",\n  \"$schema\": \"http://json-schema.org/draft-07/schema#\",\n  \"title\": \"Person-" + UUID.randomUUID() + "\",\n  \"type\": \"object\",\n  \"properties\": {\n  }\n}";
    }

    protected byte[] concatContentAndReferences(byte[] contentBytes, String references) throws IOException {
        if (references != null) {
            byte[] referencesBytes = references.getBytes(StandardCharsets.UTF_8);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream(contentBytes.length + referencesBytes.length);
            outputStream.write(contentBytes);
            outputStream.write(referencesBytes);
            return outputStream.toByteArray();
        }
        return contentBytes;
    }

    protected List<ArtifactReferenceDto> toReferenceDtos(List<ArtifactReference> references) {
        if (references == null) {
            references = Collections.emptyList();
        }
        return references.stream().peek(r -> r.setGroupId(V2ApiUtil.defaultGroupIdToNull((String)r.getGroupId()))).map(V2ApiUtil::referenceToDto).collect(Collectors.toList());
    }
}

