/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.utils.tests.AuthTestProfileAnonymousCredentials;
import io.apicurio.registry.utils.tests.JWKSMockServer;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.auth.exception.NotAuthorizedException;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=AuthTestProfileAnonymousCredentials.class)
@Tag(value="slow")
public class AuthTestAnonymousCredentials
extends AbstractResourceTestBase {
    @ConfigProperty(name="registry.auth.token.endpoint")
    @Info(category="auth", description="Auth token endpoint", availableSince="2.1.0.Final")
    String authServerUrl;
    final String groupId = this.getClass().getSimpleName() + "Group";
    ApicurioHttpClient httpClient;

    @Override
    protected RegistryClient createRestClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrl, (RestClientErrorHandler)new AuthErrorHandler());
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.NO_ROLE_CLIENT_ID, "test1");
        return this.createClient((Auth)auth);
    }

    @Override
    protected AdminClient createAdminClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrl, (RestClientErrorHandler)new AuthErrorHandler());
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        return this.createAdminClient((Auth)auth);
    }

    @Test
    public void testWrongCreds() throws Exception {
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.WRONG_CREDS_CLIENT_ID, "secret");
        RegistryClient client = this.createClient((Auth)auth);
        Assertions.assertThrows(NotAuthorizedException.class, () -> client.listArtifactsInGroup(this.groupId));
    }

    @Test
    public void testNoCredentials() throws Exception {
        RegistryClient client = RegistryClientFactory.create((String)this.registryV2ApiUrl, Collections.emptyMap(), null);
        ArtifactSearchResults results = client.searchArtifacts(this.groupId, null, null, null, null, null, null, null, null);
        Assertions.assertTrue((results.getCount() >= 0 ? 1 : 0) != 0);
        ByteArrayInputStream data = new ByteArrayInputStream("{\r\n    \"type\" : \"record\",\r\n    \"name\" : \"userInfo\",\r\n    \"namespace\" : \"my.example\",\r\n    \"fields\" : [{\"name\" : \"age\", \"type\" : \"int\"}]\r\n}".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThrows(NotAuthorizedException.class, () -> client.createArtifact(this.groupId, "testNoCredentials", "AVRO", data));
    }
}

