/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.utils.tests.AuthTestProfileAuthenticatedReadAccess;
import io.apicurio.registry.utils.tests.JWKSMockServer;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.auth.exception.ForbiddenException;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=AuthTestProfileAuthenticatedReadAccess.class)
@Tag(value="slow")
public class AuthTestAuthenticatedReadAccess
extends AbstractResourceTestBase {
    @ConfigProperty(name="registry.auth.token.endpoint")
    @Info(category="auth", description="Auth token endpoint", availableSince="2.1.0.Final")
    String authServerUrl;
    final String groupId = this.getClass().getSimpleName() + "Group";
    ApicurioHttpClient httpClient;

    @Override
    protected RegistryClient createRestClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrl, (RestClientErrorHandler)new AuthErrorHandler());
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        return this.createClient((Auth)auth);
    }

    @Override
    protected AdminClient createAdminClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrl, (RestClientErrorHandler)new AuthErrorHandler());
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        return this.createAdminClient((Auth)auth);
    }

    @Test
    public void testReadOperationWithNoRole() throws Exception {
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.NO_ROLE_CLIENT_ID, "test1");
        RegistryClient client = this.createClient((Auth)auth);
        ArtifactSearchResults results = client.searchArtifacts(this.groupId, null, null, null, null, null, null, null, null);
        Assertions.assertTrue((results.getCount() >= 0 ? 1 : 0) != 0);
        ByteArrayInputStream data = new ByteArrayInputStream("{\r\n    \"type\" : \"record\",\r\n    \"name\" : \"userInfo\",\r\n    \"namespace\" : \"my.example\",\r\n    \"fields\" : [{\"name\" : \"age\", \"type\" : \"int\"}]\r\n}".getBytes(StandardCharsets.UTF_8));
        Assertions.assertThrows(ForbiddenException.class, () -> client.createArtifact(this.groupId, "testReadOperationWithNoRole", "AVRO", data));
    }
}

