/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.v2.beans.RoleMapping;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RoleType;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.AuthTestProfileWithLocalRoles;
import io.apicurio.registry.utils.tests.JWKSMockServer;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.auth.exception.ForbiddenException;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=AuthTestProfileWithLocalRoles.class)
@Tag(value="slow")
public class AuthTestLocalRoles
extends AbstractResourceTestBase {
    private static final String TEST_CONTENT = "{\r\n    \"type\" : \"record\",\r\n    \"name\" : \"userInfo\",\r\n    \"namespace\" : \"my.example\",\r\n    \"fields\" : [{\"name\" : \"age\", \"type\" : \"int\"}]\r\n} ";
    @ConfigProperty(name="registry.auth.token.endpoint")
    @Info(category="auth", description="Auth token endpoint", availableSince="2.1.0.Final")
    String authServerUrlConfigured;
    ApicurioHttpClient httpClient;

    @Override
    protected AdminClient createAdminClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrlConfigured, (RestClientErrorHandler)new AuthErrorHandler());
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        return this.createAdminClient((Auth)auth);
    }

    @Override
    protected RegistryClient createRestClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrlConfigured, (RestClientErrorHandler)new AuthErrorHandler());
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        return this.createClient((Auth)auth);
    }

    @Test
    public void testLocalRoles() throws Exception {
        OidcAuth authAdmin = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        AdminClient clientAdmin = this.createAdminClient((Auth)authAdmin);
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.NO_ROLE_CLIENT_ID, "test1");
        RegistryClient client = this.createClient((Auth)auth);
        Assertions.assertThrows(ForbiddenException.class, () -> client.listArtifactsInGroup("default"));
        Assertions.assertThrows(ForbiddenException.class, () -> client.createArtifact(this.getClass().getSimpleName(), UUID.randomUUID().toString(), (InputStream)new ByteArrayInputStream(TEST_CONTENT.getBytes(StandardCharsets.UTF_8))));
        Assertions.assertThrows(ForbiddenException.class, () -> {
            Rule rule = new Rule();
            rule.setConfig(ValidityLevel.FULL.name());
            rule.setType(RuleType.VALIDITY);
            client.createGlobalRule(rule);
        });
        RoleMapping mapping = new RoleMapping();
        mapping.setPrincipalId(JWKSMockServer.NO_ROLE_CLIENT_ID);
        mapping.setRole(RoleType.READ_ONLY);
        clientAdmin.createRoleMapping(mapping);
        client.listArtifactsInGroup("default");
        Assertions.assertThrows(ForbiddenException.class, () -> client.createArtifact(this.getClass().getSimpleName(), UUID.randomUUID().toString(), (InputStream)new ByteArrayInputStream(TEST_CONTENT.getBytes(StandardCharsets.UTF_8))));
        Assertions.assertThrows(ForbiddenException.class, () -> {
            Rule rule = new Rule();
            rule.setConfig(ValidityLevel.FULL.name());
            rule.setType(RuleType.VALIDITY);
            client.createGlobalRule(rule);
        });
        clientAdmin.updateRoleMapping(JWKSMockServer.NO_ROLE_CLIENT_ID, RoleType.DEVELOPER);
        client.listArtifactsInGroup("default");
        client.createArtifact(this.getClass().getSimpleName(), UUID.randomUUID().toString(), (InputStream)new ByteArrayInputStream(TEST_CONTENT.getBytes(StandardCharsets.UTF_8)));
        Assertions.assertThrows(ForbiddenException.class, () -> {
            Rule rule = new Rule();
            rule.setConfig(ValidityLevel.FULL.name());
            rule.setType(RuleType.VALIDITY);
            client.createGlobalRule(rule);
        });
        clientAdmin.updateRoleMapping(JWKSMockServer.NO_ROLE_CLIENT_ID, RoleType.ADMIN);
        client.listArtifactsInGroup("default");
        client.createArtifact(this.getClass().getSimpleName(), UUID.randomUUID().toString(), (InputStream)new ByteArrayInputStream(TEST_CONTENT.getBytes(StandardCharsets.UTF_8)));
        Rule rule = new Rule();
        rule.setConfig(ValidityLevel.FULL.name());
        rule.setType(RuleType.VALIDITY);
        client.createGlobalRule(rule);
    }
}

