/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.AdminClientFactory;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.AuthTestProfile;
import io.apicurio.registry.utils.tests.JWKSMockServer;
import io.apicurio.registry.utils.tests.TestUtils;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.BasicAuth;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.auth.exception.NotAuthorizedException;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=AuthTestProfile.class)
@Tag(value="slow")
public class AuthTestProfileBasicClientCredentials
extends AbstractResourceTestBase {
    @ConfigProperty(name="registry.auth.token.endpoint")
    @Info(category="auth", description="Auth token endpoint", availableSince="2.1.0.Final")
    String authServerUrl;
    final String groupId = "authTestGroupId";
    ApicurioHttpClient httpClient;

    @Override
    protected RegistryClient createRestClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrl, (RestClientErrorHandler)new AuthErrorHandler());
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.NO_ROLE_CLIENT_ID, "test1");
        return this.createClient((Auth)auth);
    }

    @Override
    protected AdminClient createAdminClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrl, (RestClientErrorHandler)new AuthErrorHandler());
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        return this.createAdminClient((Auth)auth);
    }

    @Test
    public void testWrongCreds() throws Exception {
        BasicAuth auth = new BasicAuth(JWKSMockServer.WRONG_CREDS_CLIENT_ID, "test55");
        RegistryClient client = this.createClient((Auth)auth);
        Assertions.assertThrows(NotAuthorizedException.class, () -> client.listArtifactsInGroup("authTestGroupId"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBasicAuthClientCredentials() throws Exception {
        BasicAuth auth = new BasicAuth(JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        RegistryClient client = this.createClient((Auth)auth);
        AdminClient adminClient = AdminClientFactory.create((String)this.registryV2ApiUrl, Collections.emptyMap(), (Auth)auth);
        String artifactId = TestUtils.generateArtifactId();
        try {
            client.listArtifactsInGroup("authTestGroupId");
            client.createArtifact("authTestGroupId", artifactId, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes()));
            TestUtils.retry(() -> client.getArtifactMetaData("authTestGroupId", artifactId));
            Assertions.assertNotNull((Object)client.getLatestArtifact("authTestGroupId", artifactId));
            Rule ruleConfig = new Rule();
            ruleConfig.setType(RuleType.VALIDITY);
            ruleConfig.setConfig(ValidityLevel.NONE.name());
            client.createArtifactRule("authTestGroupId", artifactId, ruleConfig);
            adminClient.createGlobalRule(ruleConfig);
        }
        finally {
            client.deleteArtifact("authTestGroupId", artifactId);
        }
    }

    @Test
    public void testNoCredentials() throws Exception {
        RegistryClient client = RegistryClientFactory.create((String)this.registryV2ApiUrl, Collections.emptyMap(), null);
        Assertions.assertThrows(NotAuthorizedException.class, () -> client.listArtifactsInGroup("authTestGroupId"));
    }
}

