/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.AuthTestProfileWithHeaderRoles;
import io.apicurio.registry.utils.tests.JWKSMockServer;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.auth.exception.ForbiddenException;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=AuthTestProfileWithHeaderRoles.class)
@Tag(value="slow")
public class HeaderRoleSourceTest
extends AbstractResourceTestBase {
    private static final String TEST_CONTENT = "{\r\n    \"type\" : \"record\",\r\n    \"name\" : \"userInfo\",\r\n    \"namespace\" : \"my.example\",\r\n    \"fields\" : [{\"name\" : \"age\", \"type\" : \"int\"}]\r\n} ";
    @ConfigProperty(name="registry.auth.token.endpoint")
    @Info(category="auth", description="Auth token endpoint", availableSince="2.1.0.Final")
    String authServerUrlConfigured;
    ApicurioHttpClient httpClient;

    @Override
    protected AdminClient createAdminClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrlConfigured, (RestClientErrorHandler)new AuthErrorHandler());
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        return this.createAdminClient((Auth)auth);
    }

    protected RegistryClient createAdminClientRole(Auth auth) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("apicurio.rest.request.headers.x-registry-role", "sr-admin");
        return RegistryClientFactory.create((String)this.registryV2ApiUrl, headers, (Auth)auth);
    }

    protected RegistryClient createDevClientRole(Auth auth) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("apicurio.rest.request.headers.x-registry-role", "sr-developer");
        return RegistryClientFactory.create((String)this.registryV2ApiUrl, headers, (Auth)auth);
    }

    protected RegistryClient createNoRoleClient(Auth auth) {
        return RegistryClientFactory.create((String)this.registryV2ApiUrl, Collections.emptyMap(), (Auth)auth);
    }

    protected RegistryClient createReadClientRole(Auth auth) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("apicurio.rest.request.headers.x-registry-role", "sr-readonly");
        return RegistryClientFactory.create((String)this.registryV2ApiUrl, headers, (Auth)auth);
    }

    @Test
    public void testLocalRoles() throws Exception {
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.NO_ROLE_CLIENT_ID, "test1");
        RegistryClient noRoleClient = this.createNoRoleClient((Auth)auth);
        OidcAuth authRead = new OidcAuth(this.httpClient, JWKSMockServer.DEVELOPER_CLIENT_ID, "test1");
        RegistryClient readClient = this.createReadClientRole((Auth)authRead);
        OidcAuth authDev = new OidcAuth(this.httpClient, JWKSMockServer.READONLY_CLIENT_ID, "test1");
        RegistryClient devClient = this.createDevClientRole((Auth)authDev);
        OidcAuth authAdmin = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        RegistryClient adminClient = this.createAdminClientRole((Auth)authAdmin);
        Assertions.assertThrows(ForbiddenException.class, () -> noRoleClient.listArtifactsInGroup("default"));
        Assertions.assertThrows(ForbiddenException.class, () -> noRoleClient.createArtifact(this.getClass().getSimpleName(), UUID.randomUUID().toString(), (InputStream)new ByteArrayInputStream(TEST_CONTENT.getBytes(StandardCharsets.UTF_8))));
        Assertions.assertThrows(ForbiddenException.class, () -> {
            Rule rule = new Rule();
            rule.setConfig(ValidityLevel.FULL.name());
            rule.setType(RuleType.VALIDITY);
            noRoleClient.createGlobalRule(rule);
        });
        readClient.listArtifactsInGroup("default");
        Assertions.assertThrows(ForbiddenException.class, () -> readClient.createArtifact(this.getClass().getSimpleName(), UUID.randomUUID().toString(), (InputStream)new ByteArrayInputStream(TEST_CONTENT.getBytes(StandardCharsets.UTF_8))));
        Assertions.assertThrows(ForbiddenException.class, () -> {
            Rule rule = new Rule();
            rule.setConfig(ValidityLevel.FULL.name());
            rule.setType(RuleType.VALIDITY);
            readClient.createGlobalRule(rule);
        });
        devClient.listArtifactsInGroup("default");
        devClient.createArtifact(this.getClass().getSimpleName(), UUID.randomUUID().toString(), (InputStream)new ByteArrayInputStream(TEST_CONTENT.getBytes(StandardCharsets.UTF_8)));
        Assertions.assertThrows(ForbiddenException.class, () -> {
            Rule rule = new Rule();
            rule.setConfig(ValidityLevel.FULL.name());
            rule.setType(RuleType.VALIDITY);
            devClient.createGlobalRule(rule);
        });
        adminClient.listArtifactsInGroup("default");
        adminClient.createArtifact(this.getClass().getSimpleName(), UUID.randomUUID().toString(), (InputStream)new ByteArrayInputStream(TEST_CONTENT.getBytes(StandardCharsets.UTF_8)));
        Rule rule = new Rule();
        rule.setConfig(ValidityLevel.FULL.name());
        rule.setType(RuleType.VALIDITY);
        adminClient.createGlobalRule(rule);
    }
}

