/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.maven.RegisterRegistryMojo;
import io.apicurio.registry.noprofile.maven.RegistryMojoTestBase;
import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.utils.tests.AuthTestProfile;
import io.apicurio.registry.utils.tests.JWKSMockServer;
import io.apicurio.registry.utils.tests.TestUtils;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=AuthTestProfile.class)
@Tag(value="slow")
public class MojoAuthTest
extends RegistryMojoTestBase {
    @ConfigProperty(name="registry.auth.token.endpoint")
    @Info(category="auth", description="Auth token endpoint", availableSince="2.1.0.Final")
    String authServerUrlConfigured;
    @ConfigProperty(name="quarkus.oidc.tenant-enabled")
    @Info(category="auth", description="OIDC tenant enabled", availableSince="2.0.0.Final")
    Boolean authEnabled;
    String clientSecret = "test1";
    String clientScope = "testScope";
    String testUsername = "sr-test-user";
    String testPassword = "sr-test-password";
    ApicurioHttpClient httpClient;

    @Override
    protected RegistryClient createRestClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrlConfigured, (RestClientErrorHandler)new AuthErrorHandler());
        System.out.println("Auth is " + this.authEnabled);
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        return this.createClient((Auth)auth);
    }

    @Override
    protected AdminClient createAdminClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrlConfigured, (RestClientErrorHandler)new AuthErrorHandler());
        System.out.println("Auth is " + this.authEnabled);
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        return this.createAdminClient((Auth)auth);
    }

    @Test
    public void testRegister() throws IOException, MojoFailureException, MojoExecutionException {
        System.out.println("Auth is " + this.authEnabled);
        RegisterRegistryMojo registerRegistryMojo = new RegisterRegistryMojo();
        registerRegistryMojo.setRegistryUrl(TestUtils.getRegistryV2ApiUrl((int)this.testPort));
        registerRegistryMojo.setAuthServerUrl(this.authServerUrlConfigured);
        registerRegistryMojo.setClientId(JWKSMockServer.ADMIN_CLIENT_ID);
        registerRegistryMojo.setClientSecret(this.clientSecret);
        registerRegistryMojo.setClientScope(this.clientScope);
        super.testRegister(registerRegistryMojo, "testRegister");
    }

    @Test
    public void testBasicAuth() throws IOException, MojoFailureException, MojoExecutionException {
        System.out.println("Auth is " + this.authEnabled);
        RegisterRegistryMojo registerRegistryMojo = new RegisterRegistryMojo();
        registerRegistryMojo.setClient(null);
        registerRegistryMojo.setRegistryUrl(TestUtils.getRegistryV2ApiUrl((int)this.testPort));
        registerRegistryMojo.setUsername(this.testUsername);
        registerRegistryMojo.setPassword(this.testPassword);
        super.testRegister(registerRegistryMojo, "testBasicAuth");
    }
}

