/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.auth;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.exception.ArtifactNotFoundException;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactOwner;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.IfExists;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.UserInfo;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.tests.AuthTestProfile;
import io.apicurio.registry.utils.tests.JWKSMockServer;
import io.apicurio.registry.utils.tests.TestUtils;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.BasicAuth;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.auth.exception.ForbiddenException;
import io.apicurio.rest.client.auth.exception.NotAuthorizedException;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=AuthTestProfile.class)
@Tag(value="slow")
public class SimpleAuthTest
extends AbstractResourceTestBase {
    private static final String ARTIFACT_CONTENT = "{\"name\":\"redhat\"}";
    @ConfigProperty(name="registry.auth.token.endpoint")
    @Info(category="auth", description="Auth token endpoint", availableSince="2.1.0.Final")
    String authServerUrlConfigured;
    final String groupId = "authTestGroupId";
    ApicurioHttpClient httpClient;

    @Override
    protected RegistryClient createRestClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrlConfigured, (RestClientErrorHandler)new AuthErrorHandler());
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        return this.createClient((Auth)auth);
    }

    @Override
    protected AdminClient createAdminClientV2() {
        this.httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrlConfigured, (RestClientErrorHandler)new AuthErrorHandler());
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        return this.createAdminClient((Auth)auth);
    }

    @Test
    public void testWrongCreds() throws Exception {
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.WRONG_CREDS_CLIENT_ID, "test55");
        RegistryClient client = this.createClient((Auth)auth);
        Assertions.assertThrows(NotAuthorizedException.class, () -> client.listArtifactsInGroup("authTestGroupId"));
    }

    @Test
    public void testNoCreds() throws Exception {
        RegistryClient clientNoAuth = this.createClient(null);
        Assertions.assertThrows(NotAuthorizedException.class, () -> clientNoAuth.listArtifactsInGroup("authTestGroupId"));
    }

    @Test
    public void testReadOnly() throws Exception {
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.READONLY_CLIENT_ID, "test1");
        RegistryClient client = this.createClient((Auth)auth);
        String artifactId = TestUtils.generateArtifactId();
        client.listArtifactsInGroup("authTestGroupId");
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> client.getArtifactMetaData("authTestGroupId", artifactId));
        Assertions.assertThrows(ArtifactNotFoundException.class, () -> client.getLatestArtifact("abc", artifactId));
        Assertions.assertThrows(ForbiddenException.class, () -> client.createArtifact("testReadOnly", artifactId, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes())));
        OidcAuth devAuth = new OidcAuth(this.httpClient, JWKSMockServer.DEVELOPER_CLIENT_ID, "test1");
        RegistryClient devClient = this.createClient((Auth)devAuth);
        ArtifactMetaData meta = devClient.createArtifact("authTestGroupId", artifactId, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes()));
        TestUtils.retry(() -> devClient.getArtifactMetaData("authTestGroupId", meta.getId()));
        Assertions.assertNotNull((Object)client.getLatestArtifact("authTestGroupId", artifactId));
        UserInfo userInfo = client.getCurrentUserInfo();
        Assertions.assertNotNull((Object)userInfo);
        Assertions.assertEquals((Object)"readonly-client", (Object)userInfo.getUsername());
        Assertions.assertFalse((boolean)userInfo.getAdmin());
        Assertions.assertFalse((boolean)userInfo.getDeveloper());
        Assertions.assertTrue((boolean)userInfo.getViewer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDevRole() throws Exception {
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.DEVELOPER_CLIENT_ID, "test1");
        RegistryClient client = this.createClient((Auth)auth);
        String artifactId = TestUtils.generateArtifactId();
        try {
            client.listArtifactsInGroup("authTestGroupId");
            client.createArtifact("authTestGroupId", artifactId, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes()));
            TestUtils.retry(() -> client.getArtifactMetaData("authTestGroupId", artifactId));
            Assertions.assertNotNull((Object)client.getLatestArtifact("authTestGroupId", artifactId));
            Rule ruleConfig = new Rule();
            ruleConfig.setType(RuleType.VALIDITY);
            ruleConfig.setConfig(ValidityLevel.NONE.name());
            client.createArtifactRule("authTestGroupId", artifactId, ruleConfig);
            Assertions.assertThrows(ForbiddenException.class, () -> client.createGlobalRule(ruleConfig));
            UserInfo userInfo = client.getCurrentUserInfo();
            Assertions.assertNotNull((Object)userInfo);
            Assertions.assertEquals((Object)"developer-client", (Object)userInfo.getUsername());
            Assertions.assertFalse((boolean)userInfo.getAdmin());
            Assertions.assertTrue((boolean)userInfo.getDeveloper());
            Assertions.assertFalse((boolean)userInfo.getViewer());
        }
        finally {
            client.deleteArtifact("authTestGroupId", artifactId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminRole() throws Exception {
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        RegistryClient client = this.createClient((Auth)auth);
        AdminClient adminClient = this.createAdminClient((Auth)auth);
        String artifactId = TestUtils.generateArtifactId();
        try {
            client.listArtifactsInGroup("authTestGroupId");
            client.createArtifact("authTestGroupId", artifactId, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes()));
            TestUtils.retry(() -> client.getArtifactMetaData("authTestGroupId", artifactId));
            Assertions.assertNotNull((Object)client.getLatestArtifact("authTestGroupId", artifactId));
            Rule ruleConfig = new Rule();
            ruleConfig.setType(RuleType.VALIDITY);
            ruleConfig.setConfig(ValidityLevel.NONE.name());
            client.createArtifactRule("authTestGroupId", artifactId, ruleConfig);
            adminClient.createGlobalRule(ruleConfig);
            UserInfo userInfo = client.getCurrentUserInfo();
            Assertions.assertNotNull((Object)userInfo);
            Assertions.assertEquals((Object)"admin-client", (Object)userInfo.getUsername());
            Assertions.assertTrue((boolean)userInfo.getAdmin());
            Assertions.assertFalse((boolean)userInfo.getDeveloper());
            Assertions.assertFalse((boolean)userInfo.getViewer());
        }
        finally {
            client.deleteArtifact("authTestGroupId", artifactId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAdminRoleBasicAuth() throws Exception {
        BasicAuth auth = new BasicAuth(JWKSMockServer.BASIC_USER, JWKSMockServer.BASIC_PASSWORD);
        RegistryClient client = this.createClient((Auth)auth);
        AdminClient adminClient = this.createAdminClient((Auth)auth);
        String artifactId = TestUtils.generateArtifactId();
        try {
            client.listArtifactsInGroup("authTestGroupId");
            client.createArtifact("authTestGroupId", artifactId, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes()));
            TestUtils.retry(() -> client.getArtifactMetaData("authTestGroupId", artifactId));
            Assertions.assertNotNull((Object)client.getLatestArtifact("authTestGroupId", artifactId));
            Rule ruleConfig = new Rule();
            ruleConfig.setType(RuleType.VALIDITY);
            ruleConfig.setConfig(ValidityLevel.NONE.name());
            client.createArtifactRule("authTestGroupId", artifactId, ruleConfig);
            adminClient.createGlobalRule(ruleConfig);
        }
        finally {
            client.deleteArtifact("authTestGroupId", artifactId);
        }
    }

    @Test
    public void testAdminRoleBasicAuthWrongCreds() throws Exception {
        BasicAuth auth = new BasicAuth(JWKSMockServer.WRONG_CREDS_CLIENT_ID, UUID.randomUUID().toString());
        RegistryClient client = this.createClient((Auth)auth);
        String artifactId = TestUtils.generateArtifactId();
        Assertions.assertThrows(NotAuthorizedException.class, () -> client.listArtifactsInGroup("authTestGroupId"));
        Assertions.assertThrows(NotAuthorizedException.class, () -> client.createArtifact("authTestGroupId", artifactId, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes())));
    }

    @Test
    public void testOwnerOnlyAuthorization() throws Exception {
        OidcAuth authDev = new OidcAuth(this.httpClient, JWKSMockServer.DEVELOPER_CLIENT_ID, "test1");
        RegistryClient clientDev = this.createClient((Auth)authDev);
        OidcAuth authAdmin = new OidcAuth(this.httpClient, JWKSMockServer.ADMIN_CLIENT_ID, "test1");
        RegistryClient clientAdmin = this.createClient((Auth)authAdmin);
        String artifactId = TestUtils.generateArtifactId();
        clientAdmin.createArtifact("authTestGroupId", artifactId, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes()));
        EditableMetaData updatedMetaData = new EditableMetaData();
        updatedMetaData.setName("Updated Name");
        Assertions.assertThrows(ForbiddenException.class, () -> clientDev.updateArtifactMetaData("authTestGroupId", artifactId, updatedMetaData));
        clientAdmin.updateArtifactMetaData("authTestGroupId", artifactId, updatedMetaData);
        String artifactId2 = TestUtils.generateArtifactId();
        clientDev.createArtifact("authTestGroupId", artifactId2, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes()));
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig(CompatibilityLevel.BACKWARD.name());
        clientAdmin.createArtifactRule("authTestGroupId", artifactId2, rule);
    }

    @Test
    public void testGetArtifactOwner() throws Exception {
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.DEVELOPER_CLIENT_ID, "test1");
        RegistryClient client = this.createClient((Auth)auth);
        String groupId = "testGetArtifactOwner";
        String artifactId = this.generateArtifactId();
        String version = "1";
        String name = "testGetArtifactOwnerName";
        String description = "testGetArtifactOwnerDescription";
        InputStream stream = IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8));
        ArtifactMetaData created = client.createArtifact("testGetArtifactOwner", artifactId, "1", "JSON", IfExists.FAIL, Boolean.valueOf(false), "testGetArtifactOwnerName", "testGetArtifactOwnerDescription", stream);
        Assertions.assertNotNull((Object)created);
        Assertions.assertEquals((Object)"testGetArtifactOwner", (Object)created.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)created.getId());
        Assertions.assertEquals((Object)"1", (Object)created.getVersion());
        Assertions.assertEquals((Object)"developer-client", (Object)created.getCreatedBy());
        ArtifactOwner owner = client.getArtifactOwner("testGetArtifactOwner", artifactId);
        Assertions.assertEquals((Object)"developer-client", (Object)owner.getOwner());
    }

    @Test
    public void testUpdateArtifactOwner() throws Exception {
        OidcAuth auth = new OidcAuth(this.httpClient, JWKSMockServer.DEVELOPER_CLIENT_ID, "test1");
        RegistryClient client = this.createClient((Auth)auth);
        String groupId = "testUpdateArtifactOwner";
        String artifactId = this.generateArtifactId();
        String version = "1.0";
        String name = "testUpdateArtifactOwnerName";
        String description = "testUpdateArtifactOwnerDescription";
        InputStream stream = IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8));
        ArtifactMetaData created = client.createArtifact("testUpdateArtifactOwner", artifactId, "1.0", "JSON", IfExists.FAIL, Boolean.valueOf(false), "testUpdateArtifactOwnerName", "testUpdateArtifactOwnerDescription", stream);
        Assertions.assertNotNull((Object)created);
        Assertions.assertEquals((Object)"testUpdateArtifactOwner", (Object)created.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)created.getId());
        Assertions.assertEquals((Object)"1.0", (Object)created.getVersion());
        Assertions.assertEquals((Object)"developer-client", (Object)created.getCreatedBy());
        ArtifactOwner owner = client.getArtifactOwner("testUpdateArtifactOwner", artifactId);
        Assertions.assertEquals((Object)"developer-client", (Object)owner.getOwner());
        owner = new ArtifactOwner();
        owner.setOwner("developer-2-client");
        client.updateArtifactOwner("testUpdateArtifactOwner", artifactId, owner);
        owner = client.getArtifactOwner("testUpdateArtifactOwner", artifactId);
        Assertions.assertEquals((Object)"developer-2-client", (Object)owner.getOwner());
    }

    @Test
    public void testUpdateArtifactOwnerOnlyByOwner() throws Exception {
        OidcAuth auth_dev1 = new OidcAuth(this.httpClient, JWKSMockServer.DEVELOPER_CLIENT_ID, "test1");
        RegistryClient client_dev1 = this.createClient((Auth)auth_dev1);
        OidcAuth auth_dev2 = new OidcAuth(this.httpClient, JWKSMockServer.DEVELOPER_2_CLIENT_ID, "test1");
        RegistryClient client_dev2 = this.createClient((Auth)auth_dev2);
        String groupId = "testUpdateArtifactOwnerOnlyByOwner";
        String artifactId = this.generateArtifactId();
        String version = "1.0";
        String name = "testUpdateArtifactOwnerOnlyByOwnerName";
        String description = "testUpdateArtifactOwnerOnlyByOwnerDescription";
        InputStream stream = IoUtil.toStream((byte[])ARTIFACT_CONTENT.getBytes(StandardCharsets.UTF_8));
        ArtifactMetaData created = client_dev1.createArtifact("testUpdateArtifactOwnerOnlyByOwner", artifactId, "1.0", "JSON", IfExists.FAIL, Boolean.valueOf(false), "testUpdateArtifactOwnerOnlyByOwnerName", "testUpdateArtifactOwnerOnlyByOwnerDescription", stream);
        Assertions.assertNotNull((Object)created);
        Assertions.assertEquals((Object)"testUpdateArtifactOwnerOnlyByOwner", (Object)created.getGroupId());
        Assertions.assertEquals((Object)artifactId, (Object)created.getId());
        Assertions.assertEquals((Object)"1.0", (Object)created.getVersion());
        Assertions.assertEquals((Object)"developer-client", (Object)created.getCreatedBy());
        ArtifactOwner owner = client_dev1.getArtifactOwner("testUpdateArtifactOwnerOnlyByOwner", artifactId);
        Assertions.assertEquals((Object)"developer-client", (Object)owner.getOwner());
        Assertions.assertThrows(ForbiddenException.class, () -> {
            ArtifactOwner newOwner = new ArtifactOwner();
            newOwner.setOwner("developer-2-client");
            client_dev2.updateArtifactOwner("testUpdateArtifactOwnerOnlyByOwner", artifactId, newOwner);
        });
        owner = client_dev1.getArtifactOwner("testUpdateArtifactOwnerOnlyByOwner", artifactId);
        Assertions.assertEquals((Object)"developer-client", (Object)owner.getOwner());
    }
}

