/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaContent;
import io.apicurio.registry.ccompat.dto.SchemaId;
import io.apicurio.registry.ccompat.rest.CanonicalModeProfile;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.UUID;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=CanonicalModeProfile.class)
@Tag(value="slow")
public class CCompatCanonicalModeTest
extends AbstractResourceTestBase {
    private static final ObjectMapper MAPPER = new ObjectMapper();

    @Test
    public void canonicalModeEnabled() throws Exception {
        String SUBJECT = "testSchemaExpanded";
        String testSchemaExpanded = this.resourceToString("avro-expanded.avsc");
        SchemaContent schemaContent = new SchemaContent(testSchemaExpanded);
        Integer contentId1 = (Integer)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(MAPPER.writeValueAsString((Object)schemaContent)).post("/ccompat/v6/subjects/{subject}/versions", new Object[]{"testSchemaExpanded"})).then()).statusCode(200)).body("id", Matchers.allOf((Matcher)Matchers.isA(Integer.class), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(0))), new Object[0])).extract().body().jsonPath().get("id");
        Assertions.assertNotNull((Object)contentId1);
        this.waitForArtifact("testSchemaExpanded");
        SchemaContent minifiedSchemaContent = new SchemaContent(this.resourceToString("avro-minified.avsc"));
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(MAPPER.writeValueAsString((Object)minifiedSchemaContent)).post("/ccompat/v6/subjects/{subject}", new Object[]{"testSchemaExpanded"})).then()).statusCode(200);
        Assertions.assertEquals((Integer)contentId1, (Integer)((Integer)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(MAPPER.writeValueAsString((Object)minifiedSchemaContent)).post("/ccompat/v6/subjects/{subject}/versions", new Object[]{"testSchemaExpanded"})).then()).statusCode(200)).body("id", Matchers.allOf((Matcher)Matchers.isA(Integer.class), (Matcher)Matchers.equalTo((Object)contentId1)), new Object[0])).extract().body().jsonPath().get("id")));
    }

    @Test
    public void issue2902() throws Exception {
        String subject1 = UUID.randomUUID().toString();
        String schemaString1 = this.resourceToString("avro2-non-canonical.avsc");
        SchemaContent schemaContent = new SchemaContent(schemaString1);
        SchemaId schemaId1 = (SchemaId)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/vnd.schemaregistry+json").body(MAPPER.writeValueAsString((Object)schemaContent)).post("/ccompat/v6/subjects/{subject}/versions", new Object[]{subject1})).then()).statusCode(200)).extract().as(SchemaId.class);
        Assertions.assertNotNull((Object)schemaId1);
        Assertions.assertNotNull((Object)schemaId1.getId());
        Assertions.assertTrue((schemaId1.getId() > 0 ? 1 : 0) != 0);
        this.waitForArtifact(subject1);
        Schema schema1R = (Schema)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").get("/ccompat/v6/subjects/{subject}/versions/latest", new Object[]{subject1})).then()).statusCode(200)).extract().as(Schema.class);
        Assertions.assertEquals((Object)schemaString1, (Object)schema1R.getSchema());
        Assertions.assertEquals((int)schemaId1.getId(), (int)schema1R.getId());
    }
}

