/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ccompat.rest;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.ccompat.dto.Schema;
import io.apicurio.registry.ccompat.dto.SchemaContent;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.common.mapper.TypeRef;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import io.restassured.specification.RequestSpecification;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
public class SubjectVersionStringTest
extends AbstractResourceTestBase {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Test
    public void testSubjectVersionString() throws Exception {
        String SUBJECT = "test-cecc8b42-5ef5-4eff-82a5-96c1889839f9";
        String schema1 = "{\"type\" : \"string\"}";
        String schema2 = "{\"type\" : \"int\"}";
        ObjectMapper objectMapper = new ObjectMapper();
        SchemaContent schemaContent1 = new SchemaContent(schema1);
        SchemaContent schemaContent2 = new SchemaContent(schema2);
        Schema cid1 = (Schema)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().log().all()).when().contentType("application/vnd.schemaregistry+json").body(objectMapper.writeValueAsString((Object)schemaContent1)).post("/ccompat/v6/subjects/{subject}/versions", new Object[]{SUBJECT})).then()).statusCode(200)).extract().as(Schema.class);
        Assertions.assertNotNull((Object)cid1);
        this.waitForContentId(cid1.getId());
        List versions1 = (List)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().log().all()).when().get("/ccompat/v6/subjects/{subject}/versions", new Object[]{SUBJECT})).then()).statusCode(200)).extract().as((TypeRef)new TypeRef<List<Integer>>(){});
        Assertions.assertEquals((int)1, (int)versions1.size());
        Integer version1 = (Integer)versions1.get(0);
        Schema cid2 = (Schema)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().log().all()).when().contentType("application/vnd.schemaregistry+json").body(objectMapper.writeValueAsString((Object)schemaContent2)).post("/ccompat/v6/subjects/{subject}/versions", new Object[]{SUBJECT})).then()).statusCode(200)).extract().as(Schema.class);
        Assertions.assertNotNull((Object)cid2);
        this.waitForContentId(cid2.getId());
        List versions2 = (List)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().log().all()).when().get("/ccompat/v6/subjects/{subject}/versions", new Object[]{SUBJECT})).then()).statusCode(200)).extract().as((TypeRef)new TypeRef<List<Integer>>(){});
        Assertions.assertEquals((int)2, (int)versions2.size());
        versions2.removeAll(versions1);
        Integer version2 = (Integer)versions2.get(0);
        Assertions.assertEquals((Object)schema1, (Object)this.getSubjectVersion(SUBJECT, String.valueOf(version1)).getSchema());
        Assertions.assertEquals((Object)schema2, (Object)this.getSubjectVersion(SUBJECT, String.valueOf(version2)).getSchema());
        Assertions.assertEquals((Object)schema2, (Object)this.getSubjectVersion(SUBJECT, "latest").getSchema());
        Assertions.assertEquals((Object)schema2, (Object)this.getSubjectVersion(SUBJECT, "-1").getSchema());
        this.getSubjectVersionFail(SUBJECT, "-2", 404);
        this.getSubjectVersionFail(SUBJECT, "foo", 404);
    }

    private Schema getSubjectVersion(String subject, String version) {
        String response = ((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().log().all()).when().get("/ccompat/v6/subjects/{subject}/versions/{version}", new Object[]{subject, version})).then()).extract().asString();
        this.log.info("Response to get version {} of subject {} is: {}", new Object[]{version, subject, response});
        return (Schema)((ValidatableResponse)((ValidatableResponse)((Response)((RequestSpecification)RestAssured.given().log().all()).when().get("/ccompat/v6/subjects/{subject}/versions/{version}", new Object[]{subject, version})).then()).statusCode(200)).extract().as(Schema.class);
    }

    private void getSubjectVersionFail(String subject, String version, int expectedStatusCode) {
        ((ValidatableResponse)((Response)RestAssured.given().when().get("/ccompat/v6/subjects/{subject}/versions/{version}", new Object[]{subject, version})).then()).statusCode(expectedStatusCode);
    }
}

