/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.events.HttpEventsProfile;
import io.apicurio.registry.events.dto.RegistryEventType;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import java.io.InputStream;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
@TestProfile(value=HttpEventsProfile.class)
@Tag(value="slow")
public class HttpEventsTest
extends AbstractResourceTestBase {
    private static final Logger logger = LoggerFactory.getLogger(HttpEventsTest.class);
    HttpServer server;
    List<String> events;

    @BeforeAll
    public void setup() throws TimeoutException {
        CompletableFuture serverFuture = new CompletableFuture();
        this.events = new CopyOnWriteArrayList<String>();
        this.server = Vertx.vertx().createHttpServer(new HttpServerOptions().setPort(8976)).requestHandler(req -> {
            if (RegistryEventType.ARTIFACT_CREATED.cloudEventType().equals(req.headers().get("ce-type")) || RegistryEventType.ARTIFACT_UPDATED.cloudEventType().equals(req.headers().get("ce-type"))) {
                this.events.add(req.headers().get("ce-type"));
            }
            req.response().setStatusCode(200).end();
        }).listen(createdServer -> {
            if (createdServer.succeeded()) {
                serverFuture.complete((HttpServer)createdServer.result());
            } else {
                serverFuture.completeExceptionally(createdServer.cause());
            }
        });
        TestUtils.waitFor((String)"proxy is ready", (long)Duration.ofSeconds(1L).toMillis(), (long)Duration.ofSeconds(30L).toMillis(), serverFuture::isDone);
    }

    @Test
    @Timeout(value=65L, unit=TimeUnit.SECONDS)
    public void testHttpEvents() throws TimeoutException {
        InputStream jsonSchema = this.getClass().getResourceAsStream("/io/apicurio/registry/util/json-schema.json");
        Assertions.assertNotNull((Object)jsonSchema);
        String content = IoUtil.toString((InputStream)jsonSchema);
        String artifactId = TestUtils.generateArtifactId();
        try {
            this.createArtifact(artifactId, "JSON", content);
            this.createArtifactVersion(artifactId, "JSON", content);
        }
        catch (Exception ex) {
            logger.error("Error in http events test", (Throwable)ex);
            Assertions.fail((Throwable)ex);
        }
        TestUtils.waitFor((String)"Events to be produced", (long)200L, (long)6000L, () -> this.events.size() == 2);
        Assertions.assertLinesMatch(Arrays.asList(RegistryEventType.ARTIFACT_CREATED.cloudEventType(), RegistryEventType.ARTIFACT_UPDATED.cloudEventType()), this.events);
    }

    @AfterAll
    public void close() {
        if (this.server != null) {
            this.server.close();
        }
    }
}

