/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.events;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.events.KafkaEventsProfile;
import io.apicurio.registry.events.dto.RegistryEventType;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.io.InputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.common.serialization.Serdes;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

@QuarkusTest
@TestProfile(value=KafkaEventsProfile.class)
@Tag(value="docker")
@Disabled
public class KafkaEventsTest
extends AbstractResourceTestBase {
    @Test
    @Timeout(value=60L, unit=TimeUnit.SECONDS)
    public void testKafkaEvents() throws Exception {
        Consumer<UUID, String> kafkaConsumer = this.createConsumer(Serdes.UUID().deserializer().getClass().getName(), Serdes.String().deserializer().getClass().getName(), "registry-events");
        kafkaConsumer.subscribe(Collections.singletonList("registry-events"));
        InputStream jsonSchema = this.getClass().getResourceAsStream("/io/apicurio/registry/util/json-schema.json");
        Assertions.assertNotNull((Object)jsonSchema);
        String content = IoUtil.toString((InputStream)jsonSchema);
        String artifactId = TestUtils.generateArtifactId();
        try {
            this.createArtifact(artifactId, "JSON", content);
            this.createArtifactVersion(artifactId, "JSON", content);
        }
        catch (Exception e) {
            Assertions.fail((Throwable)e);
        }
        int expectedRecordCount = 2;
        ArrayList allRecords = new ArrayList();
        TestUtils.retry(() -> {
            kafkaConsumer.poll(Duration.ofMillis(50L)).iterator().forEachRemaining(allRecords::add);
            return allRecords.size() >= expectedRecordCount;
        });
        List events = allRecords.stream().map(r -> new String(r.headers().lastHeader("ce_type").value())).collect(Collectors.toList());
        Assertions.assertTrue((boolean)events.containsAll(Arrays.asList(RegistryEventType.ARTIFACT_CREATED.cloudEventType(), RegistryEventType.ARTIFACT_UPDATED.cloudEventType())));
    }

    private Consumer<UUID, String> createConsumer(String keyDeserializer, String valueDeserializer, String topicName) {
        Properties props = new Properties();
        props.putIfAbsent("bootstrap.servers", System.getProperty("bootstrap.servers", "localhost:9092"));
        props.putIfAbsent("group.id", "Consumer-" + topicName);
        props.putIfAbsent("enable.auto.commit", "true");
        props.putIfAbsent("auto.commit.interval.ms", "1000");
        props.putIfAbsent("auto.offset.reset", "earliest");
        props.putIfAbsent("key.deserializer", keyDeserializer);
        props.putIfAbsent("value.deserializer", valueDeserializer);
        return new KafkaConsumer(props);
    }
}

