/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ibmcompat;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.ibmcompat.SchemaRegistryRestAPIClient;
import org.junit.jupiter.api.Assertions;

public class IBMClientTest
extends AbstractResourceTestBase {
    private SchemaRegistryRestAPIClient buildClient() throws Exception {
        return new SchemaRegistryRestAPIClient(this.registryApiBaseUrl + "/ibmcompat/v1", "<API_KEY>", true);
    }

    public void testSmoke() throws Exception {
        SchemaRegistryRestAPIClient client = this.buildClient();
        String id = this.generateArtifactId();
        String content = "{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}";
        SchemaRegistryRestAPIClient.Tuple<?> tuple = client.create(id, content, true);
        Assertions.assertNotNull(tuple);
        Assertions.assertEquals((int)200, (int)tuple.status);
        Assertions.assertEquals((Object)content, tuple.result);
        tuple = client.create(id, content, false);
        Assertions.assertNotNull(tuple);
        Assertions.assertEquals((int)201, (int)tuple.status);
        Assertions.assertTrue((boolean)(tuple.result instanceof SchemaRegistryRestAPIClient.SchemaInfoResponse));
        SchemaRegistryRestAPIClient.SchemaInfoResponse sir = (SchemaRegistryRestAPIClient.SchemaInfoResponse)tuple.result;
        String schemaId = sir.id;
        Assertions.assertEquals((Object)id, (Object)schemaId);
        Assertions.assertTrue((boolean)sir.versions.stream().anyMatch(vr -> vr.id.equals("1")));
        Assertions.assertFalse((boolean)sir.versions.stream().anyMatch(vr -> vr.id.equals("2")));
        this.waitForArtifact(id);
        SchemaRegistryRestAPIClient.SchemaInfoResponse info = client.get(schemaId);
        Assertions.assertNotNull((Object)info);
        Assertions.assertEquals((Object)schemaId, (Object)info.id);
        Assertions.assertNotNull(info.versions);
        Assertions.assertTrue((boolean)info.versions.stream().anyMatch(vr -> vr.id.equals("1")));
        SchemaRegistryRestAPIClient.SchemaResponse response = client.get(schemaId, "1");
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)schemaId, (Object)response.id);
        Assertions.assertEquals((Object)content, (Object)response.definition);
        content = "{\"type\":\"record\",\"name\":\"myrecord2\",\"fields\":[{\"name\":\"f2\",\"type\":\"string\"}]}";
        tuple = client.update(id, content, true);
        Assertions.assertNotNull(tuple);
        Assertions.assertEquals((int)200, (int)tuple.status);
        Assertions.assertEquals((Object)content, tuple.result);
        tuple = client.update(id, content, false);
        Assertions.assertNotNull(tuple);
        Assertions.assertEquals((int)201, (int)tuple.status);
        Assertions.assertTrue((boolean)(tuple.result instanceof SchemaRegistryRestAPIClient.SchemaInfoResponse));
        sir = (SchemaRegistryRestAPIClient.SchemaInfoResponse)tuple.result;
        schemaId = sir.id;
        Assertions.assertEquals((Object)id, (Object)schemaId);
        Assertions.assertTrue((boolean)sir.versions.stream().anyMatch(vr -> vr.id.equals("1")));
        Assertions.assertTrue((boolean)sir.versions.stream().anyMatch(vr -> vr.id.equals("2")));
        response = client.get(schemaId, "2");
        Assertions.assertNotNull((Object)response);
        Assertions.assertEquals((Object)schemaId, (Object)response.id);
        Assertions.assertEquals((Object)content, (Object)response.definition);
        info = client.get(schemaId);
        Assertions.assertNotNull((Object)info);
        Assertions.assertEquals((Object)schemaId, (Object)info.id);
        Assertions.assertNotNull(info.versions);
        Assertions.assertTrue((boolean)info.versions.stream().anyMatch(vr -> vr.id.equals("1")));
        Assertions.assertTrue((boolean)info.versions.stream().anyMatch(vr -> vr.id.equals("2")));
    }
}

