/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ibmcompat;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.ibmcompat.IBMTestProfile;
import io.apicurio.registry.ibmcompat.model.SchemaListItem;
import io.apicurio.registry.ibmcompat.model.SchemaState;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.common.mapper.TypeRef;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;

@QuarkusTest
@TestProfile(value=IBMTestProfile.class)
@Tag(value="slow")
public class IBMCompatApiTest
extends AbstractResourceTestBase {
    @Test
    public void testCreateSchema() throws Exception {
        String schemaDefinition = this.resourceToString("avro.json").replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n");
        String schemaName = "testCreateSchema_userInfo";
        String schemaId = schemaName.toLowerCase();
        String versionName = "testversion_1.0.0";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body("{\"name\":\"" + schemaName + "\",\"version\":\"" + versionName + "\",\"definition\":\"" + schemaDefinition + "\"}").post("/ibmcompat/v1/schemas", new Object[0])).then()).statusCode(201)).body("name", Matchers.equalTo((Object)schemaName), new Object[0])).body("id", Matchers.equalTo((Object)schemaId), new Object[0])).body("enabled", Matchers.is((Object)true), new Object[0])).body("state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions.size()", Matchers.is((Object)1), new Object[0])).body("versions[0].name", Matchers.equalTo((Object)versionName), new Object[0])).body("versions[0].id", Matchers.is((Object)1), new Object[0])).body("versions[0].state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions[0].enabled", Matchers.is((Object)true), new Object[0])).body("versions[0].date", Matchers.notNullValue(), new Object[0]);
        this.waitForArtifact(schemaId);
        ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body("{\"name\":\"" + schemaName + "\",\"version\":\"" + versionName + "\",\"definition\":\"" + schemaDefinition + "\"}").post("/ibmcompat/v1/schemas", new Object[0])).then()).statusCode(409);
    }

    @Test
    public void testVerifySchema() throws Exception {
        String schemaDefinition = this.resourceToString("avro.json").replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n");
        String schemaName = "testVerifySchema_userInfo";
        String versionName = "testversion_1.0.0";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("verify", new Object[]{"true"}).contentType("application/json").body("{\"name\":\"" + schemaName + "\",\"version\":\"" + versionName + "\",\"definition\":\"" + schemaDefinition + "\"}").post("/ibmcompat/v1/schemas", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)("\"" + schemaDefinition + "\"")), new Matcher[0]);
    }

    @Test
    public void testGetSchemas() throws Exception {
        Optional<SchemaListItem> so;
        String artifactContent = this.resourceToString("avro.json");
        String schemaName = "testGetSchemas_userInfo";
        this.createArtifact(schemaName, "AVRO", artifactContent);
        int page = 0;
        while (true) {
            List schemas;
            if ((schemas = (List)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/ibmcompat/v1/schemas?page=" + page, new Object[0])).then()).statusCode(200)).extract().body().as((TypeRef)new TypeRef<List<SchemaListItem>>(){})).isEmpty()) {
                Assertions.fail((String)("No such schema present: " + schemaName));
            }
            if ((so = schemas.stream().filter(item -> schemaName.equals(item.getId())).findFirst()).isPresent()) break;
            ++page;
        }
        SchemaListItem schema = so.get();
        Assertions.assertEquals((Object)schemaName, (Object)schema.getName());
        Assertions.assertTrue((boolean)schema.isEnabled());
        Assertions.assertEquals((Object)SchemaState.StateEnum.ACTIVE, (Object)schema.getState().getState());
        Assertions.assertEquals((int)1, (Integer)schema.getLatest().getId());
        Assertions.assertEquals((Object)"userInfo", (Object)schema.getLatest().getName());
        Assertions.assertEquals((Object)true, (Object)schema.getLatest().getEnabled());
        Assertions.assertEquals((Object)SchemaState.StateEnum.ACTIVE, (Object)schema.getLatest().getState().getState());
    }

    @Test
    public void testGetSchema() throws Exception {
        String artifactContent = this.resourceToString("avro.json");
        String schemaName = "testGetSchema_userInfo";
        String schemaId = schemaName.toLowerCase();
        this.createArtifact(schemaId, "AVRO", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/ibmcompat/v1/schemas/" + schemaName, new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)schemaId), new Object[0])).body("id", Matchers.equalTo((Object)schemaId), new Object[0])).body("enabled", Matchers.is((Object)true), new Object[0])).body("state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions.size()", Matchers.is((Object)1), new Object[0])).body("versions[0].name", Matchers.equalTo((Object)"userInfo"), new Object[0])).body("versions[0].id", Matchers.is((Object)1), new Object[0])).body("versions[0].state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions[0].enabled", Matchers.is((Object)true), new Object[0])).body("versions[0].date", Matchers.notNullValue(), new Object[0]);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/ibmcompat/v1/schemas/" + schemaId, new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)schemaId), new Object[0])).body("id", Matchers.equalTo((Object)schemaId), new Object[0])).body("enabled", Matchers.is((Object)true), new Object[0])).body("state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions.size()", Matchers.is((Object)1), new Object[0])).body("versions[0].name", Matchers.equalTo((Object)"userInfo"), new Object[0])).body("versions[0].id", Matchers.is((Object)1), new Object[0])).body("versions[0].state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions[0].enabled", Matchers.is((Object)true), new Object[0])).body("versions[0].date", Matchers.notNullValue(), new Object[0]);
    }

    @Test
    public void testDeleteSchema() throws Exception {
        String artifactContent = this.resourceToString("avro.json");
        String schemaName = "testDeleteSchema_userInfo";
        String schemaId = schemaName.toLowerCase();
        this.createArtifact(schemaId, "AVRO", artifactContent);
        ((ValidatableResponse)((Response)RestAssured.given().when().delete("/ibmcompat/v1/schemas/" + schemaName, new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().get("/ibmcompat/v1/schemas/" + schemaName, new Object[0])).then()).statusCode(404));
    }

    @Test
    public void testPatchSchemaState() throws Exception {
        String artifactContent = this.resourceToString("avro.json");
        String version2SchemaDefinition = artifactContent.replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n");
        String schemaName = "testPatchSchemaState_userInfo";
        String schemaId = schemaName.toLowerCase();
        String version2Name = "testversion_2.0.0";
        this.createArtifact(schemaId, "AVRO", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body("{\"version\":\"" + version2Name + "\",\"definition\":\"" + version2SchemaDefinition + "\"}").post("/ibmcompat/v1/schemas/" + schemaName + "/versions", new Object[0])).then()).statusCode(201)).body("versions.size()", Matchers.equalTo((Object)2), new Object[0]);
        this.waitForVersion(schemaId, 2);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body("[{\"op\":\"replace\",\"path\":\"/enabled\",\"value\":false}]").patch("/ibmcompat/v1/schemas/" + schemaName, new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)schemaId), new Object[0])).body("id", Matchers.equalTo((Object)schemaId), new Object[0])).body("enabled", Matchers.is((Object)false), new Object[0])).body("state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions.size()", Matchers.is((Object)2), new Object[0])).body("versions[0].id", Matchers.is((Object)1), new Object[0])).body("versions[0].state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions[0].enabled", Matchers.is((Object)false), new Object[0])).body("versions[1].id", Matchers.is((Object)2), new Object[0])).body("versions[1].state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions[1].enabled", Matchers.is((Object)false), new Object[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body("[{\"op\":\"replace\",\"path\":\"/state\",\"value\":{\"state\":\"deprecated\",\"comment\":\"this schema is deprecated\"}}]").patch("/ibmcompat/v1/schemas/" + schemaName, new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)schemaId), new Object[0])).body("id", Matchers.equalTo((Object)schemaId), new Object[0])).body("enabled", Matchers.is((Object)true), new Object[0])).body("state.state", Matchers.equalTo((Object)"deprecated"), new Object[0])).body("state.comment", Matchers.equalTo((Object)"this schema is deprecated"), new Object[0])).body("versions.size()", Matchers.is((Object)2), new Object[0])).body("versions[0].id", Matchers.is((Object)1), new Object[0])).body("versions[0].state.state", Matchers.equalTo((Object)"deprecated"), new Object[0])).body("versions[0].enabled", Matchers.is((Object)true), new Object[0])).body("versions[1].id", Matchers.is((Object)2), new Object[0])).body("versions[1].state.state", Matchers.equalTo((Object)"deprecated"), new Object[0])).body("versions[1].enabled", Matchers.is((Object)true), new Object[0]));
    }

    @Test
    public void testGetSchemaVersion() throws Exception {
        String artifactContent = this.resourceToString("avro.json");
        String schemaName = "testGetSchemaVersion_userInfo";
        String schemaId = schemaName.toLowerCase();
        this.createArtifact(schemaId, "AVRO", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().get("/ibmcompat/v1/schemas/" + schemaName + "/versions/1", new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)schemaId), new Object[0])).body("id", Matchers.equalTo((Object)schemaId), new Object[0])).body("enabled", Matchers.is((Object)true), new Object[0])).body("state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("version.name", Matchers.equalTo((Object)"userInfo"), new Object[0])).body("version.id", Matchers.is((Object)1), new Object[0])).body("version.state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("version.enabled", Matchers.is((Object)true), new Object[0])).body("version.date", Matchers.notNullValue(), new Object[0])).body("definition", Matchers.equalTo((Object)artifactContent), new Object[0]);
    }

    @Test
    public void testCreateSchemaVersion() throws Exception {
        String artifactContent = this.resourceToString("avro.json");
        String newSchemaDefinition = artifactContent.replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n");
        String schemaName = "testCreateSchemaVersion_userInfo";
        String schemaId = schemaName.toLowerCase();
        String newVersionName = "testversion_2.0.0";
        this.createArtifact(schemaId, "AVRO", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body("{\"version\":\"" + newVersionName + "\",\"definition\":\"" + newSchemaDefinition + "\"}").post("/ibmcompat/v1/schemas/" + schemaName + "/versions", new Object[0])).then()).statusCode(201)).body("name", Matchers.equalTo((Object)schemaId), new Object[0])).body("id", Matchers.equalTo((Object)schemaId), new Object[0])).body("enabled", Matchers.equalTo((Object)true), new Object[0])).body("state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions.size()", Matchers.equalTo((Object)2), new Object[0])).body("versions[0].name", Matchers.equalTo((Object)"userInfo"), new Object[0])).body("versions[0].id", Matchers.is((Object)1), new Object[0])).body("versions[1].name", Matchers.equalTo((Object)newVersionName), new Object[0])).body("versions[1].id", Matchers.is((Object)2), new Object[0])).body("versions[1].state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions[1].enabled", Matchers.equalTo((Object)true), new Object[0])).body("versions[1].date", Matchers.notNullValue(), new Object[0]);
    }

    @Test
    public void testVerifySchemaVersion() throws Exception {
        String artifactContent = this.resourceToString("avro.json");
        String newSchemaDefinition = artifactContent.replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n");
        String schemaName = "testVerifySchemaVersion_userInfo";
        String schemaId = schemaName.toLowerCase();
        String newVersionName = "testversion_2.0.0";
        this.createArtifact(schemaId, "AVRO", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().queryParam("verify", new Object[]{true}).contentType("application/json").body("{\"version\":\"" + newVersionName + "\",\"definition\":\"" + newSchemaDefinition + "\"}").post("/ibmcompat/v1/schemas/" + schemaName + "/versions", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)("\"" + newSchemaDefinition + "\"")), new Matcher[0]);
    }

    @Test
    public void testDeleteSchemaVersion() throws Exception {
        String artifactContent = this.resourceToString("avro.json");
        String newSchemaDefinition = artifactContent.replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n");
        String schemaName = "testDeleteSchemaVersion_userInfo";
        String schemaId = schemaName.toLowerCase();
        String newVersionName = "testversion_2.0.0";
        this.createArtifact(schemaId, "AVRO", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body("{\"version\":\"" + newVersionName + "\",\"definition\":\"" + newSchemaDefinition + "\"}").post("/ibmcompat/v1/schemas/" + schemaName + "/versions", new Object[0])).then()).statusCode(201)).body("versions.size()", Matchers.equalTo((Object)2), new Object[0]);
        this.waitForVersion(schemaId, 2);
        ((ValidatableResponse)((Response)RestAssured.given().when().delete("/ibmcompat/v1/schemas/" + schemaName + "/versions/2", new Object[0])).then()).statusCode(204);
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().get("/ibmcompat/v1/schemas/" + schemaName + "/versions/2", new Object[0])).then()).statusCode(404));
    }

    @Test
    public void testPatchSchemaVersionState() throws Exception {
        String artifactContent = this.resourceToString("avro.json");
        String version2SchemaDefinition = artifactContent.replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n");
        String schemaName = "testPatchSchemaVersionState_userInfo";
        String schemaId = schemaName.toLowerCase();
        String version2Name = "testversion_2.0.0";
        this.createArtifact(schemaId, "AVRO", artifactContent);
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body("{\"version\":\"" + version2Name + "\",\"definition\":\"" + version2SchemaDefinition + "\"}").post("/ibmcompat/v1/schemas/" + schemaName + "/versions", new Object[0])).then()).statusCode(201)).body("versions.size()", Matchers.equalTo((Object)2), new Object[0]);
        this.waitForVersion(schemaId, 2);
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body("[{\"op\":\"replace\",\"path\":\"/enabled\",\"value\":false}]").patch("/ibmcompat/v1/schemas/" + schemaName + "/versions/2", new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)schemaId), new Object[0])).body("id", Matchers.equalTo((Object)schemaId), new Object[0])).body("enabled", Matchers.is((Object)true), new Object[0])).body("state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions.size()", Matchers.is((Object)2), new Object[0])).body("versions[0].id", Matchers.is((Object)1), new Object[0])).body("versions[0].state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions[0].enabled", Matchers.is((Object)true), new Object[0])).body("versions[1].id", Matchers.is((Object)2), new Object[0])).body("versions[1].state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions[1].enabled", Matchers.is((Object)false), new Object[0]);
        TestUtils.retry(() -> ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").body("[{\"op\":\"replace\",\"path\":\"/state\",\"value\":{\"state\":\"deprecated\",\"comment\":\"this version is deprecated\"}}]").patch("/ibmcompat/v1/schemas/" + schemaName + "/versions/1", new Object[0])).then()).statusCode(200)).body("name", Matchers.equalTo((Object)schemaId), new Object[0])).body("id", Matchers.equalTo((Object)schemaId), new Object[0])).body("enabled", Matchers.is((Object)true), new Object[0])).body("state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions.size()", Matchers.is((Object)2), new Object[0])).body("versions[0].id", Matchers.is((Object)1), new Object[0])).body("versions[0].state.state", Matchers.equalTo((Object)"deprecated"), new Object[0])).body("versions[0].state.comment", Matchers.equalTo((Object)"this version is deprecated"), new Object[0])).body("versions[0].enabled", Matchers.is((Object)true), new Object[0])).body("versions[1].id", Matchers.is((Object)2), new Object[0])).body("versions[1].state.state", Matchers.equalTo((Object)"active"), new Object[0])).body("versions[1].enabled", Matchers.is((Object)false), new Object[0]));
    }
}

