/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.ibmcompat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.jakarta.rs.json.JacksonJsonProvider;
import io.apicurio.registry.utils.JAXRSClientUtil;
import jakarta.ws.rs.ProcessingException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(using=JsonDeserializer.class)
class SchemaRegistryRestAPIClient {
    private static Logger logger = LoggerFactory.getLogger(SchemaRegistryRestAPIClient.class);
    private final String apiKey;
    private final WebTarget schemasEndpoint;
    private final WebTarget schemaVersionsEndpoint;
    private final WebTarget schemaEndpoint;
    private final WebTarget schemaVersionEndpoint;

    SchemaRegistryRestAPIClient(String url, String apikey, boolean skipSslValidation) throws Exception {
        this.apiKey = apikey;
        Client client = SchemaRegistryRestAPIClient.getJAXRSClient(skipSslValidation);
        this.schemasEndpoint = client.target(url).path("/schemas");
        this.schemaVersionsEndpoint = client.target(url).path("/schemas/{schemaid}/versions");
        this.schemaEndpoint = client.target(url).path("/schemas/{schemaid}");
        this.schemaVersionEndpoint = client.target(url).path("/schemas/{schemaid}/versions/{versionnum}");
        this.connectionTest(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Tuple<?> post(String schemaId, Response response) throws Exception {
        int status = response.getStatus();
        try {
            if (status == 201) {
                Tuple<SchemaInfoResponse> tuple = new Tuple<SchemaInfoResponse>(status, (SchemaInfoResponse)response.readEntity(SchemaInfoResponse.class));
                return tuple;
            }
            if (status == 200) {
                Tuple<String> tuple = new Tuple<String>(status, (String)response.readEntity(String.class));
                return tuple;
            }
            this.handleErrorResponse(response, schemaId, null);
        }
        finally {
            response.close();
        }
        logger.error("Unexpected response from Schema Registry. Status code {}", (Object)status);
        throw new Exception("HTTP response status: " + status);
    }

    Tuple<?> create(String schemaId, String schema, boolean verify) throws Exception {
        Response response = this.schemasEndpoint.queryParam("verify", new Object[]{verify}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)new NewSchema(schemaId, schema), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        return this.post(schemaId, response);
    }

    Tuple<?> update(String schemaId, String schema, boolean verify) throws Exception {
        Response response = this.schemaVersionsEndpoint.resolveTemplate("schemaid", (Object)schemaId).queryParam("verify", new Object[]{verify}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)new NewSchemaVersion(schema), (MediaType)MediaType.APPLICATION_JSON_TYPE));
        return this.post(schemaId, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SchemaResponse get(String schemaId, String version) throws Exception {
        Response response = this.getResponse(this.schemaVersionEndpoint.resolveTemplateFromEncoded("schemaid", (Object)schemaId).resolveTemplate("versionnum", (Object)version).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new String[]{"application/json"}));
        int status = response.getStatus();
        try {
            if (status == 200) {
                SchemaResponse schemaResponse = (SchemaResponse)response.readEntity(SchemaResponse.class);
                return schemaResponse;
            }
            this.handleErrorResponse(response, schemaId, version);
        }
        finally {
            response.close();
        }
        logger.error("Unexpected response from Schema Registry. Status code {}", (Object)status);
        throw new Exception("HTTP response status: " + status);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SchemaInfoResponse get(String schemaId) throws Exception {
        Response response = this.getResponse(this.schemaEndpoint.resolveTemplateFromEncoded("schemaid", (Object)schemaId).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).accept(new String[]{"application/json"}));
        int status = response.getStatus();
        try {
            if (status == 200) {
                SchemaInfoResponse schemaInfoResponse = (SchemaInfoResponse)response.readEntity(SchemaInfoResponse.class);
                return schemaInfoResponse;
            }
            this.handleErrorResponse(response, schemaId, null);
        }
        finally {
            response.close();
        }
        logger.error("Unexpected response from Schema Registry. Status code {}", (Object)status);
        throw new Exception("HTTP response status: " + status);
    }

    public void handleErrorResponse(Response response, String schemaId, String version) throws Exception {
        int status = response.getStatus();
        if (status == 404) {
            ErrorResponse jsonObject = (ErrorResponse)response.readEntity(ErrorResponse.class);
            if (jsonObject.message != null && (jsonObject.message.equals("Schema not found") || jsonObject.message.equals("Schema version not found"))) {
                if (version == null) {
                    throw new Exception("Schema id: " + schemaId);
                }
                throw new Exception("Schema id: " + schemaId + ", version id: " + version);
            }
        } else {
            if (status == 401 || status == 403) {
                logger.error("Auth failure. Status code {}", (Object)status);
                throw new Exception("HTTP response status: " + status);
            }
            if (status == 500) {
                ErrorResponse obj = (ErrorResponse)response.readEntity(ErrorResponse.class);
                logger.error("Server error from Schema Registry : {}", (Object)obj.message);
                throw new Exception("HTTP response status: " + status + " -- " + obj.message);
            }
            if (status > 500) {
                logger.error("Unexpected server error from Schema Registry. Status code {}", (Object)status);
                throw new Exception("HTTP response status: " + status);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionTest(String url) throws Exception {
        block7: {
            Response response = this.getResponse(this.schemasEndpoint.request());
            int status = response.getStatus();
            try {
                if (status == 200) {
                    logger.debug("Connected to Schema Registry {}", (Object)url);
                    break block7;
                }
                if (status == 401 || status == 403) {
                    logger.error("Failed to connect to Schema Registry. Status code {}", (Object)status);
                    throw new Exception("HTTP response status: " + status);
                }
                if (status == 500) {
                    ErrorResponse obj = (ErrorResponse)response.readEntity(ErrorResponse.class);
                    logger.error("Server error from Schema Registry : {}", (Object)obj.message);
                    throw new Exception("HTTP response status: " + status + " -- " + obj.message);
                }
                if (status > 500) {
                    logger.error("Server error from Schema Registry. Status code {}", (Object)status);
                    throw new Exception("HTTP response status: " + status);
                }
                logger.error("Unexpected response. Status code {}", (Object)status);
                throw new Exception("HTTP response status: " + status);
            }
            finally {
                response.close();
            }
        }
    }

    private Response getResponse(Invocation.Builder builder) throws Exception {
        try {
            return builder.header("Authorization", (Object)("Bearer " + this.apiKey)).get();
        }
        catch (ProcessingException pe) {
            logger.error("Failed to make API request", (Throwable)pe);
            Throwable cause = pe.getCause();
            throw new Exception(cause != null ? cause : pe);
        }
    }

    private static Client getJAXRSClient(boolean skipSSLValidation) throws KeyManagementException, NoSuchAlgorithmException {
        Client newClient = JAXRSClientUtil.getJAXRSClient((boolean)skipSSLValidation);
        newClient.register(JacksonJsonProvider.class);
        return newClient;
    }

    static class Tuple<T> {
        int status;
        T result;

        Tuple(int status, T result) {
            this.status = status;
            this.result = result;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class SchemaInfoResponse {
        @JsonProperty
        String id;
        @JsonProperty
        String name;
        @JsonProperty
        StateResponse state;
        @JsonProperty
        boolean enabled;
        @JsonProperty
        List<VersionResponse> versions = new ArrayList<VersionResponse>();
        @JsonProperty
        List<String> topics = new ArrayList<String>();

        SchemaInfoResponse() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class NewSchema
    extends NewSchemaVersion {
        @JsonProperty
        String name;

        public NewSchema() {
        }

        public NewSchema(String name, String definition) {
            super(definition);
            this.name = name;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class NewSchemaVersion {
        @JsonProperty
        String definition;

        public NewSchemaVersion() {
        }

        public NewSchemaVersion(String definition) {
            this.definition = definition;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class SchemaResponse {
        @JsonProperty
        String id;
        @JsonProperty
        VersionResponse version;
        @JsonProperty
        String name;
        @JsonProperty
        StateResponse state;
        @JsonProperty
        boolean enabled;
        @JsonProperty
        String definition;

        SchemaResponse() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class ErrorResponse {
        @JsonProperty
        String message;

        ErrorResponse() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class StateResponse {
        @JsonProperty
        String state;
        @JsonProperty
        String comment;

        StateResponse() {
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class VersionResponse {
        @JsonProperty
        String id;
        @JsonProperty
        String name;
        @JsonProperty
        StateResponse state;
        @JsonProperty
        boolean enabled;

        VersionResponse() {
        }
    }
}

