/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.limits;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.limits.LimitsTestProfile;
import io.apicurio.registry.rest.client.exception.LimitExceededException;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfEnvironmentVariable;

@QuarkusTest
@TestProfile(value=LimitsTestProfile.class)
@DisabledIfEnvironmentVariable(named="CURRENT_ENV", matches=".*mas.*")
@Tag(value="slow")
public class LimitsTest
extends AbstractResourceTestBase {
    @Test
    public void testLimitsNoMultitenancy() throws Exception {
        InputStream jsonSchema = this.getClass().getResourceAsStream("/io/apicurio/registry/util/json-schema.json");
        Assertions.assertNotNull((Object)jsonSchema);
        String content = IoUtil.toString((InputStream)jsonSchema);
        String artifactId = TestUtils.generateArtifactId();
        this.createArtifact(artifactId, "JSON", content);
        this.createArtifactVersion(artifactId, "JSON", content);
        EditableMetaData meta = new EditableMetaData();
        meta.setName(StringUtils.repeat((char)'a', (int)512));
        meta.setDescription(StringUtils.repeat((char)'a', (int)1024));
        String fourBytesText = StringUtils.repeat((char)'a', (int)4);
        meta.setProperties(Map.of(StringUtils.repeat((char)'a', (int)4), fourBytesText, StringUtils.repeat((char)'b', (int)4), fourBytesText));
        meta.setLabels(Arrays.asList(fourBytesText, fourBytesText));
        this.clientV2.updateArtifactVersionMetaData(null, artifactId, "1", meta);
        EditableMetaData invalidmeta = new EditableMetaData();
        invalidmeta.setName(StringUtils.repeat((char)'a', (int)513));
        invalidmeta.setDescription(StringUtils.repeat((char)'a', (int)1025));
        String fiveBytesText = StringUtils.repeat((char)'a', (int)5);
        invalidmeta.setProperties(Map.of(StringUtils.repeat((char)'a', (int)5), fiveBytesText, StringUtils.repeat((char)'b', (int)5), fiveBytesText));
        invalidmeta.setLabels(Arrays.asList(fiveBytesText, fiveBytesText));
        Assertions.assertThrows(LimitExceededException.class, () -> this.clientV2.updateArtifactVersionMetaData(null, artifactId, "1", invalidmeta));
        Assertions.assertThrows(LimitExceededException.class, () -> this.clientV2.createArtifact(null, artifactId, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes())));
    }
}

