/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt;

import io.apicurio.common.apps.multitenancy.TenantManagerService;
import io.apicurio.common.apps.multitenancy.exceptions.TenantNotAuthorizedException;
import io.apicurio.common.apps.multitenancy.exceptions.TenantNotFoundException;
import io.apicurio.tenantmanager.api.datamodel.ApicurioTenant;
import io.quarkus.test.Mock;
import io.vertx.core.impl.ConcurrentHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Mock
public class MockTenantMetadataService
extends TenantManagerService {
    private static final Map<String, ApicurioTenant> cache = new ConcurrentHashMap<String, ApicurioTenant>();
    private static final Set<String> unauthorizedList = new ConcurrentHashSet();

    public ApicurioTenant getTenant(String tenantId) throws TenantNotFoundException {
        if (unauthorizedList.contains(tenantId)) {
            throw new TenantNotAuthorizedException("Tenant not authorized");
        }
        ApicurioTenant tenant = cache.get(tenantId);
        if (tenant == null) {
            throw new TenantNotFoundException("not found " + tenantId);
        }
        return tenant;
    }

    public void createTenant(ApicurioTenant tenant) {
        System.out.println("Creating tenant " + tenant.getTenantId());
        cache.put(tenant.getTenantId(), tenant);
    }

    public void addToUnauthorizedList(String tenantId) {
        unauthorizedList.add(tenantId);
    }
}

