/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.mt.MockTenantMetadataService;
import io.apicurio.registry.mt.MultitenancyNoAuthTestProfile;
import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.AdminClientFactory;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.client.exception.ArtifactNotFoundException;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.SearchedArtifact;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.TestUtils;
import io.apicurio.rest.client.auth.exception.ForbiddenException;
import io.apicurio.tenantmanager.api.datamodel.ApicurioTenant;
import io.apicurio.tenantmanager.api.datamodel.TenantStatusValue;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
@TestProfile(value=MultitenancyNoAuthTestProfile.class)
@Tag(value="slow")
public class MultitenancyNoAuthTest
extends AbstractRegistryTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultitenancyNoAuthTest.class);
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    MockTenantMetadataService tenantMetadataService;
    @ConfigProperty(name="quarkus.http.test-port")
    public int testPort;

    @Test
    public void testTenantErrorExceptions() throws Exception {
        if (!this.storage.supportsMultiTenancy()) {
            throw new TestAbortedException("Multitenancy not supported - aborting test");
        }
        String tenantId1 = UUID.randomUUID().toString();
        String tenantId2 = UUID.randomUUID().toString();
        this.tenantMetadataService.addToUnauthorizedList(tenantId2);
        String tenant1BaseUrl = "http://localhost:" + this.testPort + "/t/" + tenantId1;
        String tenant2BaseUrl = "http://localhost:" + this.testPort + "/t/" + tenantId2;
        AdminClient clientTenant1 = AdminClientFactory.create((String)tenant1BaseUrl);
        AdminClient clientTenant2 = AdminClientFactory.create((String)tenant2BaseUrl);
        Assertions.assertThrows(ForbiddenException.class, () -> clientTenant1.listGlobalRules());
        Assertions.assertThrows(ForbiddenException.class, () -> clientTenant2.listGlobalRules());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultitenantRegistry() throws Exception {
        if (!this.storage.supportsMultiTenancy()) {
            throw new TestAbortedException("Multitenancy not supported - aborting test");
        }
        String tenantId1 = UUID.randomUUID().toString();
        ApicurioTenant tenant1 = new ApicurioTenant();
        tenant1.setTenantId(tenantId1);
        tenant1.setOrganizationId("aaa");
        tenant1.setStatus(TenantStatusValue.READY);
        this.tenantMetadataService.createTenant(tenant1);
        String tenantId2 = UUID.randomUUID().toString();
        ApicurioTenant tenant2 = new ApicurioTenant();
        tenant2.setTenantId(tenantId2);
        tenant2.setOrganizationId("bbb");
        tenant2.setStatus(TenantStatusValue.READY);
        this.tenantMetadataService.createTenant(tenant2);
        String tenant1BaseUrl = "http://localhost:" + this.testPort + "/t/" + tenantId1;
        String tenant2BaseUrl = "http://localhost:" + this.testPort + "/t/" + tenantId2;
        AdminClient adminClientTenant1 = AdminClientFactory.create((String)tenant1BaseUrl);
        AdminClient adminClientTenant2 = AdminClientFactory.create((String)tenant2BaseUrl);
        RegistryClient clientTenant1 = RegistryClientFactory.create((String)tenant1BaseUrl);
        RegistryClient clientTenant2 = RegistryClientFactory.create((String)tenant2BaseUrl);
        SchemaRegistryClient cclientTenant1 = this.createConfluentClient(tenant1BaseUrl);
        SchemaRegistryClient cclientTenant2 = this.createConfluentClient(tenant2BaseUrl);
        try {
            this.tenantOperations(adminClientTenant1, clientTenant1, cclientTenant1, tenant1BaseUrl);
            try {
                this.tenantOperations(adminClientTenant2, clientTenant2, cclientTenant2, tenant2BaseUrl);
            }
            finally {
                this.cleanTenantArtifacts(clientTenant2);
            }
        }
        finally {
            this.cleanTenantArtifacts(clientTenant1);
        }
    }

    private void tenantOperations(AdminClient adminClient, RegistryClient client, SchemaRegistryClient cclient, String baseUrl) throws Exception {
        Assertions.assertTrue((client.listArtifactsInGroup(null).getCount() == 0 ? 1 : 0) != 0);
        String artifactId = TestUtils.generateArtifactId();
        ArtifactMetaData meta = client.createArtifact(null, artifactId, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes()));
        TestUtils.retry(() -> client.getContentByGlobalId(meta.getGlobalId().longValue()));
        Assertions.assertNotNull((Object)client.getLatestArtifact(meta.getGroupId(), meta.getId()));
        Assertions.assertTrue((client.listArtifactsInGroup(null).getCount() == 1 ? 1 : 0) != 0);
        Rule ruleConfig = new Rule();
        ruleConfig.setType(RuleType.VALIDITY);
        ruleConfig.setConfig("NONE");
        client.createArtifactRule(meta.getGroupId(), meta.getId(), ruleConfig);
        adminClient.createGlobalRule(ruleConfig);
        String subject = TestUtils.generateArtifactId();
        AvroSchema schema1 = new AvroSchema("{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}");
        int id1 = cclient.register(subject, (ParsedSchema)schema1);
        cclient.reset();
        TestUtils.retry(() -> cclient.getSchemaById(id1));
        String schemaDefinition = this.resourceToString("avro.json").replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n");
        String schemaName = "testVerifySchema_userInfo";
        String versionName = "testversion_1.0.0";
        ((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().baseUri(baseUrl).when().queryParam("verify", new Object[]{"true"}).contentType("application/json").body("{\"name\":\"" + schemaName + "\",\"version\":\"" + versionName + "\",\"definition\":\"" + schemaDefinition + "\"}").post("/apis/ibmcompat/v1/schemas", new Object[0])).then()).statusCode(200)).body(Matchers.equalTo((Object)("\"" + schemaDefinition + "\"")), new Matcher[0]);
    }

    private void cleanTenantArtifacts(RegistryClient client) throws Exception {
        List artifacts = client.listArtifactsInGroup(null).getArtifacts();
        for (SearchedArtifact artifact : artifacts) {
            try {
                client.deleteArtifact(artifact.getGroupId(), artifact.getId());
            }
            catch (ArtifactNotFoundException e) {
                LOGGER.info(e.getMessage());
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        TestUtils.retry(() -> Assertions.assertTrue((client.listArtifactsInGroup(null).getCount() == 0 ? 1 : 0) != 0));
    }

    private SchemaRegistryClient createConfluentClient(String baseUrl) {
        List<SchemaProvider> schemaProviders = Arrays.asList(new JsonSchemaProvider(), new AvroSchemaProvider(), new ProtobufSchemaProvider());
        return new CachedSchemaRegistryClient(new RestService(baseUrl + "/apis/ccompat/v6"), 3, schemaProviders, null, null);
    }
}

