/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt.auth;

import io.apicurio.common.apps.config.Info;
import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.mt.MockTenantMetadataService;
import io.apicurio.registry.mt.MultitenancyNoAuthTest;
import io.apicurio.registry.rest.client.AdminClient;
import io.apicurio.registry.rest.client.AdminClientFactory;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.client.exception.ArtifactNotFoundException;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.rest.v2.beans.SearchedArtifact;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.JWKSMockServer;
import io.apicurio.registry.utils.tests.MultitenancyAuthTestProfile;
import io.apicurio.registry.utils.tests.TestUtils;
import io.apicurio.rest.client.auth.Auth;
import io.apicurio.rest.client.auth.BasicAuth;
import io.apicurio.rest.client.auth.OidcAuth;
import io.apicurio.rest.client.auth.exception.AuthErrorHandler;
import io.apicurio.rest.client.auth.exception.ForbiddenException;
import io.apicurio.rest.client.auth.exception.NotAuthorizedException;
import io.apicurio.rest.client.error.RestClientErrorHandler;
import io.apicurio.rest.client.spi.ApicurioHttpClient;
import io.apicurio.rest.client.spi.ApicurioHttpClientFactory;
import io.apicurio.tenantmanager.api.datamodel.ApicurioTenant;
import io.apicurio.tenantmanager.api.datamodel.TenantStatusValue;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.opentest4j.TestAbortedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@QuarkusTest
@TestProfile(value=MultitenancyAuthTestProfile.class)
@Tag(value="slow")
public class MultitenancyAuthTest
extends AbstractRegistryTestBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultitenancyNoAuthTest.class);
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    MockTenantMetadataService tenantMetadataService;
    @ConfigProperty(name="registry.auth.token.endpoint")
    @Info(category="auth", description="Auth token endpoint", availableSince="2.1.0.Final")
    String authServerUrlConfigured;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultitenantRegistry() throws Exception {
        if (!this.storage.supportsMultiTenancy()) {
            throw new TestAbortedException("Multitenancy not supported - aborting test");
        }
        String tenantId1 = UUID.randomUUID().toString();
        ApicurioTenant tenant1 = new ApicurioTenant();
        tenant1.setTenantId(tenantId1);
        tenant1.setOrganizationId("aaa");
        tenant1.setStatus(TenantStatusValue.READY);
        this.tenantMetadataService.createTenant(tenant1);
        String tenantId2 = UUID.randomUUID().toString();
        ApicurioTenant tenant2 = new ApicurioTenant();
        tenant2.setTenantId(tenantId2);
        tenant2.setOrganizationId("bbb");
        tenant2.setStatus(TenantStatusValue.READY);
        this.tenantMetadataService.createTenant(tenant2);
        String tenant1BaseUrl = "http://localhost:" + this.testPort + "/t/" + tenantId1;
        String tenant2BaseUrl = "http://localhost:" + this.testPort + "/t/" + tenantId2;
        BasicAuth basicAutha = new BasicAuth(JWKSMockServer.BASIC_USER_A, JWKSMockServer.BASIC_PASSWORD);
        BasicAuth basicAuthb = new BasicAuth(JWKSMockServer.BASIC_USER_B, JWKSMockServer.BASIC_PASSWORD);
        AdminClient adminClientTenant1 = AdminClientFactory.create((String)tenant1BaseUrl, Collections.emptyMap(), (Auth)basicAutha);
        AdminClient adminClientTenant2 = AdminClientFactory.create((String)tenant2BaseUrl, Collections.emptyMap(), (Auth)basicAuthb);
        RegistryClient clientTenant1 = RegistryClientFactory.create((String)tenant1BaseUrl, Collections.emptyMap(), (Auth)basicAutha);
        RegistryClient clientTenant2 = RegistryClientFactory.create((String)tenant2BaseUrl, Collections.emptyMap(), (Auth)basicAuthb);
        clientTenant1.setConfigProperty("registry.auth.basic-auth-client-credentials.enabled", "false");
        Assertions.assertThrows(NotAuthorizedException.class, () -> this.tenantOperations(adminClientTenant1, clientTenant1));
        try {
            this.tenantOperations(adminClientTenant2, clientTenant2);
        }
        finally {
            this.cleanTenantArtifacts(clientTenant2);
        }
        ApicurioHttpClient httpClient = ApicurioHttpClientFactory.create((String)this.authServerUrlConfigured, (RestClientErrorHandler)new AuthErrorHandler());
        OidcAuth bearerAuth = new OidcAuth(httpClient, JWKSMockServer.BASIC_USER_A, JWKSMockServer.BASIC_PASSWORD);
        RegistryClient clientWithBearerAuth = RegistryClientFactory.create((String)tenant1BaseUrl, Collections.emptyMap(), (Auth)bearerAuth);
        clientWithBearerAuth.setConfigProperty("registry.auth.basic-auth-client-credentials.enabled", "true");
        try {
            this.tenantOperations(adminClientTenant1, clientTenant1);
        }
        finally {
            this.cleanTenantArtifacts(clientTenant1);
        }
        AdminClient adminClientTenant1Authb = AdminClientFactory.create((String)tenant1BaseUrl, Collections.emptyMap(), (Auth)basicAuthb);
        AdminClient adminClientTenant2Autha = AdminClientFactory.create((String)tenant2BaseUrl, Collections.emptyMap(), (Auth)basicAutha);
        RegistryClient clientTenant1Authb = RegistryClientFactory.create((String)tenant1BaseUrl, Collections.emptyMap(), (Auth)basicAuthb);
        RegistryClient clientTenant2Autha = RegistryClientFactory.create((String)tenant2BaseUrl, Collections.emptyMap(), (Auth)basicAutha);
        Assertions.assertThrows(ForbiddenException.class, () -> this.tenantOperations(adminClientTenant1Authb, clientTenant1Authb));
        Assertions.assertThrows(ForbiddenException.class, () -> this.tenantOperations(adminClientTenant2Autha, clientTenant2Autha));
    }

    private void tenantOperations(AdminClient adminClient, RegistryClient client) throws Exception {
        Assertions.assertTrue((client.listArtifactsInGroup(null).getCount() == 0 ? 1 : 0) != 0);
        String artifactId = TestUtils.generateArtifactId();
        ArtifactMetaData meta = client.createArtifact(null, artifactId, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes()));
        TestUtils.retry(() -> client.getContentByGlobalId(meta.getGlobalId().longValue()));
        Assertions.assertNotNull((Object)client.getLatestArtifact(meta.getGroupId(), meta.getId()));
        Assertions.assertTrue((client.listArtifactsInGroup(null).getCount() == 1 ? 1 : 0) != 0);
        Rule ruleConfig = new Rule();
        ruleConfig.setType(RuleType.VALIDITY);
        ruleConfig.setConfig("NONE");
        client.createArtifactRule(meta.getGroupId(), meta.getId(), ruleConfig);
        adminClient.createGlobalRule(ruleConfig);
    }

    private void cleanTenantArtifacts(RegistryClient client) throws Exception {
        List artifacts = client.listArtifactsInGroup(null).getArtifacts();
        for (SearchedArtifact artifact : artifacts) {
            try {
                client.deleteArtifact(artifact.getGroupId(), artifact.getId());
            }
            catch (ArtifactNotFoundException e) {
                LOGGER.info(e.getMessage());
            }
            catch (Exception e) {
                LOGGER.error("", (Throwable)e);
            }
        }
        TestUtils.retry(() -> Assertions.assertTrue((client.listArtifactsInGroup(null).getCount() == 0 ? 1 : 0) != 0));
    }
}

