/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.mt.limits;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.mt.MockTenantMetadataService;
import io.apicurio.registry.mt.limits.MultitenancyLimitsTestProfile;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.RegistryClientFactory;
import io.apicurio.registry.rest.client.exception.LimitExceededException;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.storage.RegistryStorage;
import io.apicurio.registry.types.Current;
import io.apicurio.registry.utils.tests.TestUtils;
import io.apicurio.tenantmanager.api.datamodel.ApicurioTenant;
import io.apicurio.tenantmanager.api.datamodel.TenantStatusValue;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.TestProfile;
import jakarta.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Map;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.opentest4j.TestAbortedException;

@QuarkusTest
@TestProfile(value=MultitenancyLimitsTestProfile.class)
@Tag(value="slow")
public class MultitenancyLimitsTest
extends AbstractRegistryTestBase {
    @Inject
    @Current
    RegistryStorage storage;
    @Inject
    MockTenantMetadataService tenantMetadataService;

    @Test
    public void testMultitenantRegistry() throws Exception {
        if (!this.storage.supportsMultiTenancy()) {
            throw new TestAbortedException("Multitenancy not supported - aborting test");
        }
        String tenantId1 = UUID.randomUUID().toString();
        ApicurioTenant tenant1 = new ApicurioTenant();
        tenant1.setTenantId(tenantId1);
        tenant1.setOrganizationId("aaa");
        tenant1.setStatus(TenantStatusValue.READY);
        this.tenantMetadataService.createTenant(tenant1);
        String tenantId2 = UUID.randomUUID().toString();
        ApicurioTenant tenant2 = new ApicurioTenant();
        tenant2.setTenantId(tenantId2);
        tenant2.setOrganizationId("bbb");
        tenant2.setStatus(TenantStatusValue.READY);
        this.tenantMetadataService.createTenant(tenant2);
        RegistryClient clientTenant1 = RegistryClientFactory.create((String)("http://localhost:" + this.testPort + "/t/" + tenantId1 + "/apis/registry/v2"));
        RegistryClient clientTenant2 = RegistryClientFactory.create((String)("http://localhost:" + this.testPort + "/t/" + tenantId2 + "/apis/registry/v2"));
        this.checkTenantLimits(clientTenant1);
        this.checkTenantLimits(clientTenant2);
    }

    private void checkTenantLimits(RegistryClient client) throws Exception {
        Supplier<InputStream> jsonSchema = () -> this.getClass().getResourceAsStream("/io/apicurio/registry/util/json-schema.json");
        Assertions.assertNotNull(jsonSchema);
        String artifactId = TestUtils.generateArtifactId();
        client.createArtifact(null, artifactId, jsonSchema.get());
        client.updateArtifact(null, artifactId, jsonSchema.get());
        EditableMetaData meta = new EditableMetaData();
        meta.setName(StringUtils.repeat((char)'a', (int)512));
        meta.setDescription(StringUtils.repeat((char)'a', (int)1024));
        String fourBytesText = StringUtils.repeat((char)'a', (int)4);
        meta.setProperties(Map.of(StringUtils.repeat((char)'a', (int)4), fourBytesText, StringUtils.repeat((char)'b', (int)4), fourBytesText));
        meta.setLabels(Arrays.asList(fourBytesText, fourBytesText));
        client.updateArtifactVersionMetaData(null, artifactId, "1", meta);
        EditableMetaData invalidmeta = new EditableMetaData();
        invalidmeta.setName(StringUtils.repeat((char)'a', (int)513));
        invalidmeta.setDescription(StringUtils.repeat((char)'a', (int)1025));
        String fiveBytesText = StringUtils.repeat((char)'a', (int)5);
        invalidmeta.setProperties(Map.of(StringUtils.repeat((char)'a', (int)5), fiveBytesText, StringUtils.repeat((char)'b', (int)5), fiveBytesText));
        invalidmeta.setLabels(Arrays.asList(fiveBytesText, fiveBytesText));
        Assertions.assertThrows(LimitExceededException.class, () -> client.updateArtifactVersionMetaData(null, artifactId, "1", invalidmeta));
        Assertions.assertThrows(LimitExceededException.class, () -> client.createArtifact(null, artifactId, "JSON", (InputStream)new ByteArrayInputStream("{}".getBytes())));
    }
}

