/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.ArtifactSearchResults;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.SortBy;
import io.apicurio.registry.rest.v2.beans.SortOrder;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class ArtifactSearchTest
extends AbstractResourceTestBase {
    private static final String OPENAPI_CONTENT_TEMPLATE = "{\r\n    \"openapi\": \"3.0.2\",\r\n    \"info\": {\r\n        \"title\": \"TITLE\",\r\n        \"version\": \"1.0.0\",\r\n        \"description\": \"DESCRIPTION\"\r\n    }\r\n}";

    @Test
    void testCaseInsensitiveSearch() throws Exception {
        String groupId = "ArtifactSearchTest_testCaseInsensitiveSearch";
        this.clientV2.listArtifactsInGroup(groupId);
        String artifactId = UUID.randomUUID().toString();
        String title = "testCaseInsensitiveSearch";
        String description = "The quick brown FOX jumped over the Lazy dog.";
        String content = OPENAPI_CONTENT_TEMPLATE.replace("TITLE", title).replace("DESCRIPTION", description);
        ByteArrayInputStream artifactData = new ByteArrayInputStream(content.getBytes(StandardCharsets.UTF_8));
        ArtifactMetaData amd = this.clientV2.createArtifact(groupId, artifactId, "OPENAPI", (InputStream)artifactData);
        long id = amd.getGlobalId();
        this.waitForGlobalId(id);
        ArtifactSearchResults results = this.clientV2.searchArtifacts(groupId, title, null, null, null, SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
        Assertions.assertNotNull((Object)results);
        Assertions.assertEquals((int)1, (Integer)results.getCount());
        EditableMetaData metaData = new EditableMetaData();
        metaData.setName(title);
        metaData.setDescription(description);
        metaData.setLabels(Collections.singletonList("testCaseInsensitiveSearchLabel"));
        metaData.setProperties(Collections.singletonMap("testCaseInsensitiveSearchKey", "testCaseInsensitiveSearchValue"));
        this.clientV2.updateArtifactMetaData(groupId, artifactId, metaData);
        TestUtils.retry(() -> {
            ArtifactSearchResults ires = this.clientV2.searchArtifacts(groupId, null, null, List.of("testCaseInsensitiveSearchLabel"), null, SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)ires);
            Assertions.assertEquals((int)1, (Integer)ires.getCount());
            ires = this.clientV2.searchArtifacts(groupId, null, null, List.of("testCaseInsensitiveSearchLabel".toLowerCase()), null, SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)ires);
            Assertions.assertEquals((int)1, (Integer)ires.getCount());
            ires = this.clientV2.searchArtifacts(groupId, null, null, List.of("testCaseInsensitiveSearchLabel".toUpperCase()), null, SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)ires);
            Assertions.assertEquals((int)1, (Integer)ires.getCount());
            ires = this.clientV2.searchArtifacts(groupId, null, null, List.of("TESTCaseInsensitiveSEARCHLabel"), null, SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)ires);
            Assertions.assertEquals((int)1, (Integer)ires.getCount());
            ArtifactSearchResults propertiesSearch = this.clientV2.searchArtifacts(groupId, null, null, null, List.of("testCaseInsensitiveSearchKey:testCaseInsensitiveSearchValue"), SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)propertiesSearch);
            Assertions.assertEquals((int)1, (Integer)propertiesSearch.getCount());
            propertiesSearch = this.clientV2.searchArtifacts(groupId, null, null, null, List.of("testCaseInsensitiveSearchKey:testCaseInsensitiveSearchValue".toLowerCase()), SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)propertiesSearch);
            Assertions.assertEquals((int)1, (Integer)propertiesSearch.getCount());
            propertiesSearch = this.clientV2.searchArtifacts(groupId, null, null, null, List.of("testCaseInsensitiveSearchKey:testCaseInsensitiveSearchValue".toUpperCase()), SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)propertiesSearch);
            Assertions.assertEquals((int)1, (Integer)propertiesSearch.getCount());
            propertiesSearch = this.clientV2.searchArtifacts(groupId, null, null, null, List.of("TESTCaseInsensitiveSEARCHKey:TESTCaseInsensitiveSearchVALUE"), SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)propertiesSearch);
            Assertions.assertEquals((int)1, (Integer)propertiesSearch.getCount());
            ArtifactSearchResults propertiesKeySearch = this.clientV2.searchArtifacts(groupId, null, null, null, List.of("testCaseInsensitiveSearchKey"), SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)propertiesKeySearch);
            Assertions.assertEquals((int)1, (Integer)propertiesKeySearch.getCount());
            propertiesKeySearch = this.clientV2.searchArtifacts(groupId, null, null, null, List.of("testCaseInsensitiveSearchKey".toLowerCase()), SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)propertiesKeySearch);
            Assertions.assertEquals((int)1, (Integer)propertiesKeySearch.getCount());
            propertiesKeySearch = this.clientV2.searchArtifacts(groupId, null, null, null, List.of("testCaseInsensitiveSearchKey".toUpperCase()), SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)propertiesKeySearch);
            Assertions.assertEquals((int)1, (Integer)propertiesKeySearch.getCount());
            propertiesKeySearch = this.clientV2.searchArtifacts(groupId, null, null, null, List.of("TESTCaseInsensitiveSEARCHKey"), SortBy.name, SortOrder.asc, Integer.valueOf(0), Integer.valueOf(10));
            Assertions.assertNotNull((Object)propertiesKeySearch);
            Assertions.assertEquals((int)1, (Integer)propertiesSearch.getCount());
        });
    }
}

