/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.client.exception.ArtifactNotFoundException;
import io.apicurio.registry.rest.client.exception.RestClientException;
import io.apicurio.registry.rest.client.exception.VersionNotFoundException;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.rest.v2.beans.EditableMetaData;
import io.apicurio.registry.rest.v2.beans.UpdateState;
import io.apicurio.registry.rest.v2.beans.VersionMetaData;
import io.apicurio.registry.types.ArtifactState;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class ArtifactStateTest
extends AbstractResourceTestBase {
    private static final UpdateState toUpdateState(ArtifactState state) {
        UpdateState us = new UpdateState();
        us.setState(state);
        return us;
    }

    @Test
    public void testSmoke() throws Exception {
        String groupId = "ArtifactStateTest_testSmoke";
        String artifactId = this.generateArtifactId();
        ArtifactMetaData amd1 = this.clientV2.createArtifact(groupId, artifactId, "JSON", (InputStream)new ByteArrayInputStream("{\"type\": \"string\"}".getBytes(StandardCharsets.UTF_8)));
        this.waitForGlobalId(amd1.getGlobalId());
        ArtifactMetaData amd2 = this.clientV2.updateArtifact(groupId, artifactId, (InputStream)new ByteArrayInputStream("\"type\": \"int\"".getBytes(StandardCharsets.UTF_8)));
        this.waitForGlobalId(amd2.getGlobalId());
        ArtifactMetaData amd3 = this.clientV2.updateArtifact(groupId, artifactId, (InputStream)new ByteArrayInputStream("\"type\": \"float\"".getBytes(StandardCharsets.UTF_8)));
        this.waitForGlobalId(amd3.getGlobalId());
        ArtifactMetaData amd = this.clientV2.getArtifactMetaData(groupId, artifactId);
        Assertions.assertEquals((Object)"3", (Object)amd.getVersion());
        this.clientV2.updateArtifactState(groupId, artifactId, ArtifactStateTest.toUpdateState(ArtifactState.DISABLED));
        this.waitForVersionState(groupId, artifactId, "3", ArtifactState.DISABLED);
        VersionMetaData tvmd = this.clientV2.getArtifactVersionMetaData(groupId, artifactId, "3");
        Assertions.assertEquals((Object)"3", (Object)tvmd.getVersion());
        Assertions.assertEquals((Object)ArtifactState.DISABLED, (Object)tvmd.getState());
        ArtifactMetaData tamd = this.clientV2.getArtifactMetaData(groupId, artifactId);
        Assertions.assertEquals((Object)"2", (Object)tamd.getVersion());
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)tamd.getState());
        Assertions.assertNull((Object)tamd.getDescription());
        EditableMetaData emd = new EditableMetaData();
        String description = "Testing artifact state";
        emd.setDescription(description);
        Function<Exception, Integer> errorCodeExtractor = e -> ((RestClientException)e).getError().getErrorCode();
        TestUtils.assertClientError((String)VersionNotFoundException.class.getSimpleName(), (int)404, () -> this.clientV2.getArtifactVersion(groupId, artifactId, "3"), errorCodeExtractor);
        this.clientV2.updateArtifactVersionMetaData(groupId, artifactId, "3", emd);
        TestUtils.retry(() -> {
            VersionMetaData innerAvmd = this.clientV2.getArtifactVersionMetaData(groupId, artifactId, "3");
            Assertions.assertEquals((Object)"3", (Object)innerAvmd.getVersion());
            Assertions.assertEquals((Object)description, (Object)innerAvmd.getDescription());
            return null;
        });
        this.clientV2.updateArtifactVersionState(groupId, artifactId, "3", ArtifactStateTest.toUpdateState(ArtifactState.DEPRECATED));
        this.waitForVersionState(groupId, artifactId, "3", ArtifactState.DEPRECATED);
        tamd = this.clientV2.getArtifactMetaData(groupId, artifactId);
        Assertions.assertEquals((Object)"3", (Object)tamd.getVersion());
        Assertions.assertEquals((Object)ArtifactState.DEPRECATED, (Object)tamd.getState());
        Assertions.assertEquals((Object)tamd.getDescription(), (Object)description);
        InputStream latestArtifact = this.clientV2.getLatestArtifact(groupId, artifactId);
        Assertions.assertNotNull((Object)latestArtifact);
        latestArtifact.close();
        InputStream version = this.clientV2.getArtifactVersion(groupId, artifactId, "2");
        Assertions.assertNotNull((Object)version);
        version.close();
        this.clientV2.updateArtifactMetaData(groupId, artifactId, emd);
        TestUtils.retry(() -> {
            ArtifactMetaData innerAmd = this.clientV2.getArtifactMetaData(groupId, artifactId);
            Assertions.assertEquals((Object)"3", (Object)innerAmd.getVersion());
            Assertions.assertEquals((Object)description, (Object)innerAmd.getDescription());
            Assertions.assertEquals((Object)ArtifactState.DEPRECATED, (Object)innerAmd.getState());
            return null;
        });
        this.clientV2.updateArtifactVersionState(groupId, artifactId, "3", ArtifactStateTest.toUpdateState(ArtifactState.ENABLED));
        this.waitForVersionState(groupId, artifactId, "3", ArtifactState.ENABLED);
        TestUtils.retry(() -> {
            ArtifactMetaData innerAmd = this.clientV2.getArtifactMetaData(groupId, artifactId);
            Assertions.assertEquals((Object)"3", (Object)innerAmd.getVersion());
            Assertions.assertEquals((Object)description, (Object)innerAmd.getDescription());
            VersionMetaData innerVmd = this.clientV2.getArtifactVersionMetaData(groupId, artifactId, "1");
            Assertions.assertNull((Object)innerVmd.getDescription());
            return null;
        });
    }

    @Test
    void testEnableDisableArtifact() throws Exception {
        String groupId = "ArtifactStateTest_testEnableDisableArtifact";
        String artifactId = this.generateArtifactId();
        ArtifactMetaData md = this.clientV2.createArtifact(groupId, artifactId, "JSON", (InputStream)new ByteArrayInputStream("{\"type\": \"string\"}".getBytes(StandardCharsets.UTF_8)));
        TestUtils.retry(() -> {
            ArtifactMetaData actualMD = this.clientV2.getArtifactMetaData(groupId, artifactId);
            Assertions.assertEquals((Long)md.getGlobalId(), (Long)actualMD.getGlobalId());
        });
        UpdateState state = new UpdateState();
        state.setState(ArtifactState.DISABLED);
        this.clientV2.updateArtifactState(groupId, artifactId, state);
        this.waitForVersionState(groupId, artifactId, md.getVersion(), ArtifactState.DISABLED);
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(404));
        TestUtils.retry(() -> {
            try {
                ArtifactMetaData actualMD = this.clientV2.getArtifactMetaData(groupId, artifactId);
                Assertions.fail((String)"ArtifactNotFoundException expected");
            }
            catch (ArtifactNotFoundException actualMD) {
                // empty catch block
            }
            VersionMetaData vmd = this.clientV2.getArtifactVersionMetaData(groupId, artifactId, String.valueOf(md.getVersion()));
            Assertions.assertEquals((Object)ArtifactState.DISABLED, (Object)vmd.getState());
        });
        state.setState(ArtifactState.ENABLED);
        this.clientV2.updateArtifactVersionState(groupId, artifactId, md.getVersion(), state);
        this.waitForVersionState(groupId, artifactId, md.getVersion(), ArtifactState.ENABLED);
        ArtifactMetaData amd = this.clientV2.getArtifactMetaData(groupId, artifactId);
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)amd.getState());
        VersionMetaData vmd = this.clientV2.getArtifactVersionMetaData(groupId, artifactId, String.valueOf(md.getVersion()));
        Assertions.assertEquals((Object)ArtifactState.ENABLED, (Object)vmd.getState());
    }

    @Test
    void testDeprecateDisableArtifact() throws Exception {
        String groupId = "ArtifactStateTest_testDeprecateDisableArtifact";
        String artifactId = this.generateArtifactId();
        ArtifactMetaData md = this.clientV2.createArtifact(groupId, artifactId, "JSON", (InputStream)new ByteArrayInputStream("{\"type\": \"string\"}".getBytes(StandardCharsets.UTF_8)));
        TestUtils.retry(() -> {
            ArtifactMetaData actualMD = this.clientV2.getArtifactMetaData(groupId, artifactId);
            Assertions.assertEquals((Long)md.getGlobalId(), (Long)actualMD.getGlobalId());
        });
        UpdateState state = new UpdateState();
        state.setState(ArtifactState.DEPRECATED);
        this.clientV2.updateArtifactState(groupId, artifactId, state);
        this.waitForVersionState(groupId, artifactId, md.getVersion(), ArtifactState.DEPRECATED);
        TestUtils.retry(() -> {
            ArtifactMetaData actualMD = this.clientV2.getArtifactMetaData(groupId, artifactId);
            Assertions.assertEquals((Long)md.getGlobalId(), (Long)actualMD.getGlobalId());
            Assertions.assertEquals((Object)ArtifactState.DEPRECATED, (Object)actualMD.getState());
        });
        state.setState(ArtifactState.DISABLED);
        this.clientV2.updateArtifactState(groupId, artifactId, state);
        this.waitForVersionState(groupId, artifactId, md.getVersion(), ArtifactState.DISABLED);
        TestUtils.retry(() -> ((ValidatableResponse)((Response)RestAssured.given().when().contentType("application/json").pathParam("groupId", (Object)groupId).pathParam("artifactId", (Object)artifactId).get("/registry/v2/groups/{groupId}/artifacts/{artifactId}/meta", new Object[0])).then()).statusCode(404));
        TestUtils.retry(() -> {
            try {
                ArtifactMetaData actualMD = this.clientV2.getArtifactMetaData(groupId, artifactId);
                Assertions.fail((String)"ArtifactNotFoundException expected");
            }
            catch (ArtifactNotFoundException actualMD) {
                // empty catch block
            }
            VersionMetaData vmd = this.clientV2.getArtifactVersionMetaData(groupId, artifactId, String.valueOf(md.getVersion()));
            Assertions.assertEquals((Object)ArtifactState.DISABLED, (Object)vmd.getState());
        });
    }
}

