/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile;

import io.apicurio.registry.AbstractRegistryTestBase;
import io.apicurio.registry.rules.compatibility.CompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityDifference;
import io.apicurio.registry.rules.compatibility.CompatibilityExecutionResult;
import io.apicurio.registry.rules.compatibility.CompatibilityLevel;
import io.apicurio.registry.rules.compatibility.JsonSchemaCompatibilityDifference;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.Difference;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProviderFactory;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class ArtifactTypeTest
extends AbstractRegistryTestBase {
    @Inject
    ArtifactTypeUtilProviderFactory factory;
    private static String PROTO_DATA = "syntax = \"proto2\";\n\nmessage ProtoSchema {\n  required string message = 1;\n  required int64 time = 2;\n}";
    private static String PROTO_DATA_2 = "syntax = \"proto2\";\n\nmessage ProtoSchema {\n  required string message = 1;\n  required int64 time = 2;\n  required string code = 3;\n}";

    @Test
    public void testAvro() {
        String avroString = "{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}";
        String avro = "AVRO";
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(avro);
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        CompatibilityExecutionResult compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.BACKWARD, Collections.emptyList(), avroString, Collections.emptyMap());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        String avroString2 = "{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\", \"qq\":\"ff\"}]}";
        compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.BACKWARD, Collections.singletonList(avroString), avroString2, Collections.emptyMap());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
    }

    @Test
    public void testJson() {
        String jsonString = "{\n  \"type\": \"object\",\n  \"properties\": {\n    \"age\": {\n      \"description\": \"Age in years which must be equal to or greater than zero.\",\n      \"type\": \"integer\",\n      \"minimum\": 0\n    },\n    \"zipcode\": {\n      \"description\": \"ZipCode\",\n      \"type\": \"integer\"\n    }\n  }\n}";
        String incompatibleJsonString = "{\n  \"type\": \"object\",\n  \"properties\": {\n    \"age\": {\n      \"description\": \"Age in years which must be equal to or greater than zero.\",\n      \"type\": \"string\",\n      \"minimum\": 0\n    },\n    \"zipcode\": {\n      \"description\": \"ZipCode\",\n      \"type\": \"string\"\n    }\n  }\n}";
        String json = "JSON";
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(json);
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        Assertions.assertTrue((boolean)checker.testCompatibility(CompatibilityLevel.BACKWARD, Collections.emptyList(), jsonString, Collections.emptyMap()).isCompatible());
        Assertions.assertTrue((boolean)checker.testCompatibility(CompatibilityLevel.BACKWARD, Collections.singletonList(jsonString), jsonString, Collections.emptyMap()).isCompatible());
        CompatibilityExecutionResult compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.BACKWARD, Collections.singletonList(jsonString), incompatibleJsonString, Collections.emptyMap());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.isCompatible());
        Set incompatibleDifferences = compatibilityExecutionResult.getIncompatibleDifferences();
        Difference ageDiff = this.findDiffByPathUpdated(incompatibleDifferences, "/properties/age");
        Difference zipCodeDiff = this.findDiffByPathUpdated(incompatibleDifferences, "/properties/zipcode");
        Assertions.assertEquals((Object)DiffType.SUBSCHEMA_TYPE_CHANGED.getDescription(), (Object)ageDiff.getDiffType().getDescription());
        Assertions.assertEquals((Object)"/properties/age", (Object)ageDiff.getPathUpdated());
        Assertions.assertEquals((Object)DiffType.SUBSCHEMA_TYPE_CHANGED.getDescription(), (Object)zipCodeDiff.getDiffType().getDescription());
        Assertions.assertEquals((Object)"/properties/zipcode", (Object)zipCodeDiff.getPathUpdated());
    }

    private Difference findDiffByPathUpdated(Set<CompatibilityDifference> incompatibleDifferences, String path) {
        for (CompatibilityDifference cd : incompatibleDifferences) {
            JsonSchemaCompatibilityDifference jsonSchemaCompatibilityDifference = (JsonSchemaCompatibilityDifference)cd;
            Difference diff = jsonSchemaCompatibilityDifference.getDifference();
            if (!diff.getPathUpdated().equals(path)) continue;
            return diff;
        }
        return null;
    }

    @Test
    public void testProtobuf() {
        String data = "syntax = \"proto3\";\npackage test;\n\nmessage Channel {\n  int64 id = 1;\n  string name = 2;\n  string description = 3;\n}\n\nmessage NextRequest {}\nmessage PreviousRequest {}\n\nservice ChannelChanger {\n\trpc Next(stream NextRequest) returns (Channel);\n\trpc Previous(PreviousRequest) returns (stream Channel);\n}\n";
        String protobuf = "PROTOBUF";
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(protobuf);
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        CompatibilityExecutionResult compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.BACKWARD, Collections.emptyList(), data, Collections.emptyMap());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        String data2 = "syntax = \"proto3\";\npackage test;\n\nmessage Channel {\n  int64 id = 1;\n  string name = 2;\n  string description = 3;\n  string newff = 4;\n}\n\nmessage NextRequest {}\nmessage PreviousRequest {}\n\nservice ChannelChanger {\n\trpc Next(stream NextRequest) returns (Channel);\n\trpc Previous(PreviousRequest) returns (stream Channel);\n}\n";
        compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.BACKWARD, Collections.singletonList(data), data2, Collections.emptyMap());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        String data3 = "syntax = \"proto3\";\npackage test;\n\nmessage Channel {\n  int64 id = 1;\n  string name = 2;\n  string description = 4;\n}\n\nmessage NextRequest {}\nmessage PreviousRequest {}\n\nservice ChannelChanger {\n\trpc Next(stream NextRequest) returns (Channel);\n\trpc Previous(PreviousRequest) returns (stream Channel);\n}\n";
        compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.BACKWARD, Collections.singletonList(data), data3, Collections.emptyMap());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        Assertions.assertEquals((Object)"The new version of the protobuf artifact is not backward compatible.", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getDescription());
        Assertions.assertEquals((Object)"/", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getContext());
    }

    @Test
    public void testProtobufV2() {
        String data = "syntax = \"proto2\";\n\nmessage ProtoSchema {\n  required string message = 1;\n  required int64 time = 2;\n}";
        String protobuf = "PROTOBUF";
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(protobuf);
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        CompatibilityExecutionResult compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.BACKWARD, Collections.emptyList(), data, Collections.emptyMap());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        String data2 = "syntax = \"proto2\";\n\nmessage ProtoSchema {\n  required string message = 1;\n  required int64 time = 2;\n  required string code = 3;\n}";
        compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.BACKWARD, Collections.singletonList(data), data2, Collections.emptyMap());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        Assertions.assertEquals((Object)"The new version of the protobuf artifact is not backward compatible.", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getDescription());
        Assertions.assertEquals((Object)"/", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getContext());
    }

    @Test
    public void testProtobufBackwardTransitive() {
        String protobuf = "PROTOBUF";
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(protobuf);
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        CompatibilityExecutionResult compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.BACKWARD_TRANSITIVE, List.of(PROTO_DATA, PROTO_DATA_2), PROTO_DATA_2, Collections.emptyMap());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        Assertions.assertEquals((Object)"The new version of the protobuf artifact is not backward compatible.", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getDescription());
        Assertions.assertEquals((Object)"/", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getContext());
    }

    @Test
    public void testProtobufForward() {
        String protobuf = "PROTOBUF";
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(protobuf);
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        CompatibilityExecutionResult compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.FORWARD, Collections.singletonList(PROTO_DATA_2), PROTO_DATA, Collections.emptyMap());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        Assertions.assertEquals((Object)"The new version of the protobuf artifact is not forward compatible.", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getDescription());
        Assertions.assertEquals((Object)"/", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getContext());
        compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.FORWARD, List.of(PROTO_DATA, PROTO_DATA_2), PROTO_DATA_2, Collections.emptyMap());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
    }

    @Test
    public void testProtobufForwardTransitive() {
        String protobuf = "PROTOBUF";
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(protobuf);
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        CompatibilityExecutionResult compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.FORWARD_TRANSITIVE, List.of(PROTO_DATA_2, PROTO_DATA_2), PROTO_DATA_2, Collections.emptyMap());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.FORWARD_TRANSITIVE, List.of(PROTO_DATA, PROTO_DATA_2), PROTO_DATA_2, Collections.emptyMap());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        Assertions.assertEquals((Object)"The new version of the protobuf artifact is not forward compatible.", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getDescription());
        Assertions.assertEquals((Object)"/", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getContext());
    }

    @Test
    public void testProtobufFull() {
        String protobuf = "PROTOBUF";
        ArtifactTypeUtilProvider provider = this.factory.getArtifactTypeProvider(protobuf);
        CompatibilityChecker checker = provider.getCompatibilityChecker();
        CompatibilityExecutionResult compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.FULL, List.of(PROTO_DATA), PROTO_DATA_2, Collections.emptyMap());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        Assertions.assertEquals((Object)"The new version of the protobuf artifact is not fully compatible.", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getDescription());
        Assertions.assertEquals((Object)"/", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getContext());
        compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.FULL, List.of(PROTO_DATA, PROTO_DATA_2), PROTO_DATA_2, Collections.emptyMap());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertTrue((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        compatibilityExecutionResult = checker.testCompatibility(CompatibilityLevel.FULL_TRANSITIVE, List.of(PROTO_DATA, PROTO_DATA_2), PROTO_DATA_2, Collections.emptyMap());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.isCompatible());
        Assertions.assertFalse((boolean)compatibilityExecutionResult.getIncompatibleDifferences().isEmpty());
        Assertions.assertEquals((Object)"The new version of the protobuf artifact is not fully compatible.", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getDescription());
        Assertions.assertEquals((Object)"/", (Object)((CompatibilityDifference)compatibilityExecutionResult.getIncompatibleDifferences().iterator().next()).asRuleViolation().getContext());
    }
}

