/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile;

import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.rest.v2.beans.ArtifactMetaData;
import io.apicurio.registry.serde.jsonschema.JsonSchemaKafkaDeserializer;
import io.apicurio.registry.serde.jsonschema.JsonSchemaKafkaSerializer;
import io.apicurio.registry.support.Person;
import io.apicurio.registry.utils.tests.TestUtils;
import io.quarkus.test.junit.QuarkusTest;
import java.io.InputStream;
import java.util.Map;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.header.internals.RecordHeaders;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class JsonSerdeTest
extends AbstractResourceTestBase {
    @Test
    public void testSchema() throws Exception {
        String groupId = "JsonSerdeTest_testSchema";
        InputStream jsonSchema = this.getClass().getResourceAsStream("/io/apicurio/registry/util/json-schema.json");
        Assertions.assertNotNull((Object)jsonSchema);
        String artifactId = this.generateArtifactId();
        ArtifactMetaData amd = this.clientV2.createArtifact(groupId, artifactId + "-value", "JSON", jsonSchema);
        TestUtils.retry(() -> this.clientV2.getContentByGlobalId(amd.getGlobalId().longValue()));
        Person person = new Person("Ales", "Justin", 23);
        try (JsonSchemaKafkaSerializer serializer = new JsonSchemaKafkaSerializer(this.clientV2, Boolean.valueOf(true));
             JsonSchemaKafkaDeserializer deserializer = new JsonSchemaKafkaDeserializer(this.clientV2, Boolean.valueOf(true));){
            Map<String, String> configs = Map.of("apicurio.registry.artifact.group-id", groupId);
            serializer.configure(configs, false);
            deserializer.configure(configs, false);
            RecordHeaders headers = new RecordHeaders();
            byte[] bytes = serializer.serialize(artifactId, (Headers)headers, (Object)person);
            person = (Person)deserializer.deserialize(artifactId, (Headers)headers, bytes);
            Assertions.assertEquals((Object)"Ales", (Object)person.getFirstName());
            Assertions.assertEquals((Object)"Justin", (Object)person.getLastName());
            Assertions.assertEquals((int)23, (int)person.getAge());
            person.setAge(-1);
            try {
                serializer.serialize(artifactId, (Headers)new RecordHeaders(), (Object)person);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
            serializer.setValidationEnabled(Boolean.valueOf(false));
            bytes = serializer.serialize(artifactId, (Headers)headers, (Object)person);
            try {
                deserializer.deserialize(artifactId, (Headers)headers, bytes);
                Assertions.fail();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

