/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.ccompat.rest.v6;

import com.google.protobuf.Message;
import io.apicurio.registry.AbstractResourceTestBase;
import io.apicurio.registry.ccompat.dto.SchemaContent;
import io.apicurio.registry.rest.v2.beans.Rule;
import io.apicurio.registry.support.HealthUtils;
import io.apicurio.registry.support.TestCmmn;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.utils.tests.TestUtils;
import io.confluent.connect.avro.AvroConverter;
import io.confluent.kafka.schemaregistry.ParsedSchema;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchema;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.serializers.KafkaAvroDeserializer;
import io.confluent.kafka.serializers.KafkaAvroSerializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaDeserializer;
import io.confluent.kafka.serializers.json.KafkaJsonSchemaSerializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import io.quarkus.test.junit.QuarkusTest;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
public class ConfluentClientTest
extends AbstractResourceTestBase {
    public SchemaRegistryClient buildClient() {
        List<SchemaProvider> schemaProviders = Arrays.asList(new JsonSchemaProvider(), new AvroSchemaProvider(), new ProtobufSchemaProvider());
        return new CachedSchemaRegistryClient(new RestService("http://localhost:" + this.testPort + "/apis/ccompat/v6"), 3, schemaProviders, null, null);
    }

    @Test
    public void testSmoke() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        Collection subjects = client.getAllSubjects();
        Assertions.assertNotNull((Object)subjects);
    }

    @Test
    public void testSimpleOps() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        AvroSchema schema1 = new AvroSchema("{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}");
        int id1 = client.register(subject, (ParsedSchema)schema1);
        client.reset();
        TestUtils.retry(() -> client.getSchemaById(id1));
        AvroSchema schema2 = new AvroSchema("{\"type\":\"record\",\"name\":\"myrecord2\",\"fields\":[{\"name\":\"f2\",\"type\":\"string\"}]}");
        int id2 = client.register(subject, (ParsedSchema)schema2);
        TestUtils.retry(() -> client.getSchemaById(id2));
        ParsedSchema schema = client.getSchemaById(id1);
        Assertions.assertNotNull((Object)schema);
        client.reset();
        Assertions.assertTrue((boolean)client.testCompatibility(subject, (ParsedSchema)schema2));
        TestUtils.retry(() -> {
            ParsedSchema schema3 = client.getSchemaById(id2);
            Assertions.assertNotNull((Object)schema3);
            return schema3;
        });
        Collection subjects = client.getAllSubjects();
        Assertions.assertTrue((boolean)subjects.contains(subject));
        List versions = client.getAllVersions(subject);
        Assertions.assertTrue((boolean)versions.contains(1));
        Assertions.assertTrue((boolean)versions.contains(2));
        int v2 = client.getVersion(subject, (ParsedSchema)schema2);
        Assertions.assertEquals((int)2, (int)v2);
        int d1 = client.deleteSchemaVersion(subject, "1");
        Assertions.assertEquals((int)1, (int)d1);
        int d2 = client.deleteSchemaVersion(subject, "2");
        Assertions.assertEquals((int)2, (int)d2);
    }

    @Test
    public void testSerdeAvro() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        String rawSchema = "{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}";
        AvroSchema schema = new AvroSchema(rawSchema);
        int id = client.register(subject + "-value", (ParsedSchema)schema);
        client.reset();
        TestUtils.retry(() -> {
            ParsedSchema schema2 = client.getSchemaById(id);
            Assertions.assertNotNull((Object)schema2);
            return schema2;
        });
        try (KafkaAvroSerializer serializer = new KafkaAvroSerializer(client);
             KafkaAvroDeserializer deserializer = new KafkaAvroDeserializer(client);){
            GenericData.Record record = new GenericData.Record(new Schema.Parser().parse(rawSchema));
            record.put("bar", (Object)"somebar");
            byte[] bytes = serializer.serialize(subject, (Object)record);
            GenericData.Record ir = (GenericData.Record)deserializer.deserialize(subject, bytes);
            Assertions.assertEquals((Object)"somebar", (Object)ir.get("bar").toString());
        }
    }

    @Test
    public void testSerdeJsonSchema() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        SchemaContent schemaContent = new SchemaContent("{\"type\":\"record\",\"name\":\"myrecord1\",\"fields\":[{\"name\":\"f1\",\"type\":\"string\"}]}");
        Properties config = new Properties();
        config.put("auto.register.schemas", (Object)true);
        config.put("schema.registry.url", "http://localhost:" + this.testPort + "/apis/ccompat/v6");
        try (KafkaJsonSchemaSerializer serializer = new KafkaJsonSchemaSerializer(client, new HashMap<Object, Object>(config));
             KafkaJsonSchemaDeserializer deserializer = new KafkaJsonSchemaDeserializer(client, (Map)config, SchemaContent.class);){
            byte[] bytes = serializer.serialize(subject, (Object)schemaContent);
            Object deserialized = deserializer.deserialize(subject, bytes);
            Assertions.assertEquals((Object)schemaContent, (Object)deserialized);
        }
    }

    @Test
    public void testSerdeProtobufSchema() throws Exception {
        TestCmmn.UUID record = TestCmmn.UUID.newBuilder().setLsb(2L).setMsb(1L).build();
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("auto.register.schemas", true);
        config.put("schema.registry.url", "http://localhost:" + this.testPort + "/apis/ccompat/v6");
        config.put("specific.protobuf.value.type", TestCmmn.UUID.class.getName());
        try (KafkaProtobufSerializer serializer = new KafkaProtobufSerializer(client);
             KafkaProtobufDeserializer deserializer = new KafkaProtobufDeserializer(client);){
            serializer.configure(config, false);
            deserializer.configure(config, false);
            byte[] bytes = serializer.serialize(subject, (Message)record);
            TestCmmn.UUID deserialized = (TestCmmn.UUID)deserializer.deserialize(subject, bytes);
            Assertions.assertEquals((Object)record, (Object)deserialized);
        }
    }

    @Test
    public void testDelete() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        String nonExisting = this.generateArtifactId();
        try {
            client.deleteSubject(nonExisting);
            Assertions.fail();
        }
        catch (RestClientException e) {
            Assertions.assertEquals((int)404, (int)e.getStatus());
        }
        TestUtils.retry(() -> {
            HealthUtils.assertIsReady(this.testPort);
            HealthUtils.assertIsLive(this.testPort);
        });
        String subject = this.generateArtifactId();
        AvroSchema schema = new AvroSchema("{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        int id = client.register(subject, (ParsedSchema)schema);
        client.reset();
        TestUtils.retry(() -> {
            ParsedSchema schema2 = client.getSchemaById(id);
            Assertions.assertNotNull((Object)schema2);
            return schema2;
        });
        Collection subjects = client.getAllSubjects();
        Assertions.assertTrue((boolean)subjects.contains(subject));
        client.deleteSubject(subject);
        TestUtils.retry(() -> {
            Collection all = client.getAllSubjects();
            Assertions.assertFalse((boolean)all.contains(subject));
            return null;
        });
    }

    @Test
    public void testGlobalRule() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        Rule rule = new Rule();
        rule.setType(RuleType.COMPATIBILITY);
        rule.setConfig("BACKWARD");
        this.adminClientV2.createGlobalRule(rule);
        String subject = this.generateArtifactId();
        AvroSchema schema = new AvroSchema("{\"type\":\"record\",\"name\":\"myrecord3\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}]}");
        int id = client.register(subject, (ParsedSchema)schema);
        client.reset();
        TestUtils.retry(() -> {
            ParsedSchema schema2 = client.getSchemaById(id);
            Assertions.assertNotNull((Object)schema2);
            return schema2;
        });
        Assertions.assertThrows(RestClientException.class, () -> {
            AvroSchema schema2 = new AvroSchema("{\"type\":\"string\"}");
            client.register(subject, (ParsedSchema)schema2);
            client.reset();
        });
    }

    @Test
    public void testConverter_PreRegisterSchema() {
        String subject = this.generateArtifactId();
        String name = "myr" + ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE);
        this.testConverter(subject, name, false, client -> {
            try {
                AvroSchema schema = new AvroSchema(String.format("{\"type\":\"record\",\"name\":\"%s\",\"fields\":[{\"name\":\"bar\",\"type\":\"string\"}],\"connect.name\":\"%s\"}", name, name));
                int id = client.register(subject + "-value", (ParsedSchema)schema);
                client.reset();
                ParsedSchema retry = (ParsedSchema)TestUtils.retry(() -> client.getSchemaById(id));
                Assertions.assertNotNull((Object)retry);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }, (c, b) -> {});
    }

    @Test
    public void testConverter_AutoRegisterSchema() {
        String name = "myr" + ThreadLocalRandom.current().nextInt(0, Integer.MAX_VALUE);
        this.testConverter(this.generateArtifactId(), name, true, c -> {}, (client, bytes) -> {
            try {
                client.reset();
                ParsedSchema retry = (ParsedSchema)TestUtils.retry(() -> {
                    ByteBuffer buffer = ByteBuffer.wrap(bytes);
                    buffer.get();
                    int id = buffer.getInt();
                    return client.getSchemaById(id);
                });
                Assertions.assertNotNull((Object)retry);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private void testConverter(String subject, String name, boolean autoRegister, Consumer<SchemaRegistryClient> pre, BiConsumer<SchemaRegistryClient, byte[]> post) {
        SchemaRegistryClient client = this.buildClient();
        pre.accept(client);
        SchemaBuilder cs = SchemaBuilder.struct().name(name).field("bar", Schema.STRING_SCHEMA);
        Struct struct = new Struct((Schema)cs);
        struct.put("bar", (Object)"somebar");
        AvroConverter converter = new AvroConverter(client);
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("schema.registry.url", "dummy");
        config.put("auto.register.schemas", autoRegister);
        converter.configure(config, false);
        byte[] bytes = converter.fromConnectData(subject, (Schema)cs, (Object)struct);
        post.accept(client, bytes);
        SchemaAndValue sav = converter.toConnectData(subject, bytes);
        Struct ir = (Struct)sav.value();
        Assertions.assertEquals((Object)"somebar", (Object)ir.get("bar").toString());
    }

    @Test
    public void testSimpleAvroSchema() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        AvroSchema schema1 = new AvroSchema("\"string\"");
        int id1 = client.register(subject, (ParsedSchema)schema1);
        client.reset();
        TestUtils.retry(() -> client.getSchemaById(id1));
        AvroSchema schema2 = new AvroSchema("{\"type\":\"string\"}");
        int id2 = client.register(subject, (ParsedSchema)schema2);
        TestUtils.retry(() -> client.getSchemaById(id2));
    }

    @Test
    public void testCreateRuleBeforeSchema() throws Exception {
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        client.updateCompatibility(subject, "FULL");
        AvroSchema schema1 = new AvroSchema("\"string\"");
        int id1 = client.register(subject, (ParsedSchema)schema1);
        client.reset();
        TestUtils.retry(() -> client.getSchemaById(id1));
        AvroSchema schema2 = new AvroSchema("{\"type\":\"string\"}");
        int id2 = client.register(subject, (ParsedSchema)schema2);
        TestUtils.retry(() -> client.getSchemaById(id2));
    }
}

