/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.noprofile.ccompat.rest.v7;

import com.google.protobuf.Message;
import io.apicurio.registry.noprofile.ccompat.rest.v6.ConfluentClientTest;
import io.apicurio.registry.support.TestCmmn;
import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.client.CachedSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.rest.RestService;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufDeserializer;
import io.confluent.kafka.serializers.protobuf.KafkaProtobufSerializer;
import io.quarkus.test.junit.QuarkusTest;
import jakarta.enterprise.inject.Typed;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@QuarkusTest
@Typed(value={ConfluentClientV7Test.class})
public class ConfluentClientV7Test
extends ConfluentClientTest {
    @Override
    public SchemaRegistryClient buildClient() {
        List<SchemaProvider> schemaProviders = Arrays.asList(new JsonSchemaProvider(), new AvroSchemaProvider(), new ProtobufSchemaProvider());
        return new CachedSchemaRegistryClient(new RestService("http://localhost:" + this.testPort + "/apis/ccompat/v7"), 3, schemaProviders, null, Map.of("X-Registry-GroupId", "confluentV7-test-group"));
    }

    @Override
    @Test
    public void testSerdeProtobufSchema() throws Exception {
        TestCmmn.UUID record = TestCmmn.UUID.newBuilder().setLsb(2L).setMsb(1L).build();
        SchemaRegistryClient client = this.buildClient();
        String subject = this.generateArtifactId();
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("auto.register.schemas", true);
        config.put("schema.registry.url", "http://localhost:" + this.testPort + "/apis/ccompat/v7");
        config.put("specific.protobuf.value.type", TestCmmn.UUID.class.getName());
        try (KafkaProtobufSerializer serializer = new KafkaProtobufSerializer(client);
             KafkaProtobufDeserializer deserializer = new KafkaProtobufDeserializer(client);){
            serializer.configure(config, false);
            deserializer.configure(config, false);
            byte[] bytes = serializer.serialize(subject, (Message)record);
            TestCmmn.UUID deserialized = (TestCmmn.UUID)deserializer.deserialize(subject, bytes);
            Assertions.assertEquals((Object)record, (Object)deserialized);
        }
    }
}

